/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client.messages.outbound;

import com.amazon.jdbc.communications.interfaces.AbstractOutboundMessage;
import com.amazon.redshift.client.PGConstants;
import com.amazon.redshift.core.IPGLogger;
import java.nio.ByteBuffer;

public class Close
extends AbstractOutboundMessage
implements PGConstants {
    private static byte CLOSE_TYPE_PORTAL = (byte)80;
    private static byte CLOSE_TYPE_PREPARED_STATEMENT = (byte)83;
    private final byte[] m_portalOrPreparedStatementName;
    private final CloseType m_type;

    public Close(byte[] byArray, CloseType closeType, IPGLogger iPGLogger) {
        this.m_portalOrPreparedStatementName = byArray;
        this.m_type = closeType;
        if (iPGLogger.isExternalLoggerEnabled()) {
            this.logMessageContent(iPGLogger);
        }
    }

    @Override
    public void serialize(ByteBuffer byteBuffer, byte[] byArray) {
        byteBuffer.put((byte)67);
        byteBuffer.put(byArray);
        switch (this.m_type) {
            case PORTAL: {
                byteBuffer.put(CLOSE_TYPE_PORTAL);
                break;
            }
            case PREPARED_STATEMENT: {
                byteBuffer.put(CLOSE_TYPE_PREPARED_STATEMENT);
            }
        }
        if (null != this.m_portalOrPreparedStatementName) {
            byteBuffer.put(this.m_portalOrPreparedStatementName);
        }
        byteBuffer.put(TERMINATOR);
    }

    @Override
    public int getSize() {
        return 5 + (this.m_portalOrPreparedStatementName != null ? this.m_portalOrPreparedStatementName.length : 0) + 1;
    }

    public void logMessageContent(IPGLogger iPGLogger) {
        String string = this.m_type.name().toLowerCase();
        String string2 = null;
        if (null != this.m_portalOrPreparedStatementName) {
            string2 = new String(this.m_portalOrPreparedStatementName);
        }
        String string3 = "=>FE Close(" + string + "=" + string2 + ")";
        iPGLogger.logDebugExternal(string3);
    }

    public static enum CloseType {
        PORTAL,
        PREPARED_STATEMENT;

    }
}

