/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.etree.value.scalar;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.amazon.sqlengine.executor.etree.ETDataRequest;
import com.amazon.sqlengine.executor.etree.value.ETValueExpr;
import com.amazon.sqlengine.executor.etree.value.scalar.ETScalarFn;
import com.amazon.support.exceptions.ErrorException;
import java.util.List;

public final class ETLeftFn
extends ETScalarFn {
    private final long m_columnLength;

    public ETLeftFn(IColumn iColumn, List<ETValueExpr> list, List<IColumn> list2) throws ErrorException {
        super(iColumn, list, list2);
        assert (2 == list.size());
        assert (list2.get(0).getTypeMetadata().isCharacterType());
        assert (list2.get(1).getTypeMetadata().isIntegerType());
        assert (iColumn.getTypeMetadata().isCharacterType());
        this.m_columnLength = iColumn.getColumnLength();
    }

    @Override
    public String getLogString() {
        return "ETLeftFn";
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        long l;
        long l2;
        ISqlDataWrapper iSqlDataWrapper = this.getArgumentData(1);
        if (iSqlDataWrapper.isNull()) {
            eTDataRequest.getData().setNull();
            return false;
        }
        long l3 = eTDataRequest.getOffset();
        long l4 = eTDataRequest.getMaxSize();
        boolean bl = -1L == l4;
        long l5 = iSqlDataWrapper.getInteger();
        if (0L >= l5 || l3 / 2L >= l5) {
            l2 = 0L;
            l = 0L;
        } else {
            l = Math.min(this.m_columnLength, l5 - l3 / 2L);
            l2 = 2L * l;
            if (!bl && l4 < l2) {
                l2 = l4;
            }
        }
        ISqlDataWrapper iSqlDataWrapper2 = this.getArgumentData(0, l3, l2);
        if (iSqlDataWrapper2.isNull()) {
            eTDataRequest.getData().setNull();
            return false;
        }
        String string = iSqlDataWrapper2.getChar();
        eTDataRequest.getData().setChar(string);
        assert ((long)string.length() <= l) : "Incorrect length";
        return !bl && l2 < 2L * l && this.hasMoreData(0);
    }
}

