/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.impl.ICache;
import com.hp.hpl.jena.db.impl.IDBID;
import com.hp.hpl.jena.util.CollectionFactory;
import java.util.Map;

public class SimpleCache
implements ICache {
    protected Map cache = CollectionFactory.createHashedMap();
    protected int threshold;
    protected int count = 0;

    public SimpleCache(int threshold) {
        this.threshold = threshold;
    }

    public void put(IDBID id, Object val) {
        if (this.threshold == 0) {
            return;
        }
        if (this.threshold > 0 && this.count >= this.threshold) {
            this.cache = CollectionFactory.createHashedMap();
            this.count = 0;
        }
        ++this.count;
        this.cache.put(id, val);
    }

    public Object get(IDBID id) {
        return this.cache.get(id);
    }

    public void setLimit(int threshold) {
        this.threshold = threshold;
        if (threshold >= 0 && this.count > threshold) {
            this.cache = CollectionFactory.createHashedMap();
            this.count = 0;
        }
    }

    public int getLimit() {
        return this.threshold;
    }
}

