/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.ImbalancedClassification.Auxiliar.AUC;

import java.util.Arrays;
import keel.Algorithms.ImbalancedClassification.Auxiliar.AUC.PosProb;

public class CalculateAUC {
    public static double calculate(PosProb[] probs) {
        double auc = 0.0;
        if (probs != null) {
            Arrays.sort(probs);
            int pos = 0;
            int neg = 0;
            for (PosProb pair : probs) {
                if (pair.isPositiveInstance()) {
                    ++pos;
                    continue;
                }
                ++neg;
            }
            if (pos != 0 && neg != 0) {
                double prevTPR = 0.0;
                double prevFPR = 0.0;
                double tp = 0.0;
                double fp = 0.0;
                double prevProb = Double.NEGATIVE_INFINITY;
                for (int j = 0; j < probs.length; ++j) {
                    PosProb el = probs[j];
                    double prob = el.getProb();
                    if (prob != prevProb) {
                        double currTPR = tp / (double)pos;
                        double currFPR = fp / (double)neg;
                        double term = (prevTPR + currTPR) * (currFPR - prevFPR) / 2.0;
                        auc += term;
                        prevTPR = currTPR;
                        prevFPR = currFPR;
                        prevProb = prob;
                    }
                    if (el.isPositiveInstance()) {
                        tp += 1.0;
                        continue;
                    }
                    fp += 1.0;
                }
                auc += (prevTPR + 1.0) * (1.0 - prevFPR) / 2.0;
            }
        }
        return auc;
    }
}

