/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Statistical_Classifiers.Logistic;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import keel.Algorithms.Statistical_Classifiers.Logistic.core.Optimization;
import keel.Algorithms.Statistical_Classifiers.Logistic.core.Option;
import keel.Algorithms.Statistical_Classifiers.Logistic.core.OptionHandler;
import keel.Algorithms.Statistical_Classifiers.Logistic.core.TechnicalInformation;
import keel.Algorithms.Statistical_Classifiers.Logistic.core.TechnicalInformationHandler;
import keel.Algorithms.Statistical_Classifiers.Logistic.core.Utils;
import keel.Algorithms.Statistical_Classifiers.Logistic.core.WeightedInstancesHandler;
import keel.Dataset.Attribute;
import keel.Dataset.Attributes;
import keel.Dataset.Instance;
import keel.Dataset.InstanceAttributes;
import keel.Dataset.InstanceSet;
import org.core.Fichero;

public class Logistic
implements OptionHandler,
WeightedInstancesHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = 3932117032546553727L;
    protected double[][] m_Par;
    protected double[][] m_Data;
    protected int m_NumPredictors;
    protected int m_ClassIndex;
    protected int m_NumClasses;
    protected double m_Ridge = 1.0E-8;
    protected boolean m_Debug;
    protected double m_LL;
    private int m_MaxIts = -1;
    String input_train_name = new String();
    String input_validation_name;
    String input_test_name = new String();
    String output_train_name = new String();
    String output_test_name = new String();
    String temp = new String();
    String data_out = new String("");

    public Logistic(String fileParam) {
        this.config_read(fileParam);
    }

    public Logistic() {
    }

    public String globalInfo() {
        return "Class for building and using a multinomial logistic regression model with a ridge estimator.\n\nThere are some modifications, however, compared to the paper of leCessie and van Houwelingen(1992): \n\nIf there are k classes for n instances with m attributes, the parameter matrix B to be calculated will be an m*(k-1) matrix.\n\nThe probability for class j with the exception of the last class is\n\nPj(Xi) = exp(XiBj)/((sum[j=1..(k-1)]exp(Xi*Bj))+1) \n\nThe last class has probability\n\n1-(sum[j=1..(k-1)]Pj(Xi)) \n\t= 1/((sum[j=1..(k-1)]exp(Xi*Bj))+1)\n\nThe (negative) multinomial log-likelihood is thus: \n\nL = -sum[i=1..n]{\n\tsum[j=1..(k-1)](Yij * ln(Pj(Xi)))\n\t+(1 - (sum[j=1..(k-1)]Yij)) \n\t* ln(1 - sum[j=1..(k-1)]Pj(Xi))\n\t} + ridge * (B^2)\n\nIn order to find the matrix B for which L is minimised, a Quasi-Newton Method is used to search for the optimized values of the m*(k-1) variables.  Note that before we use the optimization procedure, we 'squeeze' the matrix B into a m*(k-1) vector.  For details of the optimization procedure, please check keel.Algorithms.Statistical_Classifiers.Logistic.core.Optimization class.\n\nAlthough original Logistic Regression does not deal with instance weights, we modify the algorithm a little bit to handle the instance weights.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString() + "\n\n" + "Note: Missing values are replaced using a ReplaceMissingValuesFilter, and " + "nominal attributes are transformed into numeric attributes using a " + "NominalToBinaryFilter.";
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "le Cessie, S. and van Houwelingen, J.C.");
        result.setValue(TechnicalInformation.Field.YEAR, "1992");
        result.setValue(TechnicalInformation.Field.TITLE, "Ridge Estimators in Logistic Regression");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Applied Statistics");
        result.setValue(TechnicalInformation.Field.VOLUME, "41");
        result.setValue(TechnicalInformation.Field.NUMBER, "1");
        result.setValue(TechnicalInformation.Field.PAGES, "191-201");
        return result;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(3);
        newVector.addElement(new Option("\tTurn on debugging output.", "D", 0, "-D"));
        newVector.addElement(new Option("\tSet the ridge in the log-likelihood.", "R", 1, "-R <ridge>"));
        newVector.addElement(new Option("\tSet the maximum number of iterations (default -1, until convergence).", "M", 1, "-M <number>"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.setDebug(Utils.getFlag('D', options));
        String ridgeString = Utils.getOption('R', options);
        this.m_Ridge = ridgeString.length() != 0 ? Double.parseDouble(ridgeString) : 1.0E-8;
        String maxItsString = Utils.getOption('M', options);
        this.m_MaxIts = maxItsString.length() != 0 ? Integer.parseInt(maxItsString) : -1;
    }

    @Override
    public String[] getOptions() {
        String[] options = new String[5];
        int current = 0;
        if (this.getDebug()) {
            options[current++] = "-D";
        }
        options[current++] = "-R";
        options[current++] = "" + this.m_Ridge;
        options[current++] = "-M";
        options[current++] = "" + this.m_MaxIts;
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public String debugTipText() {
        return "Output debug information to the console.";
    }

    public void setDebug(boolean debug) {
        this.m_Debug = debug;
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public String ridgeTipText() {
        return "Set the Ridge value in the log-likelihood.";
    }

    public void setRidge(double ridge) {
        this.m_Ridge = ridge;
    }

    public double getRidge() {
        return this.m_Ridge;
    }

    public String maxItsTipText() {
        return "Maximum number of iterations to perform.";
    }

    public int getMaxIts() {
        return this.m_MaxIts;
    }

    public void setMaxIts(int newMaxIts) {
        this.m_MaxIts = newMaxIts;
    }

    public void buildClassifier(InstanceSet train) throws Exception {
        int j;
        int i;
        Attribute salida = Attributes.getOutputAttribute(0);
        this.m_ClassIndex = Attributes.getInputNumAttributes();
        this.m_NumClasses = salida.getNumNominalValues();
        int nK = this.m_NumClasses - 1;
        int nR = this.m_NumPredictors = Attributes.getInputNumAttributes();
        int nC = train.getNumInstances();
        this.m_Data = new double[nC][nR + 1];
        int[] Y = new int[nC];
        double[] xMean = new double[nR + 1];
        double[] xSD = new double[nR + 1];
        double[] sY = new double[nK + 1];
        double[] weights = new double[nC];
        double totWeights = 0.0;
        this.m_Par = new double[nR + 1][nK];
        if (this.m_Debug) {
            System.out.println("Extracting data...");
        }
        for (i = 0; i < nC; ++i) {
            Instance current = train.getInstance(i);
            Y[i] = (int)current.getAllOutputValues()[0];
            weights[i] = 1.0;
            totWeights += weights[i];
            this.m_Data[i][0] = 1.0;
            int j2 = 1;
            for (int k = 0; k <= nR; ++k) {
                double x;
                if (k == this.m_ClassIndex) continue;
                this.m_Data[i][j2] = x = current.getAllInputValues()[k];
                int n = j2;
                xMean[n] = xMean[n] + weights[i] * x;
                int n2 = j2++;
                xSD[n2] = xSD[n2] + weights[i] * x * x;
            }
            int n = Y[i];
            sY[n] = sY[n] + 1.0;
        }
        if (totWeights <= 1.0 && nC > 1) {
            throw new Exception("Sum of weights of instances less than 1, please reweight!");
        }
        xMean[0] = 0.0;
        xSD[0] = 1.0;
        for (j = 1; j <= nR; ++j) {
            xMean[j] = xMean[j] / totWeights;
            xSD[j] = totWeights > 1.0 ? Math.sqrt(Math.abs(xSD[j] - totWeights * xMean[j] * xMean[j]) / (totWeights - 1.0)) : 0.0;
        }
        if (this.m_Debug) {
            System.out.println("Descriptives...");
            for (int m = 0; m <= nK; ++m) {
                System.out.println(sY[m] + " cases have class " + m);
            }
            System.out.println("\n Variable     Avg       SD    ");
            for (j = 1; j <= nR; ++j) {
                System.out.println(Utils.doubleToString(j, 8, 4) + Utils.doubleToString(xMean[j], 10, 4) + Utils.doubleToString(xSD[j], 10, 4));
            }
        }
        for (i = 0; i < nC; ++i) {
            for (int j3 = 0; j3 <= nR; ++j3) {
                if (xSD[j3] == 0.0) continue;
                this.m_Data[i][j3] = (this.m_Data[i][j3] - xMean[j3]) / xSD[j3];
            }
        }
        if (this.m_Debug) {
            System.out.println("\nIteration History...");
        }
        double[] x = new double[(nR + 1) * nK];
        double[][] b = new double[2][x.length];
        for (int p = 0; p < nK; ++p) {
            int offset = p * (nR + 1);
            x[offset] = Math.log(sY[p] + 1.0) - Math.log(sY[nK] + 1.0);
            b[0][offset] = Double.NaN;
            b[1][offset] = Double.NaN;
            for (int q = 1; q <= nR; ++q) {
                x[offset + q] = 0.0;
                b[0][offset + q] = Double.NaN;
                b[1][offset + q] = Double.NaN;
            }
        }
        OptEng opt = new OptEng();
        opt.setDebug(this.m_Debug);
        opt.setWeights(weights);
        opt.setClassLabels(Y);
        if (this.m_MaxIts == -1) {
            x = opt.findArgmin(x, b);
            while (x == null) {
                x = opt.getVarbValues();
                if (this.m_Debug) {
                    System.out.println("200 iterations finished, not enough!");
                }
                x = opt.findArgmin(x, b);
            }
            if (this.m_Debug) {
                System.out.println(" -------------<Converged>--------------");
            }
        } else {
            opt.setMaxIteration(this.m_MaxIts);
            x = opt.findArgmin(x, b);
            if (x == null) {
                x = opt.getVarbValues();
            }
        }
        this.m_LL = -opt.getMinFunction();
        this.m_Data = null;
        for (int i2 = 0; i2 < nK; ++i2) {
            this.m_Par[0][i2] = x[i2 * (nR + 1)];
            for (int j4 = 1; j4 <= nR; ++j4) {
                this.m_Par[j4][i2] = x[i2 * (nR + 1) + j4];
                if (xSD[j4] == 0.0) continue;
                double[] dArray = this.m_Par[j4];
                int n = i2;
                dArray[n] = dArray[n] / xSD[j4];
                double[] dArray2 = this.m_Par[0];
                int n3 = i2;
                dArray2[n3] = dArray2[n3] - this.m_Par[j4][i2] * xMean[j4];
            }
        }
    }

    public void buildClassifier(InstanceSet train, InstanceAttributes ats) throws Exception {
        int j;
        int i;
        Attribute salida = ats.getOutputAttribute(0);
        this.m_ClassIndex = ats.getInputNumAttributes();
        this.m_NumClasses = salida.getNumNominalValues();
        int nK = this.m_NumClasses - 1;
        int nR = this.m_NumPredictors = ats.getInputNumAttributes();
        int nC = train.getNumInstances();
        this.m_Data = new double[nC][nR + 1];
        int[] Y = new int[nC];
        double[] xMean = new double[nR + 1];
        double[] xSD = new double[nR + 1];
        double[] sY = new double[nK + 1];
        double[] weights = new double[nC];
        double totWeights = 0.0;
        this.m_Par = new double[nR + 1][nK];
        if (this.m_Debug) {
            System.out.println("Extracting data...");
        }
        for (i = 0; i < nC; ++i) {
            Instance current = train.getInstance(i);
            Y[i] = (int)current.getAllOutputValues()[0];
            weights[i] = 1.0;
            totWeights += weights[i];
            this.m_Data[i][0] = 1.0;
            int j2 = 1;
            for (int k = 0; k <= nR; ++k) {
                double x;
                if (k == this.m_ClassIndex) continue;
                this.m_Data[i][j2] = x = current.getAllInputValues()[k];
                int n = j2;
                xMean[n] = xMean[n] + weights[i] * x;
                int n2 = j2++;
                xSD[n2] = xSD[n2] + weights[i] * x * x;
            }
            int n = Y[i];
            sY[n] = sY[n] + 1.0;
        }
        if (totWeights <= 1.0 && nC > 1) {
            throw new Exception("Sum of weights of instances less than 1, please reweight!");
        }
        xMean[0] = 0.0;
        xSD[0] = 1.0;
        for (j = 1; j <= nR; ++j) {
            xMean[j] = xMean[j] / totWeights;
            xSD[j] = totWeights > 1.0 ? Math.sqrt(Math.abs(xSD[j] - totWeights * xMean[j] * xMean[j]) / (totWeights - 1.0)) : 0.0;
        }
        if (this.m_Debug) {
            System.out.println("Descriptives...");
            for (int m = 0; m <= nK; ++m) {
                System.out.println(sY[m] + " cases have class " + m);
            }
            System.out.println("\n Variable     Avg       SD    ");
            for (j = 1; j <= nR; ++j) {
                System.out.println(Utils.doubleToString(j, 8, 4) + Utils.doubleToString(xMean[j], 10, 4) + Utils.doubleToString(xSD[j], 10, 4));
            }
        }
        for (i = 0; i < nC; ++i) {
            for (int j3 = 0; j3 <= nR; ++j3) {
                if (xSD[j3] == 0.0) continue;
                this.m_Data[i][j3] = (this.m_Data[i][j3] - xMean[j3]) / xSD[j3];
            }
        }
        if (this.m_Debug) {
            System.out.println("\nIteration History...");
        }
        double[] x = new double[(nR + 1) * nK];
        double[][] b = new double[2][x.length];
        for (int p = 0; p < nK; ++p) {
            int offset = p * (nR + 1);
            x[offset] = Math.log(sY[p] + 1.0) - Math.log(sY[nK] + 1.0);
            b[0][offset] = Double.NaN;
            b[1][offset] = Double.NaN;
            for (int q = 1; q <= nR; ++q) {
                x[offset + q] = 0.0;
                b[0][offset + q] = Double.NaN;
                b[1][offset + q] = Double.NaN;
            }
        }
        OptEng opt = new OptEng();
        opt.setDebug(this.m_Debug);
        opt.setWeights(weights);
        opt.setClassLabels(Y);
        if (this.m_MaxIts == -1) {
            x = opt.findArgmin(x, b);
            while (x == null) {
                x = opt.getVarbValues();
                if (this.m_Debug) {
                    System.out.println("200 iterations finished, not enough!");
                }
                x = opt.findArgmin(x, b);
            }
            if (this.m_Debug) {
                System.out.println(" -------------<Converged>--------------");
            }
        } else {
            opt.setMaxIteration(this.m_MaxIts);
            x = opt.findArgmin(x, b);
            if (x == null) {
                x = opt.getVarbValues();
            }
        }
        this.m_LL = -opt.getMinFunction();
        this.m_Data = null;
        for (int i2 = 0; i2 < nK; ++i2) {
            this.m_Par[0][i2] = x[i2 * (nR + 1)];
            for (int j4 = 1; j4 <= nR; ++j4) {
                this.m_Par[j4][i2] = x[i2 * (nR + 1) + j4];
                if (xSD[j4] == 0.0) continue;
                double[] dArray = this.m_Par[j4];
                int n = i2;
                dArray[n] = dArray[n] / xSD[j4];
                double[] dArray2 = this.m_Par[0];
                int n3 = i2;
                dArray2[n3] = dArray2[n3] - this.m_Par[j4][i2] * xMean[j4];
            }
        }
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] instDat = new double[this.m_NumPredictors + 1];
        int j = 1;
        instDat[0] = 1.0;
        for (int k = 0; k <= this.m_NumPredictors; ++k) {
            if (k == this.m_ClassIndex) continue;
            instDat[j++] = instance.getAllInputValues()[k];
        }
        double[] distribution = this.evaluateProbability(instDat);
        return distribution;
    }

    public double[] distributionForInstance(double[] values) throws Exception {
        double[] instDat = new double[this.m_NumPredictors + 1];
        int j = 1;
        instDat[0] = 1.0;
        for (int k = 0; k <= this.m_NumPredictors; ++k) {
            if (k == this.m_ClassIndex) continue;
            instDat[j++] = values[k];
        }
        double[] distribution = this.evaluateProbability(instDat);
        return distribution;
    }

    private double[] evaluateProbability(double[] data) {
        double[] prob = new double[this.m_NumClasses];
        double[] v = new double[this.m_NumClasses];
        for (int j = 0; j < this.m_NumClasses - 1; ++j) {
            for (int k = 0; k <= this.m_NumPredictors; ++k) {
                int n = j;
                v[n] = v[n] + this.m_Par[k][j] * data[k];
            }
        }
        v[this.m_NumClasses - 1] = 0.0;
        for (int m = 0; m < this.m_NumClasses; ++m) {
            double sum = 0.0;
            for (int n = 0; n < this.m_NumClasses - 1; ++n) {
                sum += Math.exp(v[n] - v[m]);
            }
            prob[m] = 1.0 / (sum + Math.exp(-v[m]));
        }
        return prob;
    }

    public String toString() {
        int k;
        int j;
        String result = "Logistic Regression with ridge parameter of " + this.m_Ridge;
        if (this.m_Par == null) {
            return result + ": No model built yet.";
        }
        result = result + "\nCoefficients...\nVariable      Coeff.\n";
        for (j = 1; j <= this.m_NumPredictors; ++j) {
            result = result + Utils.doubleToString(j, 8, 0);
            for (k = 0; k < this.m_NumClasses - 1; ++k) {
                result = result + " " + Utils.doubleToString(this.m_Par[j][k], 12, 4);
            }
            result = result + "\n";
        }
        result = result + "Intercept ";
        for (int k2 = 0; k2 < this.m_NumClasses - 1; ++k2) {
            result = result + " " + Utils.doubleToString(this.m_Par[0][k2], 10, 4);
        }
        result = result + "\n";
        result = result + "\nOdds Ratios...\nVariable         O.R.\n";
        for (j = 1; j <= this.m_NumPredictors; ++j) {
            result = result + Utils.doubleToString(j, 8, 0);
            for (k = 0; k < this.m_NumClasses - 1; ++k) {
                double ORc = Math.exp(this.m_Par[j][k]);
                result = result + " " + (ORc > 1.0E10 ? "" + ORc : Utils.doubleToString(ORc, 12, 4));
            }
            result = result + "\n";
        }
        return result;
    }

    public void runModel() {
        int j;
        int claseObt;
        double[] dist;
        Instance inst;
        int i;
        String[] instanciasOUT;
        String[] instanciasIN;
        int tipo;
        Attribute a;
        InstanceSet IS = new InstanceSet();
        InstanceSet ISval = new InstanceSet();
        try {
            IS.readSet(this.input_train_name, true);
            this.buildClassifier(IS);
            ISval.readSet(this.input_validation_name, false);
            a = Attributes.getOutputAttribute(0);
            tipo = a.getType();
            instanciasIN = new String[ISval.getNumInstances()];
            instanciasOUT = new String[ISval.getNumInstances()];
            for (i = 0; i < ISval.getNumInstances(); ++i) {
                inst = ISval.getInstance(i);
                dist = this.distributionForInstance(inst);
                claseObt = 0;
                for (j = 1; j < this.m_NumClasses; ++j) {
                    if (!(dist[j] > dist[claseObt])) continue;
                    claseObt = j;
                }
                if (tipo != 0) {
                    instanciasIN[i] = new String(String.valueOf(inst.getOutputRealValues(0)));
                    instanciasOUT[i] = new String(String.valueOf(claseObt));
                    continue;
                }
                instanciasIN[i] = new String(inst.getOutputNominalValues(0));
                instanciasOUT[i] = new String(a.getNominalValue(claseObt));
            }
            Logistic.writeOutput(this.output_train_name, instanciasIN, instanciasOUT, Attributes.getInputAttributes(), Attributes.getOutputAttribute(0), Attributes.getInputNumAttributes(), "relation");
        }
        catch (Exception ex) {
            System.err.println("Fatal Error building the Logistic model!");
            ex.printStackTrace();
        }
        try {
            IS.readSet(this.input_test_name, false);
            a = Attributes.getOutputAttribute(0);
            tipo = a.getType();
            instanciasIN = new String[IS.getNumInstances()];
            instanciasOUT = new String[IS.getNumInstances()];
            for (i = 0; i < IS.getNumInstances(); ++i) {
                inst = IS.getInstance(i);
                dist = this.distributionForInstance(inst);
                claseObt = 0;
                for (j = 1; j < this.m_NumClasses; ++j) {
                    if (!(dist[j] > dist[claseObt])) continue;
                    claseObt = j;
                }
                if (tipo != 0) {
                    instanciasIN[i] = new String(String.valueOf(inst.getOutputRealValues(0)));
                    instanciasOUT[i] = new String(String.valueOf(claseObt));
                    continue;
                }
                instanciasIN[i] = new String(inst.getOutputNominalValues(0));
                instanciasOUT[i] = new String(a.getNominalValue(claseObt));
            }
            Logistic.writeOutput(this.output_test_name, instanciasIN, instanciasOUT, Attributes.getInputAttributes(), Attributes.getOutputAttribute(0), Attributes.getInputNumAttributes(), "relation");
        }
        catch (Exception ex) {
            System.err.println("Fatal Error performing test by the Logistic model!");
            ex.printStackTrace();
        }
    }

    private void config_read(String fileParam) {
        File inputFile = new File(fileParam);
        if (inputFile == null || !inputFile.exists()) {
            System.out.println("parameter " + fileParam + " file doesn't exists!");
            System.exit(-1);
        }
        try {
            String line;
            FileReader file_reader = new FileReader(inputFile);
            BufferedReader buf_reader = new BufferedReader(file_reader);
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            String[] out = line.split("algorithm = ");
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("inputData = ");
            out = out[1].split("\\s\"");
            this.input_train_name = new String(out[0].substring(1, out[0].length() - 1));
            this.input_validation_name = new String(out[1].substring(0, out[1].length() - 1));
            this.input_test_name = new String(out[2].substring(0, out[2].length() - 1));
            if (this.input_validation_name.charAt(this.input_validation_name.length() - 1) == '\"') {
                this.input_validation_name = this.input_validation_name.substring(0, this.input_validation_name.length() - 1);
            }
            if (this.input_test_name.charAt(this.input_test_name.length() - 1) == '\"') {
                this.input_test_name = this.input_test_name.substring(0, this.input_test_name.length() - 1);
            }
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("outputData = ");
            out = out[1].split("\\s\"");
            this.output_train_name = new String(out[0].substring(1, out[0].length() - 1));
            this.output_test_name = new String(out[1].substring(0, out[1].length() - 1));
            if (this.output_test_name.charAt(this.output_test_name.length() - 1) == '\"') {
                this.output_test_name = this.output_test_name.substring(0, this.output_test_name.length() - 1);
            }
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("Ridge = ");
            this.m_Ridge = new Double(out[1]);
            while ((line = buf_reader.readLine()).length() == 0) {
            }
            out = line.split("MaxIter = ");
            this.m_MaxIts = new Integer(out[1]);
        }
        catch (IOException e) {
            System.out.println("IO exception = " + e);
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static void writeOutput(String fileName, String[] instancesIN, String[] instancesOUT, Attribute[] inputs, Attribute output, int nInputs, String relation) {
        int j;
        int i;
        String cadena = "";
        cadena = cadena + "@relation " + relation + "\n";
        for (i = 0; i < nInputs; ++i) {
            cadena = cadena + "@attribute " + inputs[i].getName() + " ";
            if (inputs[i].getType() == 0) {
                cadena = cadena + "{";
                for (j = 0; j < inputs[i].getNominalValuesList().size(); ++j) {
                    cadena = cadena + (String)inputs[i].getNominalValuesList().elementAt(j);
                    if (j >= inputs[i].getNominalValuesList().size() - 1) continue;
                    cadena = cadena + ", ";
                }
                cadena = cadena + "}\n";
                continue;
            }
            if (inputs[i].getType() == 1) {
                cadena = cadena + "integer";
                cadena = cadena + " [" + String.valueOf((int)inputs[i].getMinAttribute()) + ", " + String.valueOf((int)inputs[i].getMaxAttribute()) + "]\n";
                continue;
            }
            cadena = cadena + "real";
            cadena = cadena + " [" + String.valueOf(inputs[i].getMinAttribute()) + ", " + String.valueOf(inputs[i].getMaxAttribute()) + "]\n";
        }
        cadena = cadena + "@attribute " + output.getName() + " ";
        if (output.getType() == 0) {
            cadena = cadena + "{";
            for (j = 0; j < output.getNominalValuesList().size(); ++j) {
                cadena = cadena + (String)output.getNominalValuesList().elementAt(j);
                if (j >= output.getNominalValuesList().size() - 1) continue;
                cadena = cadena + ", ";
            }
            cadena = cadena + "}\n";
        } else {
            cadena = cadena + "integer [" + String.valueOf((int)output.getMinAttribute()) + ", " + String.valueOf((int)output.getMaxAttribute()) + "]\n";
        }
        cadena = cadena + "@data\n";
        Fichero.escribeFichero(fileName, cadena);
        cadena = "";
        for (i = 0; i < instancesIN.length; ++i) {
            cadena = cadena + instancesIN[i] + " " + instancesOUT[i];
            cadena = cadena + "\n";
        }
        Fichero.AnadirtoFichero(fileName, cadena);
    }

    private class OptEng
    extends Optimization {
        private double[] weights;
        private int[] cls;

        private OptEng() {
        }

        public void setWeights(double[] w) {
            this.weights = w;
        }

        public void setClassLabels(int[] c) {
            this.cls = c;
        }

        @Override
        protected double objectiveFunction(double[] x) {
            double nll = 0.0;
            int dim = Logistic.this.m_NumPredictors + 1;
            for (int i = 0; i < this.cls.length; ++i) {
                double[] exp = new double[Logistic.this.m_NumClasses - 1];
                for (int offset = 0; offset < Logistic.this.m_NumClasses - 1; ++offset) {
                    int index = offset * dim;
                    for (int j = 0; j < dim; ++j) {
                        int n = offset;
                        exp[n] = exp[n] + Logistic.this.m_Data[i][j] * x[index + j];
                    }
                }
                double max = exp[Utils.maxIndex(exp)];
                double denom = Math.exp(-max);
                double num = this.cls[i] == Logistic.this.m_NumClasses - 1 ? -max : exp[this.cls[i]] - max;
                for (int offset = 0; offset < Logistic.this.m_NumClasses - 1; ++offset) {
                    denom += Math.exp(exp[offset] - max);
                }
                nll -= this.weights[i] * (num - Math.log(denom));
            }
            for (int offset = 0; offset < Logistic.this.m_NumClasses - 1; ++offset) {
                for (int r = 1; r < dim; ++r) {
                    nll += Logistic.this.m_Ridge * x[offset * dim + r] * x[offset * dim + r];
                }
            }
            return nll;
        }

        @Override
        protected double[] evaluateGradient(double[] x) {
            double[] grad = new double[x.length];
            int dim = Logistic.this.m_NumPredictors + 1;
            for (int i = 0; i < this.cls.length; ++i) {
                int index;
                double[] num = new double[Logistic.this.m_NumClasses - 1];
                for (int offset = 0; offset < Logistic.this.m_NumClasses - 1; ++offset) {
                    double exp = 0.0;
                    index = offset * dim;
                    for (int j = 0; j < dim; ++j) {
                        exp += Logistic.this.m_Data[i][j] * x[index + j];
                    }
                    num[offset] = exp;
                }
                double max = num[Utils.maxIndex(num)];
                double denom = Math.exp(-max);
                for (int offset = 0; offset < Logistic.this.m_NumClasses - 1; ++offset) {
                    num[offset] = Math.exp(num[offset] - max);
                    denom += num[offset];
                }
                Utils.normalize(num, denom);
                for (int offset = 0; offset < Logistic.this.m_NumClasses - 1; ++offset) {
                    index = offset * dim;
                    double firstTerm = this.weights[i] * num[offset];
                    for (int q = 0; q < dim; ++q) {
                        int n = index + q;
                        grad[n] = grad[n] + firstTerm * Logistic.this.m_Data[i][q];
                    }
                }
                if (this.cls[i] == Logistic.this.m_NumClasses - 1) continue;
                for (int p = 0; p < dim; ++p) {
                    int n = this.cls[i] * dim + p;
                    grad[n] = grad[n] - this.weights[i] * Logistic.this.m_Data[i][p];
                }
            }
            for (int offset = 0; offset < Logistic.this.m_NumClasses - 1; ++offset) {
                for (int r = 1; r < dim; ++r) {
                    int n = offset * dim + r;
                    grad[n] = grad[n] + 2.0 * Logistic.this.m_Ridge * x[offset * dim + r];
                }
            }
            return grad;
        }
    }
}

