/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Decision_Trees.M5;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.util.Enumeration;
import java.util.Vector;
import keel.Algorithms.Decision_Trees.M5.Association;
import keel.Algorithms.Decision_Trees.M5.EvaluateModel;
import keel.Algorithms.Decision_Trees.M5.Information;
import keel.Algorithms.Decision_Trees.M5.InformationHandler;
import keel.Algorithms.Decision_Trees.M5.M5Instance;
import keel.Algorithms.Decision_Trees.M5.M5Instances;
import keel.Algorithms.Decision_Trees.M5.M5StaticUtils;
import keel.Algorithms.Decision_Trees.M5.M5TreeNode;
import keel.Algorithms.Decision_Trees.M5.NominalToBinaryFilter;
import keel.Algorithms.Decision_Trees.M5.ReplaceMissingValuesFilter;
import keel.Algorithms.Decision_Trees.M5.SelectedAssociation;

public final class M5 {
    private M5TreeNode[] m_root;
    private InformationHandler options;
    private boolean m_UseUnsmoothed = false;
    private double m_PruningFactor = 2.0;
    private int m_Model = 3;
    private int m_Verbosity = 0;
    private ReplaceMissingValuesFilter m_ReplaceMissingValuesFilter;
    private NominalToBinaryFilter m_NominalToBinaryFilter;
    public static final int MODEL_LINEAR_REGRESSION = 1;
    public static final int MODEL_REGRESSION_TREE = 2;
    public static final int MODEL_MODEL_TREE = 3;
    public static final Association[] TAGS_MODEL_TYPES = new Association[]{new Association(1, "Simple linear regression"), new Association(2, "Regression tree"), new Association(3, "Model tree")};
    static String trainFileName;
    static String testFileName;
    static String testOutFileName;
    static String trainOutFileName;
    static String outputFileName;
    static String type;
    static String unsmoothed;
    static String pruningFactor;
    static String verbosity;
    static StringBuffer lista;

    private static void initTokenizer(StreamTokenizer tokenizer) {
        tokenizer.resetSyntax();
        tokenizer.whitespaceChars(0, 32);
        tokenizer.wordChars(33, 255);
        tokenizer.whitespaceChars(44, 44);
        tokenizer.quoteChar(34);
        tokenizer.quoteChar(39);
        tokenizer.ordinaryChar(61);
        tokenizer.ordinaryChar(123);
        tokenizer.ordinaryChar(125);
        tokenizer.ordinaryChar(91);
        tokenizer.ordinaryChar(93);
        tokenizer.eolIsSignificant(true);
    }

    private static boolean getNextToken(StreamTokenizer tokenizer) {
        try {
            if (tokenizer.nextToken() == -1) {
                return false;
            }
            tokenizer.pushBack();
            while (tokenizer.nextToken() != 10) {
            }
            while (tokenizer.nextToken() == 10) {
            }
            return tokenizer.sval != null;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return false;
        }
    }

    protected static void setOptions(StreamTokenizer options) throws Exception {
        options.nextToken();
        if (options.sval.equalsIgnoreCase("algorithm")) {
            options.nextToken();
            options.nextToken();
            if (!options.sval.equalsIgnoreCase("M5")) {
                throw new Exception("The name of the algorithm is not correct.");
            }
            options.nextToken();
            options.nextToken();
            if (!options.sval.equalsIgnoreCase("inputData")) {
                throw new Exception("The file must start with the word inputData.");
            }
            options.nextToken();
            options.nextToken();
            trainFileName = options.sval;
            options.nextToken();
            options.nextToken();
            testFileName = options.sval;
            M5.getNextToken(options);
            if (!options.sval.equalsIgnoreCase("outputData")) {
                throw new Exception("The file must start with the word outputData.");
            }
            options.nextToken();
            options.nextToken();
            trainOutFileName = options.sval;
            options.nextToken();
            testOutFileName = options.sval;
            options.nextToken();
            outputFileName = options.sval;
            M5.getNextToken(options);
            if (options.ttype == -1) {
                return;
            }
            for (int k = 0; k < 4; ++k) {
                if (options.sval.equalsIgnoreCase("type")) {
                    options.nextToken();
                    options.nextToken();
                    type = options.sval;
                    if (M5.getNextToken(options)) continue;
                    return;
                }
                if (options.sval.equalsIgnoreCase("pruningFactor")) {
                    options.nextToken();
                    options.nextToken();
                    pruningFactor = options.sval;
                    if (M5.getNextToken(options)) continue;
                    return;
                }
                if (options.sval.equalsIgnoreCase("unsmoothed")) {
                    options.nextToken();
                    options.nextToken();
                    unsmoothed = options.sval;
                    if (M5.getNextToken(options)) continue;
                    return;
                }
                if (!options.sval.equalsIgnoreCase("verbosity")) continue;
                options.nextToken();
                options.nextToken();
                verbosity = options.sval;
                if (M5.getNextToken(options)) continue;
                return;
            }
        } else {
            throw new Exception("The file must start with the word \"algorithm=\" followed by the name of the algorithm.");
        }
    }

    public static String getHeader(String fileName) {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(fileName)));
            StringBuffer sb = new StringBuffer();
            String line = "";
            String aux = "";
            line = br.readLine();
            if (line.length() >= 5) {
                aux = line.substring(0, 5);
            }
            while (!aux.equalsIgnoreCase("@data")) {
                if (!line.startsWith("%") && line.length() > 1) {
                    sb.append(line + "\n");
                }
                if ((line = br.readLine()).length() < 5) continue;
                aux = line.substring(0, 5);
            }
            sb.append("@data\n");
            br.close();
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getHeaderNoData(String fileName) {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(fileName)));
            StringBuffer sb = new StringBuffer();
            String line = "";
            String aux = "";
            line = br.readLine();
            if (line.length() >= 5) {
                aux = line.substring(0, 5);
            }
            while (!aux.equalsIgnoreCase("@data")) {
                sb.append(line + "\n");
                line = br.readLine();
                if (line.length() < 5) continue;
                aux = line.substring(0, 5);
            }
            br.close();
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public final void buildClassifier(M5Instances inst) throws Exception {
        if (inst.checkForStringAttributes()) {
            throw new Exception("Can't handle string attributes!");
        }
        this.options = new InformationHandler(inst);
        this.options.model = this.m_Model;
        this.options.smooth = !this.m_UseUnsmoothed;
        this.options.pruningFactor = this.m_PruningFactor;
        this.options.verbosity = this.m_Verbosity;
        if (!inst.classAttribute().isNumeric()) {
            throw new Exception("Class has to be numeric.");
        }
        inst = new M5Instances(inst);
        inst.deleteWithMissingClass();
        this.m_ReplaceMissingValuesFilter = new ReplaceMissingValuesFilter();
        this.m_ReplaceMissingValuesFilter.setInputFormat(inst);
        inst = ReplaceMissingValuesFilter.useFilter(inst, this.m_ReplaceMissingValuesFilter);
        this.m_NominalToBinaryFilter = new NominalToBinaryFilter();
        this.m_NominalToBinaryFilter.setInputFormat(inst);
        inst = NominalToBinaryFilter.useFilter(inst, this.m_NominalToBinaryFilter);
        this.m_root = new M5TreeNode[2];
        this.options.deviation = M5.stdDev(inst.classIndex(), inst);
        this.m_root[0] = new M5TreeNode(inst, null, this.options);
        this.m_root[0].split(inst);
        this.m_root[0].numLeaves(0);
        this.m_root[1] = this.m_root[0].copy(null);
        this.m_root[1].prune();
        if (this.options.model != 1) {
            this.m_root[1].smoothen();
            this.m_root[1].numLeaves(0);
        }
    }

    public double classifyInstance(M5Instance ins) throws Exception {
        this.m_ReplaceMissingValuesFilter.input(ins);
        this.m_ReplaceMissingValuesFilter.batchFinished();
        ins = this.m_ReplaceMissingValuesFilter.output();
        this.m_NominalToBinaryFilter.input(ins);
        this.m_NominalToBinaryFilter.batchFinished();
        ins = this.m_NominalToBinaryFilter.output();
        double prueba = this.m_root[1].predict(ins, !this.m_UseUnsmoothed);
        return prueba;
    }

    public Enumeration listOptions() {
        Vector<Information> newVector = new Vector<Information>(4);
        newVector.addElement(new Information("\tType of model to be used.\n\tl: linear regression\n\tr: regression tree\n\tm: model tree\n\t(default: m)", "-O", 1, "-O <l|r|m>"));
        newVector.addElement(new Information("\tUse unsmoothed tree.", "C", 0, "-U"));
        newVector.addElement(new Information("\tPruning factor (default: 2).", "-F", 1, "-F <double>"));
        newVector.addElement(new Information("\tVerbosity (default: 0).", "-V", 1, "-V <0|1|2>"));
        return newVector.elements();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setOptions(String[] options) throws Exception {
        String pruningString;
        String modelString = M5StaticUtils.getOption('O', options);
        if (modelString.length() != 0) {
            if (modelString.equals("l")) {
                this.setModelType(new SelectedAssociation(1, TAGS_MODEL_TYPES));
            } else if (modelString.equals("r")) {
                this.setModelType(new SelectedAssociation(2, TAGS_MODEL_TYPES));
            } else {
                if (!modelString.equals("m")) throw new Exception("Don't know model type " + modelString);
                this.setModelType(new SelectedAssociation(3, TAGS_MODEL_TYPES));
            }
        } else {
            this.setModelType(new SelectedAssociation(3, TAGS_MODEL_TYPES));
        }
        this.setUseUnsmoothed(M5StaticUtils.getFlag('U', options));
        if (this.m_Model != 3) {
            this.setUseUnsmoothed(true);
        }
        if ((pruningString = M5StaticUtils.getOption('F', options)).length() != 0) {
            this.setPruningFactor(new Double(pruningString));
        } else {
            this.setPruningFactor(2.0);
        }
        String verbosityString = M5StaticUtils.getOption('V', options);
        if (verbosityString.length() != 0) {
            this.setVerbosity(Integer.parseInt(verbosityString));
            return;
        } else {
            this.setVerbosity(0);
        }
    }

    public String[] getOptions() {
        String[] options = new String[7];
        int current = 0;
        switch (this.m_Model) {
            case 3: {
                options[current++] = "-O";
                options[current++] = "m";
                if (!this.m_UseUnsmoothed) break;
                options[current++] = "-U";
                break;
            }
            case 2: {
                options[current++] = "-O";
                options[current++] = "r";
                break;
            }
            case 1: {
                options[current++] = "-O";
                options[current++] = "l";
            }
        }
        options[current++] = "-F";
        options[current++] = "" + this.m_PruningFactor;
        options[current++] = "-V";
        options[current++] = "" + this.m_Verbosity;
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public final String toString() {
        try {
            StringBuffer text = new StringBuffer();
            double absDev = M5.absDev(this.m_root[0].instances.classIndex(), this.m_root[0].instances);
            if (this.options.verbosity >= 1 && this.options.model != 1) {
                switch (this.m_root[0].model) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        text.append("@Unpruned training regression tree:\n");
                        break;
                    }
                    case 3: {
                        text.append("@Unpruned training model tree:\n");
                    }
                }
                if (!this.m_root[0].type) {
                    text.append("\n");
                }
                text.append(this.m_root[0].treeToString(0, absDev) + "\n");
                text.append("@Models at the leaves:\n\n");
                text.append(this.m_root[0].formulaeToString(false) + "\n");
            }
            if (this.m_root[0].model != 1) {
                switch (this.m_root[0].model) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        text.append("@Pruned training regression tree:\n");
                        break;
                    }
                    case 3: {
                        text.append("@Pruned training model tree:\n");
                    }
                }
                if (!this.m_root[1].type) {
                    text.append("\n");
                }
                text.append(this.m_root[1].treeToString(0, absDev) + "\n");
                text.append("@Models at the leaves:\n");
                if (this.m_root[0].model != 1 && this.m_UseUnsmoothed) {
                    text.append("@Unsmoothed linear models at the leaves of the pruned tree (simple):\n");
                    text.append(this.m_root[1].formulaeToString(false) + "\n");
                }
                if (this.m_root[0].model == 3 && !this.m_UseUnsmoothed) {
                    text.append("@Smoothed linear models at the leaves of the pruned tree (complex):\n");
                    text.append(this.m_root[1].formulaeToString(true) + "\n");
                }
            } else {
                text.append("@Training linear regression model:\n");
                text.append(this.m_root[1].unsmoothed.toString(this.m_root[1].instances, 0) + "\n\n");
            }
            text.append("@Number of Rules: " + this.m_root[1].numberOfLinearModels());
            return text.toString();
        }
        catch (Exception e) {
            return "can't print m5' tree";
        }
    }

    public double measureNumLinearModels() {
        return this.m_root[1].numberOfLinearModels();
    }

    public double measureNumLeaves() {
        return this.measureNumLinearModels();
    }

    public double measureNumRules() {
        return this.measureNumLinearModels();
    }

    public Enumeration enumerateMeasures() {
        Vector<String> newVector = new Vector<String>(3);
        newVector.addElement("measureNumLinearModels");
        newVector.addElement("measureNumLeaves");
        newVector.addElement("measureNumRules");
        return newVector.elements();
    }

    public double getMeasure(String additionalMeasureName) {
        if (additionalMeasureName.compareTo("measureNumRules") == 0) {
            return this.measureNumRules();
        }
        if (additionalMeasureName.compareTo("measureNumLinearModels") == 0) {
            return this.measureNumLinearModels();
        }
        if (additionalMeasureName.compareTo("measureNumLeaves") == 0) {
            return this.measureNumLeaves();
        }
        throw new IllegalArgumentException(additionalMeasureName + " not supported (M5)");
    }

    public boolean getUseUnsmoothed() {
        return this.m_UseUnsmoothed;
    }

    public void setUseUnsmoothed(boolean v) {
        this.m_UseUnsmoothed = v;
    }

    public double getPruningFactor() {
        return this.m_PruningFactor;
    }

    public void setPruningFactor(double v) {
        this.m_PruningFactor = v;
    }

    public SelectedAssociation getModelType() {
        return new SelectedAssociation(this.m_Model, TAGS_MODEL_TYPES);
    }

    public void setModelType(SelectedAssociation newMethod) {
        if (newMethod.getTags() == TAGS_MODEL_TYPES) {
            this.m_Model = newMethod.getSelectedTag().getID();
        }
    }

    public int getVerbosity() {
        return this.m_Verbosity;
    }

    public void setVerbosity(int v) {
        this.m_Verbosity = v;
    }

    public static M5 forName(String classifierName, String[] options) throws Exception {
        return (M5)M5StaticUtils.forName(M5.class, classifierName, options);
    }

    public static final boolean hasEnumAttr(M5Instances inst) {
        boolean b = false;
        for (int j = 0; j < inst.numAttributes(); ++j) {
            if (!inst.attribute(j).isNominal()) continue;
            b = true;
        }
        return b;
    }

    public static final boolean hasMissing(M5Instances inst) {
        boolean b = false;
        for (int i = 0; i < inst.numInstances(); ++i) {
            for (int j = 0; j < inst.numAttributes(); ++j) {
                if (!inst.instance(i).isMissing(j)) continue;
                b = true;
            }
        }
        return b;
    }

    public static final double sum(int attr, M5Instances inst) {
        double sum = 0.0;
        for (int i = 0; i <= inst.numInstances() - 1; ++i) {
            sum += inst.instance(i).value(attr);
        }
        return sum;
    }

    public static final double sqrSum(int attr, M5Instances inst) {
        double sqrSum = 0.0;
        for (int i = 0; i <= inst.numInstances() - 1; ++i) {
            double value = inst.instance(i).value(attr);
            sqrSum += value * value;
        }
        return sqrSum;
    }

    public static final double stdDev(int attr, M5Instances inst) {
        double sd;
        int count = 0;
        double sum = 0.0;
        double sqrSum = 0.0;
        for (int i = 0; i <= inst.numInstances() - 1; ++i) {
            ++count;
            double value = inst.instance(i).value(attr);
            sum += value;
            sqrSum += value * value;
        }
        if (count > 1) {
            double va = (sqrSum - sum * sum / (double)count) / (double)count;
            va = Math.abs(va);
            sd = Math.sqrt(va);
        } else {
            sd = 0.0;
        }
        return sd;
    }

    public static final double absDev(int attr, M5Instances inst) {
        double absDev;
        int i;
        double average = 0.0;
        double absdiff = 0.0;
        for (i = 0; i <= inst.numInstances() - 1; ++i) {
            average += inst.instance(i).value(attr);
        }
        if (inst.numInstances() > 1) {
            average /= (double)inst.numInstances();
            for (i = 0; i <= inst.numInstances() - 1; ++i) {
                absdiff += Math.abs(inst.instance(i).value(attr) - average);
            }
            absDev = absdiff / (double)inst.numInstances();
        } else {
            absDev = 0.0;
        }
        return absDev;
    }

    public static final double variance(int attr, M5Instances inst) {
        int count = 0;
        double sum = 0.0;
        double sqrSum = 0.0;
        for (int i = 0; i <= inst.numInstances() - 1; ++i) {
            double value = inst.instance(i).value(attr);
            sum += value;
            sqrSum += value * value;
            ++count;
        }
        double va = count > 0 ? (sqrSum - sum * sum / (double)count) / (double)count : 0.0;
        return va;
    }

    public static final long roundDouble(double value) {
        long roundedValue = value > 0.0 ? (long)(value + 0.5) : -((long)(Math.abs(value) + 0.5));
        return roundedValue;
    }

    public static final long floorDouble(double value) {
        long floorValue = value > 0.0 ? (long)value : -((long)(Math.abs(value) + 1.0));
        return floorValue;
    }

    public static final String doubleToStringF(double value, int width, int afterDecimalPoint) {
        int i;
        StringBuffer stringBuffer;
        String resultString;
        if (afterDecimalPoint < 0) {
            afterDecimalPoint = 0;
        }
        long precisionValue = 0L;
        double temp = value * Math.pow(10.0, afterDecimalPoint);
        if (Math.abs(temp) < 9.223372036854776E18) {
            precisionValue = M5.roundDouble(temp);
            if (precisionValue == 0L) {
                resultString = String.valueOf(0);
                stringBuffer = new StringBuffer(resultString);
                stringBuffer.append(".");
                for (i = 1; i <= afterDecimalPoint; ++i) {
                    stringBuffer.append("0");
                }
                resultString = stringBuffer.toString();
            } else {
                int dotPosition;
                resultString = String.valueOf(precisionValue);
                stringBuffer = new StringBuffer(resultString);
                for (dotPosition = stringBuffer.length() - afterDecimalPoint; dotPosition < 0; ++dotPosition) {
                    stringBuffer.insert(0, 0);
                }
                stringBuffer.insert(dotPosition, ".");
                if (stringBuffer.charAt(0) == '.') {
                    stringBuffer.insert(0, 0);
                }
                resultString = stringBuffer.toString();
            }
        } else {
            resultString = new String("NaN");
        }
        stringBuffer = new StringBuffer(Math.max(width, resultString.length()));
        for (i = 0; i < stringBuffer.capacity() - resultString.length(); ++i) {
            stringBuffer.append(' ');
        }
        stringBuffer.append(resultString);
        return stringBuffer.toString();
    }

    public static final String doubleToStringG(double value, int width, int precision) {
        int i;
        StringBuffer stringBuffer;
        String resultString;
        double temp;
        int exponent = 0;
        if (precision <= 0) {
            precision = 1;
        }
        long precisionValue = 0L;
        exponent = 0;
        if (value != 0.0 && precision - 1 != (int)(Math.log((double)Math.abs(precisionValue = M5.roundDouble(temp = value * Math.pow(10.0, precision - (exponent = (int)M5.floorDouble(Math.log(Math.abs(value)) / Math.log(10.0))) - 1))) + 0.5) / Math.log(10.0))) {
            ++exponent;
            precisionValue = M5.roundDouble((double)precisionValue / 10.0);
        }
        if (precisionValue == 0L) {
            resultString = String.valueOf("0");
        } else {
            int dotPosition = precisionValue >= 0L ? 1 : 2;
            if (exponent < -3 || precision - 1 + exponent > 7) {
                resultString = String.valueOf(precisionValue);
                stringBuffer = new StringBuffer(resultString);
                stringBuffer.insert(dotPosition, ".");
                stringBuffer = M5.deleteTrailingZerosAndDot(stringBuffer);
                stringBuffer.append("e").append(String.valueOf(exponent));
                resultString = stringBuffer.toString();
            } else {
                resultString = String.valueOf(precisionValue);
                stringBuffer = new StringBuffer(resultString);
                for (i = 1; i <= -exponent; ++i) {
                    stringBuffer.insert(dotPosition - 1, "0");
                }
                if (exponent <= -1) {
                    stringBuffer.insert(dotPosition, ".");
                } else if (exponent <= precision - 1) {
                    stringBuffer.insert(dotPosition + exponent, ".");
                } else {
                    for (i = 1; i <= exponent - (precision - 1); ++i) {
                        stringBuffer.append("0");
                    }
                    stringBuffer.append(".");
                }
                stringBuffer = M5.deleteTrailingZerosAndDot(stringBuffer);
                resultString = stringBuffer.toString();
            }
        }
        stringBuffer = new StringBuffer(Math.max(width, resultString.length()));
        for (i = 0; i < stringBuffer.capacity() - resultString.length(); ++i) {
            stringBuffer.append(' ');
        }
        stringBuffer.append(resultString);
        return stringBuffer.toString();
    }

    public static final StringBuffer deleteTrailingZerosAndDot(StringBuffer stringBuffer) {
        while (stringBuffer.charAt(stringBuffer.length() - 1) == '0' || stringBuffer.charAt(stringBuffer.length() - 1) == '.') {
            if (stringBuffer.charAt(stringBuffer.length() - 1) == '0') {
                stringBuffer.setLength(stringBuffer.length() - 1);
                continue;
            }
            stringBuffer.setLength(stringBuffer.length() - 1);
            break;
        }
        return stringBuffer;
    }

    public static final double smoothenValue(double p, double q, int n, int k) {
        return ((double)n * p + (double)k * q) / (double)(n + k);
    }

    public static final double correlation(double[] y1, double[] y2, int n) {
        int i;
        double av1 = 0.0;
        double av2 = 0.0;
        double y11 = 0.0;
        double y22 = 0.0;
        double y12 = 0.0;
        if (n <= 1) {
            return 1.0;
        }
        for (i = 0; i < n; ++i) {
            av1 += y1[i];
            av2 += y2[i];
        }
        av1 /= (double)n;
        av2 /= (double)n;
        for (i = 0; i < n; ++i) {
            y11 += (y1[i] - av1) * (y1[i] - av1);
            y22 += (y2[i] - av2) * (y2[i] - av2);
            y12 += (y1[i] - av1) * (y2[i] - av2);
        }
        double c = y11 * y22 == 0.0 ? 1.0 : y12 / Math.sqrt(Math.abs(y11 * y22));
        return c;
    }

    public static final boolean eqDouble(double a, double b) {
        if (Math.abs(a) < 1.0E-10 && Math.abs(b) < 1.0E-10) {
            return true;
        }
        double c = Math.abs(a) + Math.abs(b);
        return Math.abs(a - b) < c * 1.0E-10;
    }

    public static final void errorMsg(String err) {
        System.out.print("Error: ");
        System.out.println(err);
        System.exit(1);
    }

    public static final String separatorToString() {
        return "--------------------------------------------------------------------------------\n";
    }

    public static final String headToString() {
        StringBuffer text = new StringBuffer();
        text.append("M5Java version v1.1\n");
        return text.toString();
    }

    public static void main(String[] argv) {
        try {
            StreamTokenizer tokenizer = new StreamTokenizer(new BufferedReader(new FileReader(argv[0])));
            M5.initTokenizer(tokenizer);
            M5.setOptions(tokenizer);
            String strOpt = "-t " + trainFileName + " -T " + testFileName + " -O " + type + " -F " + pruningFactor + " -V " + verbosity;
            if (unsmoothed.equalsIgnoreCase("true")) {
                strOpt = strOpt + " -U";
            }
            String[] opt = strOpt.split(" ");
            String strOut = EvaluateModel.evaluateModel(new M5(), opt);
            PrintWriter pw = new PrintWriter(new FileOutputStream(outputFileName));
            pw.print(strOut);
            pw.flush();
            pw.close();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    static {
        lista = new StringBuffer();
    }
}

