/*
 * Decompiled with CFR 0.152.
 */
package keel.Dataset;

import keel.Dataset.Attributes;
import keel.Dataset.DatasetException;
import keel.Dataset.HeaderFormatException;
import keel.Dataset.Instance;
import keel.Dataset.InstanceSet;

public class Main {
    InstanceSet iSet = null;
    InstanceSet tSet = null;

    public Main(String trainName, String testName) {
        try {
            System.out.println("\n-------------------------------------------");
            System.out.println("Parsing the file: " + trainName + ".");
            System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            this.iSet = new InstanceSet();
            this.iSet.readSet(trainName, true);
            System.out.println("<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
            System.out.println("\n\nPrinting the train Data: ");
            this.iSet.print();
        }
        catch (DatasetException e) {
            System.out.println("\n\n>>>TRAIN Errors");
            e.printAllErrors();
        }
        catch (HeaderFormatException e2) {
            System.err.println("Exception in header format: " + e2.getMessage());
        }
    }

    void loadOtherDset(String trainName, String testName) {
        Attributes.clearAll();
        this.iSet = null;
        this.tSet = null;
        try {
            System.out.println("\n-------------------------------------------");
            System.out.println("Parsing the file: " + trainName + ".");
            System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            this.iSet = new InstanceSet();
            this.iSet.readSet(trainName, true);
            System.out.println("<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
            System.out.println("\n\nPrinting the train Data: ");
            this.iSet.print();
        }
        catch (DatasetException e) {
            System.out.println("\n\n>>>TRAIN Errors");
            e.printAllErrors();
        }
        catch (HeaderFormatException e2) {
            System.err.println("Exception in header format: " + e2.getMessage());
        }
        System.out.println();
        try {
            System.out.println("\n-------------------------------------------");
            System.out.println("Parsing the file: " + testName + ".");
            System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            this.tSet = new InstanceSet();
            this.tSet.readSet(testName, false);
            System.out.println("<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
            System.out.println("\n\n-------------------------------------------");
            System.out.println("Printing the test data:");
            this.tSet.print();
            System.out.println("\n-------------------------------------------");
        }
        catch (DatasetException e) {
            System.out.println("\n\n>>>TEST Errors.");
            e.printAllErrors();
            this.tSet.print();
        }
        catch (HeaderFormatException e2) {
            System.err.println("Exception in header format." + e2.getMessage());
        }
        System.out.println();
    }

    public void run() {
        System.out.println("------------------------------------");
        System.out.println("  Printing normalized test values   ");
        System.out.println("------------------------------------");
        this.printNormalized(this.tSet);
        System.out.println("\n\n------------------------------------");
        System.out.println("  Printing headers   ");
        System.out.println("------------------------------------");
        System.out.println(">>>> Input Attributes header: ");
        System.out.println(Attributes.getInputAttributesHeader());
        System.out.println(">>>> Output Attributes header: ");
        System.out.println(Attributes.getOutputAttributesHeader());
        System.out.println(">>>> Input header:  " + Attributes.getInputHeader());
        System.out.println(">>>> Output header: " + Attributes.getOutputHeader());
        System.out.println(">>>> Printing test attributes:");
        for (int i = 0; i < this.tSet.getNumInstances(); ++i) {
            System.out.println("Instance " + i + ": " + this.tSet.getInstance(i).toString());
        }
        this.iSet.removeAttribute(this.tSet, true, 1);
        System.out.println(">>>Printing iSet!!!");
        this.iSet.print();
        System.out.println("\nIset has nominal values: " + Attributes.hasNominalAttributes());
        System.out.println("Iset has integer values: " + Attributes.hasIntegerAttributes());
        System.out.println("Iset has real    values: " + Attributes.hasRealAttributes());
        System.out.println(">>>Printing tSet");
        this.tSet.print();
        System.out.println();
        try {
            System.out.println("\nGetting the value of the input attr 1: " + this.tSet.getInputNumericValue(1, 0));
            System.out.println("\nGetting the value of the output attr 1: " + this.tSet.getOutputNominalValue(1, 0));
            Instance ins = this.tSet.getInstance(2);
            System.out.println("\nThe instance 1 have any missing value: " + ins.existsAnyMissingValue());
            if (ins.existsAnyMissingValue()) {
                if (!ins.setInputNumericValue(0, 100.0)) {
                    System.out.println("Out of bounds.");
                }
                ins.setInputNumericValue(0, 5.0);
                System.out.println("\nThe instance 1 have any missing value: " + ins.existsAnyMissingValue());
            }
            Instance ins2 = this.tSet.getInstance(2);
            System.out.println("\nThe instance 1 have any missing value: " + ins2.existsAnyMissingValue());
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void run2() {
    }

    private void printNormalized(InstanceSet set) {
        System.out.println("Number of instances: " + set.getNumInstances());
        for (int i = 0; i < set.getNumInstances(); ++i) {
            int k;
            Instance inst = set.getInstance(i);
            double[] inValues = inst.getNormalizedInputValues();
            if (inst.existsInputMissingValues()) {
                boolean[] missing = inst.getInputMissingValues();
                for (int j = 0; j < missing.length; ++j) {
                    if (!missing[j]) continue;
                    inValues[j] = -1.0;
                }
            }
            double[] outValues = inst.getNormalizedOutputValues();
            System.out.println(">>Instance " + i + ": ");
            System.out.print("   >Inputs:");
            for (k = 0; k < inValues.length; ++k) {
                String out = new Double(inValues[k]).toString();
                while (out.length() < 5) {
                    out = out + " ";
                }
                out = out.substring(0, 5);
                System.out.print(out + "  ");
            }
            System.out.print("   >Outputs:");
            for (k = 0; k < outValues.length; ++k) {
                System.out.print(new Double(outValues[k]).toString().substring(0, 5) + "  ");
            }
        }
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("The BD file name for train and test files has to be passed");
            return;
        }
        Main obj = new Main(args[0], args[1]);
        obj.loadOtherDset(args[2], args[3]);
    }
}

