/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Genetic_Rule_Learning.M5Rules;

import keel.Algorithms.Genetic_Rule_Learning.M5Rules.M5;

public final class Measures {
    int type = 0;
    double correlation = 0.0;
    double meanAbsErr = 0.0;
    double meanSqrErr = 0.0;

    public final String toString(double absDev, double sd, String set, String smooth) {
        StringBuffer text = new StringBuffer();
        switch (this.type) {
            case 0: {
                text.append("    Correlation coefficient:\t\t" + M5.doubleToStringF(this.correlation, 9, 3) + "\t\t\t      " + set + smooth);
                text.append("    Mean absolute error:\t\t" + M5.doubleToStringG(this.meanAbsErr, 9, 4) + "\t\t\t      " + set + smooth);
                text.append("    Root mean squared error:\t\t" + M5.doubleToStringG(Math.sqrt(Math.abs(this.meanSqrErr)), 9, 4) + "\t\t\t      " + set + smooth);
                text.append("    Relative absolute error:\t\t" + M5.doubleToStringF(this.meanAbsErr / absDev * 100.0, 9, 2) + " %\t\t\t      " + set + smooth);
                text.append("    Root relative squared error:\t" + M5.doubleToStringF(Math.sqrt(Math.abs(this.meanSqrErr)) / sd * 100.0, 9, 2) + " %\t\t\t      " + set + smooth);
                break;
            }
            case 1: {
                text.append("    Correlation coefficient:\t\t" + M5.doubleToStringF(this.correlation, 9, 3) + "\t\t\t      " + set + smooth);
                text.append("    Mean absolute error:\t\t" + M5.doubleToStringG(this.meanAbsErr, 9, 4) + "\t\t\t      " + set + smooth);
                text.append("    Root mean squared error:\t\t" + M5.doubleToStringG(Math.sqrt(Math.abs(this.meanSqrErr)), 9, 4) + "\t\t\t      " + set + smooth);
                text.append("    Relative absolute error:\t\tundefined\t\t\t      " + set + smooth);
                text.append("    Root relative squared error:\tundefined\t\t\t      " + set + smooth);
                break;
            }
            case 2: {
                text.append("    Correlation coefficient:\t\t" + M5.doubleToStringF(this.correlation, 9, 3) + "\t\t\t      " + set + smooth);
                text.append("    Mean absolute error:\t\tundefined\t\t\t      " + set + smooth);
                text.append("    Root mean squared error:\t\tundefined\t\t\t      " + set + smooth);
                text.append("    Relative absolute error:\t\tundefined\t\t\t      " + set + smooth);
                text.append("    Root relative squared error:\tundefined\t\t\t      " + set + smooth);
                break;
            }
            default: {
                M5.errorMsg("wrong type in Measures.print().");
            }
        }
        return text.toString();
    }

    public final void incremental(Measures m) {
        this.correlation += m.correlation;
        this.meanAbsErr += m.meanAbsErr;
        this.meanSqrErr += m.meanSqrErr;
    }
}

