/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.FuzzyApriori;

import java.io.IOException;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.FuzzyApriori.FuzzyRegion;
import keel.Dataset.Attributes;
import keel.Dataset.Instance;
import keel.Dataset.InstanceSet;

public class myDataset {
    public static final int NOMINAL = 0;
    public static final int INTEGER = 1;
    public static final int REAL = 2;
    private double[][] trueTransactions = null;
    private boolean[][] missing = null;
    private double[] emax;
    private double[] emin;
    private int nTrans;
    private int nInputs;
    private int nOutputs;
    private int nVars;
    private int nFuzzyRegionsForNumericAttributes;
    private double[][][] fuzzyTransactions = null;
    private FuzzyRegion[][] fuzzyAttributes = null;
    private int[] nLabels = null;
    private InstanceSet IS = new InstanceSet();

    public myDataset(int nFuzzyRegionsForNumericAttributes) {
        this.nFuzzyRegionsForNumericAttributes = nFuzzyRegionsForNumericAttributes > 0 ? nFuzzyRegionsForNumericAttributes : 1;
    }

    public double[][] getTrueTransactions() {
        return this.trueTransactions;
    }

    public double[][] getFuzzyTransaction(int idTrans) {
        return this.fuzzyTransactions[idTrans];
    }

    public FuzzyRegion[] getFuzzyAttribute(int idAttr) {
        return this.fuzzyAttributes[idAttr];
    }

    public int[] getNLabelsOfAttributes() {
        return this.nLabels;
    }

    public double[] getemax() {
        return this.emax;
    }

    public double[] getemin() {
        return this.emin;
    }

    public double getMax(int variable) {
        return this.emax[variable];
    }

    public double getMin(int variable) {
        return this.emin[variable];
    }

    public int getnTrans() {
        return this.nTrans;
    }

    public int getnVars() {
        return this.nVars;
    }

    public boolean isMissing(int i, int j) {
        return this.missing[i][j];
    }

    public void readDataSet(String datasetFile) throws IOException {
        try {
            int i;
            this.IS.readSet(datasetFile, true);
            this.nTrans = this.IS.getNumInstances();
            this.nInputs = Attributes.getInputNumAttributes();
            this.nOutputs = Attributes.getOutputNumAttributes();
            this.nVars = this.nInputs + this.nOutputs;
            this.trueTransactions = new double[this.nTrans][this.nVars];
            this.fuzzyTransactions = new double[this.nTrans][this.nVars][];
            this.fuzzyAttributes = new FuzzyRegion[this.nVars][];
            this.nLabels = new int[this.nVars];
            this.missing = new boolean[this.nTrans][this.nVars];
            this.emax = new double[this.nVars];
            this.emin = new double[this.nVars];
            for (i = 0; i < this.nVars; ++i) {
                if (this.getAttributeType(i) != 0) {
                    this.emax[i] = this.getMaxValue(i);
                    this.emin[i] = this.getMinValue(i);
                    continue;
                }
                this.emin[i] = 0.0;
                this.emax[i] = this.getNumNominalValues(i) - 1;
            }
            this.buildFuzzyRegions();
            for (i = 0; i < this.nTrans; ++i) {
                int j;
                Instance inst = this.IS.getInstance(i);
                for (j = 0; j < this.nInputs; ++j) {
                    this.trueTransactions[i][j] = this.IS.getInputNumericValue(i, j);
                    this.transformIntoFuzzySet(i, j);
                    this.missing[i][j] = inst.getInputMissingValues(j);
                    if (!this.missing[i][j]) continue;
                    this.trueTransactions[i][j] = this.emin[j] - 1.0;
                }
                int k = 0;
                while (k < this.nOutputs) {
                    this.trueTransactions[i][j] = this.IS.getOutputNumericValue(i, k);
                    this.transformIntoFuzzySet(i, j);
                    ++k;
                    ++j;
                }
            }
        }
        catch (Exception e) {
            System.out.println("DBG: Exception in readSet");
            e.printStackTrace();
        }
    }

    private void buildFuzzyRegions() {
        for (int id_attr = 0; id_attr < this.nVars; ++id_attr) {
            double rank = Math.abs(this.emax[id_attr] - this.emin[id_attr]);
            this.nLabels[id_attr] = this.getAttributeType(id_attr) == 0 ? (int)rank + 1 : this.nFuzzyRegionsForNumericAttributes;
            this.fuzzyAttributes[id_attr] = new FuzzyRegion[this.nLabels[id_attr]];
            double mark = rank / ((double)this.nLabels[id_attr] - 1.0);
            for (int id_label = 0; id_label < this.nLabels[id_attr]; ++id_label) {
                this.fuzzyAttributes[id_attr][id_label] = new FuzzyRegion();
                double value = this.emin[id_attr] + mark * (double)(id_label - 1);
                this.fuzzyAttributes[id_attr][id_label].setX0(this.setValue(value, this.emax[id_attr]));
                value = this.emin[id_attr] + mark * (double)id_label;
                this.fuzzyAttributes[id_attr][id_label].setX1(this.setValue(value, this.emax[id_attr]));
                value = this.emin[id_attr] + mark * (double)(id_label + 1);
                this.fuzzyAttributes[id_attr][id_label].setX3(this.setValue(value, this.emax[id_attr]));
                this.fuzzyAttributes[id_attr][id_label].setY(1.0);
                String str_label = this.getAttributeType(id_attr) == 0 ? new String(this.getNominalValue(id_attr, id_label)) : new String("LABEL_" + id_label);
                this.fuzzyAttributes[id_attr][id_label].setLabel(str_label);
            }
        }
    }

    private double setValue(double val, double tope) {
        if (val > -1.0E-4 && val < 1.0E-4) {
            return 0.0;
        }
        if (val > tope - 1.0E-4 && val < tope + 1.0E-4) {
            return tope;
        }
        return val;
    }

    private void transformIntoFuzzySet(int id_trans, int id_attr) {
        this.fuzzyTransactions[id_trans][id_attr] = new double[this.nLabels[id_attr]];
        for (int id_label = 0; id_label < this.nLabels[id_attr]; ++id_label) {
            this.fuzzyTransactions[id_trans][id_attr][id_label] = this.fuzzyAttributes[id_attr][id_label].getFuzzyValue(this.trueTransactions[id_trans][id_attr]);
        }
    }

    public boolean hasRealAttributes() {
        return Attributes.hasRealAttributes();
    }

    public boolean hasNumericalAttributes() {
        return Attributes.hasIntegerAttributes() || Attributes.hasRealAttributes();
    }

    public boolean hasMissingAttributes() {
        return this.sizeWithoutMissing() < this.getnTrans();
    }

    public int sizeWithoutMissing() {
        int tam = 0;
        for (int i = 0; i < this.nTrans; ++i) {
            int j;
            for (j = 1; j < this.nVars && !this.isMissing(i, j); ++j) {
            }
            if (j != this.nVars) continue;
            ++tam;
        }
        return tam;
    }

    public boolean[] getMissing(int pos) {
        return this.missing[pos];
    }

    public String getAttributeName(int id_attr) {
        if (id_attr < this.nInputs) {
            return Attributes.getInputAttribute(id_attr).getName();
        }
        return Attributes.getOutputAttribute(id_attr - this.nInputs).getName();
    }

    public int getAttributeType(int id_attr) {
        if (id_attr < this.nInputs) {
            return Attributes.getInputAttribute(id_attr).getType();
        }
        return Attributes.getOutputAttribute(id_attr - this.nInputs).getType();
    }

    public String getAttributeTypeString(int id_attr) {
        if (this.getAttributeType(id_attr) == 0) {
            return "NOMINAL";
        }
        if (this.getAttributeType(id_attr) == 1) {
            return "INTEGER";
        }
        return "REAL";
    }

    public boolean isNominal(int id_attr) {
        if (id_attr < this.nInputs) {
            return Attributes.getInputAttribute(id_attr).getType() == 0;
        }
        return Attributes.getOutputAttribute(id_attr - this.nInputs).getType() == 0;
    }

    public String getNominalValue(int id_attr, int id_val) {
        if (id_attr < this.nInputs) {
            return Attributes.getInputAttribute(id_attr).getNominalValue(id_val);
        }
        return Attributes.getOutputAttribute(id_attr - this.nInputs).getNominalValue(id_val);
    }

    private double getMaxValue(int id_attr) {
        if (id_attr < this.nInputs) {
            return Attributes.getInputAttribute(id_attr).getMaxAttribute();
        }
        return Attributes.getOutputAttribute(id_attr - this.nInputs).getMaxAttribute();
    }

    private double getMinValue(int id_attr) {
        if (id_attr < this.nInputs) {
            return Attributes.getInputAttribute(id_attr).getMinAttribute();
        }
        return Attributes.getOutputAttribute(id_attr - this.nInputs).getMinAttribute();
    }

    private int getNumNominalValues(int id_attr) {
        if (id_attr < this.nInputs) {
            return Attributes.getInputAttribute(id_attr).getNumNominalValues();
        }
        return Attributes.getOutputAttribute(id_attr - this.nInputs).getNumNominalValues();
    }
}

