/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Rule_Learning.ART;

import java.util.Collections;
import java.util.List;
import java.util.Vector;
import keel.Algorithms.Rule_Learning.ART.Attribute;
import keel.Algorithms.Rule_Learning.ART.Itemset;
import keel.Algorithms.Rule_Learning.ART.Node;
import keel.Algorithms.Rule_Learning.ART.Rule;

public class TBAR {
    int MaxSize;
    double MinSupp;
    Vector data;
    List<Attribute> attributes;
    Node root;
    Vector<Node> nodosNivel;

    public TBAR(int MaxSize, double MinSupp, Vector data, List<Attribute> attributes) {
        this.MaxSize = MaxSize;
        this.MinSupp = MinSupp;
        this.data = data;
        this.attributes = attributes;
        this.root = new Node();
        Vector<Node> nodes = new Vector<Node>();
        for (int i = 0; i < this.attributes.size() - 1; ++i) {
            Attribute a = this.attributes.get(i);
            for (int j = 0; j < a.numValues(); ++j) {
                Node n = new Node();
                Vector<Integer> ats = new Vector<Integer>();
                Vector<Integer> vals = new Vector<Integer>();
                ats.add(i);
                vals.add(j);
                n.setAttributes(ats);
                n.setValues(vals);
                n.setParent(this.root);
                nodes.add(n);
            }
        }
        this.root.setChildren(nodes);
        this.support(1);
    }

    public int getMaxSize() {
        return this.MaxSize;
    }

    public void setMaxSize(int MaxSize) {
        this.MaxSize = MaxSize;
    }

    public double getMinSupp() {
        return this.MinSupp;
    }

    public void setMinSupp(double MinSupp) {
        this.MinSupp = MinSupp;
    }

    public Vector getData() {
        return this.data;
    }

    public void setData(Vector data) {
        this.data = data;
    }

    public Node getRoot() {
        return this.root;
    }

    public void setRoot(Node root) {
        this.root = root;
    }

    private void support(int level) {
        Node node = null;
        this.nodosNivel = new Vector();
        this.nodosNivel(level, this.root);
        for (int i = 0; i < this.data.size(); ++i) {
            Itemset item = (Itemset)this.data.get(i);
            for (int j = 0; j < this.nodosNivel.size(); ++j) {
                node = this.nodosNivel.get(j);
                if (!this.coincide(node, item, level)) continue;
                node.setSupport(node.getSupport() + 1);
            }
        }
    }

    private void nodosNivel(int level, Node n) {
        if (level - 1 > 0) {
            for (int i = 0; i < n.numChildren(); ++i) {
                this.nodosNivel(level - 1, n.getChildren(i));
            }
        } else {
            for (int i = 0; i < n.numChildren(); ++i) {
                this.nodosNivel.add(n.getChildren(i));
            }
        }
    }

    private boolean coincide(Node n, Itemset item, int level) {
        int atributo;
        if (level - 1 > 0) {
            int atributo2;
            boolean ok = n.getAttributes().size() > 0 ? item.getValue(atributo2 = n.getAttributes().get(0).intValue()) == (double)n.getValues().get(0).intValue() : false;
            return ok && this.coincide(n.getParent(), item, level - 1);
        }
        boolean ok = n.getAttributes().size() > 0 ? item.getValue(atributo = n.getAttributes().get(0).intValue()) == (double)n.getValues().get(0).intValue() : false;
        return ok;
    }

    private Vector candidates(int level) {
        Vector nivel1 = new Vector();
        this.nodosNivel = new Vector();
        this.nodosNivel(1, this.root);
        nivel1 = (Vector)this.nodosNivel.clone();
        this.nodosNivel = new Vector();
        this.nodosNivel(level - 1, this.root);
        for (int i = 0; i < this.nodosNivel.size(); ++i) {
            this.expandir(this.nodosNivel.get(i), nivel1);
        }
        this.support(level);
        this.nodosNivel = new Vector();
        this.nodosNivel(level, this.root);
        return this.nodosNivel;
    }

    private void expandir(Node n, Vector<Node> nivel1) {
        Vector<Node> nodes = new Vector<Node>();
        for (int i = 0; i < nivel1.size(); ++i) {
            Node nivel = nivel1.get(i);
            if (nivel.getAttributes().get(0) <= n.getAttributes().get(0)) continue;
            Node node = new Node();
            Vector<Integer> ats = new Vector<Integer>();
            Vector<Integer> vals = new Vector<Integer>();
            ats.add(nivel.getAttributes().get(0));
            vals.add(nivel.getValues().get(0));
            node.setAttributes(ats);
            node.setValues(vals);
            node.setParent(n);
            nodes.add(node);
        }
        n.setChildren(nodes);
    }

    private Vector relevants(int level) {
        this.nodosNivel = new Vector();
        this.nodosNivel(level, this.root);
        Vector<Node> nodos = new Vector<Node>(this.nodosNivel);
        for (int i = 0; i < this.nodosNivel.size(); ++i) {
            Node n = this.nodosNivel.get(i);
            double supp = (double)n.getSupport() / (double)this.data.size();
            if (!(supp < this.MinSupp)) continue;
            nodos.remove(n);
            n.getParent().getChildren().remove(n);
        }
        return nodos;
    }

    public Vector<Vector<Rule>> ruleExtraction(int level) {
        int i;
        Vector<Vector<Rule>> conjuntos = new Vector<Vector<Rule>>();
        Vector<Rule> reglas = new Vector<Rule>();
        Vector reglasConfMax = new Vector();
        Vector nodos = new Vector();
        nodos = this.relevants(1);
        for (int k = 2; k <= level && nodos.size() >= k; ++k) {
            nodos = this.candidates(k);
            if (nodos.size() <= 0) continue;
            nodos = this.relevants(k);
        }
        int sum = 0;
        Vector<Itemset> itemsets = new Vector<Itemset>();
        Vector<Integer> ats = new Vector<Integer>();
        Vector<Integer> vals = new Vector<Integer>();
        for (int i2 = 0; i2 < nodos.size(); ++i2) {
            Node n = (Node)nodos.get(i2);
            itemsets = new Vector();
            ats = new Vector();
            vals = new Vector();
            while (n.getParent() != null) {
                ats.add(n.getAttributes().get(0));
                vals.add(n.getValues().get(0));
                n = n.getParent();
            }
            Collections.reverse(ats);
            Collections.reverse(vals);
            for (int j = 0; j < this.data.size(); ++j) {
                if (!this.coincide((Node)nodos.get(i2), (Itemset)this.data.get(j), level)) continue;
                itemsets.add((Itemset)this.data.get(j));
            }
            Attribute a = this.attributes.get(this.MaxSize);
            for (int l = 0; l < a.numValues(); ++l) {
                sum = 0;
                for (int m = 0; m < itemsets.size(); ++m) {
                    Itemset it = (Itemset)itemsets.get(m);
                    if (it.getValue(this.MaxSize) != (double)l) continue;
                    ++sum;
                }
                Rule r = new Rule(ats, vals);
                r.setClas(l);
                r.setConfidence((double)sum / (double)itemsets.size());
                r.setSupport(sum);
                reglas.add(r);
            }
        }
        double confMax = 0.0;
        for (i = 0; i < reglas.size(); ++i) {
            if (!(((Rule)reglas.get(i)).getConfidence() > confMax)) continue;
            confMax = ((Rule)reglas.get(i)).getConfidence();
        }
        for (i = 0; i < reglas.size(); ++i) {
            if (((Rule)reglas.get(i)).getConfidence() != confMax) continue;
            reglasConfMax.add(reglas.get(i));
        }
        Vector conjunto = new Vector();
        if (reglasConfMax.size() > 0) {
            conjunto.add(reglasConfMax.get(0));
            ats = new Vector<Integer>(((Rule)reglasConfMax.get(0)).getAttributes());
        }
        for (int i3 = 1; i3 < reglasConfMax.size(); ++i3) {
            if (!ats.equals(((Rule)reglasConfMax.get(i3)).getAttributes())) {
                conjuntos.add(conjunto);
                conjunto = new Vector();
                conjunto.add(reglasConfMax.get(i3));
                ats = new Vector<Integer>(((Rule)reglasConfMax.get(i3)).getAttributes());
                continue;
            }
            conjunto.add(reglasConfMax.get(i3));
        }
        if (conjunto.size() != 0) {
            conjuntos.add(conjunto);
        }
        return conjuntos;
    }
}

