/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.problem.classification.freitas;

import java.util.Comparator;
import net.sourceforge.jclec.IConfigure;
import net.sourceforge.jclec.IFitness;
import net.sourceforge.jclec.IIndividual;
import net.sourceforge.jclec.base.AbstractEvaluator;
import net.sourceforge.jclec.fitness.SimpleValueFitness;
import net.sourceforge.jclec.fitness.ValueFitnessComparator;
import net.sourceforge.jclec.problem.classification.Individual;
import net.sourceforge.jclec.problem.classification.SyntaxTreeClassificationRule;
import net.sourceforge.jclec.syntaxtree.SyntaxTree;
import net.sourceforge.jclec.util.dataset.CategoricalAttribute;
import net.sourceforge.jclec.util.dataset.IDataset;
import net.sourceforge.jclec.util.dataset.IMetadata;
import net.sourceforge.jclec.util.random.IRandGen;
import org.apache.commons.configuration.Configuration;

public class FreitasEvaluator
extends AbstractEvaluator
implements IConfigure {
    private static final long serialVersionUID = 3613350191235561000L;
    protected SyntaxTreeClassificationRule rule;
    protected IDataset dataset;
    private boolean maximize = true;
    protected IRandGen randgen;
    protected int maxDerivSize;
    protected transient ValueFitnessComparator comparator;

    public IDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(IDataset dataset) {
        this.dataset = dataset;
    }

    public void setRandGen(IRandGen randgen) {
        this.randgen = randgen;
    }

    public IRandGen getRandGen() {
        return this.randgen;
    }

    public int getMaxDerivSize() {
        return this.maxDerivSize;
    }

    public void setMaxDerivSize(int maxDerivSize) {
        this.maxDerivSize = maxDerivSize;
    }

    @Override
    public void configure(Configuration settings) {
    }

    @Override
    protected void evaluate(IIndividual ind) {
        Individual find = (Individual)ind;
        this.rule = (SyntaxTreeClassificationRule)find.getPhenotype();
        IMetadata metadata = this.getDataset().getMetadata();
        CategoricalAttribute catAttribute = (CategoricalAttribute)metadata.getAttribute(metadata.getClassIndex());
        int numClass = catAttribute.getCategories().size();
        int[] tp = new int[numClass];
        int[] tn = new int[numClass];
        int[] fn = new int[numClass];
        int[] fp = new int[numClass];
        IDataset.IInstance[] instances = this.getDataset().getInstances();
        int numInstances = instances.length;
        int j = 0;
        while (j < numInstances) {
            int i;
            double value;
            IDataset.IInstance instance = instances[j];
            if (this.rule.covers(instance)) {
                value = instance.getValue(metadata.getClassIndex());
                int n = (int)value;
                tp[n] = tp[n] + 1;
                i = 0;
                while (i < numClass) {
                    if ((int)value != i) {
                        int n2 = i;
                        fp[n2] = fp[n2] + 1;
                    }
                    ++i;
                }
            } else {
                value = instance.getValue(metadata.getClassIndex());
                int n = (int)value;
                fn[n] = fn[n] + 1;
                i = 0;
                while (i < numClass) {
                    if ((int)value != i) {
                        int n3 = i;
                        tn[n3] = tn[n3] + 1;
                    }
                    ++i;
                }
            }
            ++j;
        }
        double se = -1.0;
        double sp = 1.0;
        int bestClass = -1;
        int i = 0;
        while (i < numClass) {
            double spAux;
            double seAux = tp[i] + fn[i] == 0 ? 1.0 : (double)tp[i] / (double)(tp[i] + fn[i]);
            if (seAux * (spAux = tn[i] + fp[i] == 0 ? 1.0 : (double)tn[i] / (double)(tn[i] + fp[i])) == se * sp) {
                bestClass = i;
            }
            if (seAux * spAux > se * sp) {
                se = seAux;
                sp = spAux;
                bestClass = i;
            }
            ++i;
        }
        this.rule.setConsequent(bestClass);
        double numnodes = ((SyntaxTree)find.getGenotype()).derivSize();
        double sy = ((double)this.getMaxDerivSize() - 0.5 * numnodes - 0.5) / (double)(this.getMaxDerivSize() - 1);
        ind.setFitness(new SimpleValueFitness(se * sp * sy));
    }

    @Override
    public Comparator<IFitness> getComparator() {
        if (this.comparator == null) {
            this.comparator = new ValueFitnessComparator(!this.maximize);
        }
        return this.comparator;
    }
}

