/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Rule_Learning.PART;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import keel.Algorithms.Rule_Learning.PART.Algorithm;
import keel.Algorithms.Rule_Learning.PART.Itemset;
import keel.Algorithms.Rule_Learning.PART.MyDataset;
import keel.Algorithms.Rule_Learning.PART.SelectCut;
import keel.Algorithms.Rule_Learning.PART.Tree;
import keel.Algorithms.Rule_Learning.PART.parseParameters;

public class C45
extends Algorithm {
    private Tree root;
    private boolean prune = true;
    private float confidence = 0.25f;
    private int minItemsets = 2;
    private double[] priorsProbabilities;
    private static int marginResolution = 500;
    private double[] marginCounts;
    private double classPriorsSum;

    public C45(parseParameters paramFile) throws Exception {
        try {
            long startTime = System.currentTimeMillis();
            modelFileName = paramFile.getTrainingInputFile();
            trainFileName = paramFile.getValidationInputFile();
            testFileName = paramFile.getTestInputFile();
            this.prune = Boolean.valueOf(paramFile.getParameter(1));
            this.confidence = Float.parseFloat(paramFile.getParameter(2));
            this.minItemsets = Integer.parseInt(paramFile.getParameter(3));
            if (this.confidence < 0.0f || this.confidence > 1.0f) {
                this.confidence = 0.25f;
                System.err.println("Error: Confidence must be in the interval [0,1]");
                System.err.println("Using default value: 0.25");
            }
            if (this.minItemsets <= 0) {
                this.minItemsets = 2;
                System.err.println("Error: itemsetPerLeaf must be greater than 0");
                System.err.println("Using default value: 2");
            }
            this.modelDataset = new MyDataset(modelFileName, true);
            this.trainDataset = new MyDataset(trainFileName, false);
            this.testDataset = new MyDataset(testFileName, false);
            this.priorsProbabilities = new double[this.modelDataset.numClasses()];
            this.priorsProbabilities();
            this.marginCounts = new double[marginResolution + 1];
            this.generateTree(this.modelDataset);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.exit(-1);
        }
    }

    public C45(MyDataset data, boolean pruned, float cf, int minItemsets) throws Exception {
        try {
            long startTime = System.currentTimeMillis();
            this.prune = pruned;
            this.confidence = cf;
            this.minItemsets = minItemsets;
            this.modelDataset = data;
            this.priorsProbabilities = new double[this.modelDataset.numClasses()];
            this.priorsProbabilities();
            this.marginCounts = new double[marginResolution + 1];
            this.generateTree(this.modelDataset);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.exit(-1);
        }
    }

    @Override
    protected void setOptions(StreamTokenizer options) throws Exception {
        options.nextToken();
        if (options.sval.equalsIgnoreCase("algorithm")) {
            options.nextToken();
            options.nextToken();
            options.nextToken();
            System.out.println(options.sval + "\n");
            options.nextToken();
            System.out.println(options.sval + "\n");
            if (options.sval.equalsIgnoreCase("inputData")) {
                options.nextToken();
                options.nextToken();
                modelFileName = options.sval;
                System.out.println("Hay inputs\n");
                if (options.nextToken() != 10) {
                    trainFileName = options.sval;
                    options.nextToken();
                    testFileName = options.sval;
                    if (options.nextToken() != 10) {
                        trainFileName = modelFileName;
                        options.nextToken();
                    }
                    System.out.println(trainFileName + "\n");
                    System.out.println(testFileName + "\n");
                }
            } else {
                throw new Exception("No file test provided.");
            }
            do {
                if (options.nextToken() != -1) continue;
                throw new Exception("No output file provided.");
            } while (options.sval == null || !options.sval.equalsIgnoreCase("outputData"));
            options.nextToken();
            options.nextToken();
            trainOutputFileName = options.sval;
            options.nextToken();
            testOutputFileName = options.sval;
            options.nextToken();
            resultFileName = options.sval;
            System.out.println(trainOutputFileName + "\n");
            System.out.println(testOutputFileName + "\n");
            System.out.println(resultFileName + "\n");
            if (!this.getNextToken(options)) {
                return;
            }
            while (options.ttype != -1) {
                if (options.sval.equalsIgnoreCase("pruned")) {
                    options.nextToken();
                    options.nextToken();
                    this.prune = options.sval.equalsIgnoreCase("TRUE");
                }
                if (options.sval.equalsIgnoreCase("confidence")) {
                    if (!this.prune) {
                        throw new Exception("Doesn't make sense to change confidence for prune tree!");
                    }
                    options.nextToken();
                    options.nextToken();
                    float cf = Float.parseFloat(options.sval);
                    if (cf <= 1.0f || cf >= 0.0f) {
                        this.confidence = Float.parseFloat(options.sval);
                    }
                }
                if (options.sval.equalsIgnoreCase("itemsetsPerLeaf")) {
                    options.nextToken();
                    options.nextToken();
                    if (Integer.parseInt(options.sval) > 0) {
                        this.minItemsets = Integer.parseInt(options.sval);
                    }
                }
                this.getNextToken(options);
            }
        }
    }

    public void generateTree(MyDataset itemsets) throws Exception {
        SelectCut selectCut = new SelectCut(this.minItemsets, itemsets);
        this.root = new Tree(selectCut, this.prune, this.confidence);
        this.root.buildTree(itemsets);
        this.root.isUnexplored = false;
    }

    public double evaluateItemset(Itemset itemset) throws Exception {
        Itemset classMissing = (Itemset)itemset.copy();
        double prediction = 0.0;
        classMissing.setDataset(itemset.getDataset());
        classMissing.setClassMissing();
        double[] classification = this.classificationForItemset(classMissing);
        prediction = C45.maxIndex(classification);
        this.updateStats(classification, itemset, itemset.numClasses());
        return prediction;
    }

    private void updateStats(double[] predictedClassification, Itemset itemset, int nClasses) {
        int actualClass = (int)itemset.getClassValue();
        if (!itemset.classIsMissing()) {
            this.updateMargins(predictedClassification, actualClass, nClasses);
            int predictedClass = -1;
            double bestProb = 0.0;
            for (int i = 0; i < nClasses; ++i) {
                if (!(predictedClassification[i] > bestProb)) continue;
                predictedClass = i;
                bestProb = predictedClassification[i];
            }
            if (predictedClass < 0) {
                return;
            }
            double predictedProb = Math.max(Double.MIN_VALUE, predictedClassification[actualClass]);
            double priorProb = Math.max(Double.MIN_VALUE, this.priorsProbabilities[actualClass] / this.classPriorsSum);
        }
    }

    public final double[] classificationForItemset(Itemset itemset) throws Exception {
        return this.root.classificationForItemset(itemset);
    }

    private void updateMargins(double[] predictedClassification, int actualClass, int nClasses) {
        int bin;
        double probActual = predictedClassification[actualClass];
        double probNext = 0.0;
        for (int i = 0; i < nClasses; ++i) {
            if (i == actualClass || !(predictedClassification[i] > probNext)) continue;
            probNext = predictedClassification[i];
        }
        double margin = probActual - probNext;
        int n = bin = (int)((margin + 1.0) / 2.0 * (double)marginResolution);
        this.marginCounts[n] = this.marginCounts[n] + 1.0;
    }

    private boolean isBoolean(String value) {
        return value.equalsIgnoreCase("TRUE") || value.equalsIgnoreCase("FALSE");
    }

    public static int maxIndex(double[] doubles) {
        double maximum = 0.0;
        int maxIndex = 0;
        for (int i = 0; i < doubles.length; ++i) {
            if (i != 0 && !(doubles[i] > maximum)) continue;
            maxIndex = i;
            maximum = doubles[i];
        }
        return maxIndex;
    }

    public void priorsProbabilities() throws Exception {
        int i;
        for (i = 0; i < this.modelDataset.numClasses(); ++i) {
            this.priorsProbabilities[i] = 1.0;
        }
        this.classPriorsSum = this.modelDataset.numClasses();
        for (i = 0; i < this.modelDataset.numItemsets(); ++i) {
            if (this.modelDataset.itemset(i).classIsMissing()) continue;
            try {
                int n = (int)this.modelDataset.itemset(i).getClassValue();
                this.priorsProbabilities[n] = this.priorsProbabilities[n] + this.modelDataset.itemset(i).getWeight();
                this.classPriorsSum += this.modelDataset.itemset(i).getWeight();
                continue;
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
    }

    @Override
    public void printResult() throws IOException {
        long totalTime = (System.currentTimeMillis() - this.startTime) / 1000L;
        long seconds = totalTime % 60L;
        long minutes = (totalTime - seconds) % 3600L / 60L;
        String tree = "";
        tree = tree + this.toString();
        tree = tree + "\n@TotalNumberOfNodes " + Tree.NumberOfNodes;
        tree = tree + "\n@NumberOfLeafs " + Tree.NumberOfLeafs;
        tree = tree + "\n\n@NumberOfItemsetsTraining " + this.trainDataset.numItemsets();
        tree = tree + "\n@NumberOfCorrectlyClassifiedTraining " + this.correct;
        tree = tree + "\n@PercentageOfCorrectlyClassifiedTraining " + (float)((double)this.correct * 100.0) / (float)this.trainDataset.numItemsets() + "%";
        tree = tree + "\n@NumberOfInCorrectlyClassifiedTraining " + (this.trainDataset.numItemsets() - this.correct);
        tree = tree + "\n@PercentageOfInCorrectlyClassifiedTraining " + (float)((double)(this.trainDataset.numItemsets() - this.correct) * 100.0) / (float)this.trainDataset.numItemsets() + "%";
        tree = tree + "\n\n@NumberOfItemsetsTest " + this.testDataset.numItemsets();
        tree = tree + "\n@NumberOfCorrectlyClassifiedTest " + this.testCorrect;
        tree = tree + "\n@PercentageOfCorrectlyClassifiedTest " + (float)((double)this.testCorrect * 100.0) / (float)this.testDataset.numItemsets() + "%";
        tree = tree + "\n@NumberOfInCorrectlyClassifiedTest " + (this.testDataset.numItemsets() - this.testCorrect);
        tree = tree + "\n@PercentageOfInCorrectlyClassifiedTest " + (float)((double)(this.testDataset.numItemsets() - this.testCorrect) * 100.0) / (float)this.testDataset.numItemsets() + "%";
        tree = tree + "\n\n@ElapsedTime " + (totalTime - minutes * 60L - seconds) / 3600L + ":" + minutes / 60L + ":" + seconds;
        PrintWriter resultPrint = new PrintWriter(new FileWriter(resultFileName));
        resultPrint.print(this.getHeader() + "\n@decisiontree\n\n" + tree);
        resultPrint.close();
    }

    @Override
    public void printTrain() {
        String text = this.getHeader();
        for (int i = 0; i < this.trainDataset.numItemsets(); ++i) {
            try {
                Itemset itemset = this.trainDataset.itemset(i);
                int cl = (int)this.evaluateItemset(itemset);
                if (cl == (int)itemset.getValue(this.trainDataset.getClassIndex())) {
                    ++this.correct;
                }
                text = text + this.trainDataset.getClassAttribute().value(cl) + " " + this.trainDataset.getClassAttribute().value((int)itemset.getClassValue()) + "\n";
                continue;
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
        try {
            PrintWriter print = new PrintWriter(new FileWriter(trainOutputFileName));
            print.print(text);
            print.close();
        }
        catch (IOException e) {
            System.err.println("Can not open the training output file: " + e.getMessage());
        }
    }

    @Override
    public void printTest() {
        String text = this.getHeader();
        for (int i = 0; i < this.testDataset.numItemsets(); ++i) {
            try {
                int cl = (int)this.evaluateItemset(this.testDataset.itemset(i));
                Itemset itemset = this.testDataset.itemset(i);
                if (cl == (int)itemset.getValue(this.testDataset.getClassIndex())) {
                    ++this.testCorrect;
                }
                text = text + this.testDataset.getClassAttribute().value(cl) + " " + this.testDataset.getClassAttribute().value((int)itemset.getClassValue()) + "\n";
                continue;
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
        try {
            PrintWriter print = new PrintWriter(new FileWriter(testOutputFileName));
            print.print(text);
            print.close();
        }
        catch (IOException e) {
            System.err.println("Can not open the training output file.");
        }
    }

    public String toString() {
        return this.root.toString();
    }

    public Tree getTree() {
        return this.root;
    }
}

