/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.selector;

import net.sf.jclec.IConfigure;
import net.sf.jclec.IIndividual;
import net.sf.jclec.ISystem;
import net.sf.jclec.fitness.IValueFitness;
import net.sf.jclec.selector.RouletteSelector;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.builder.EqualsBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoltzmannSelector<I extends IIndividual>
extends RouletteSelector<I>
implements IConfigure {
    private static final long serialVersionUID = -422501366558313344L;
    private double initialTemp;
    private double tempDecr;
    private double actualTemp;

    public BoltzmannSelector() {
    }

    public BoltzmannSelector(ISystem<I> context) {
        super(context);
    }

    public double getInitialTemp() {
        return this.initialTemp;
    }

    public void setInitialTemp(double initialTemp) {
        this.initialTemp = initialTemp;
        this.actualTemp = initialTemp;
    }

    public double getTempDecr() {
        return this.tempDecr;
    }

    public void setTempDecr(double tempDecr) {
        this.tempDecr = tempDecr;
    }

    @Override
    public void configure(Configuration configuration) {
        double initialTemp = configuration.getDouble("initial-temp");
        this.setInitialTemp(initialTemp);
        double tempDecr = configuration.getDouble("temp-decr");
        this.setTempDecr(tempDecr);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof BoltzmannSelector) {
            BoltzmannSelector o = (BoltzmannSelector)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append(this.initialTemp, o.initialTemp);
            eb.append(this.tempDecr, o.tempDecr);
            return eb.isEquals();
        }
        return false;
    }

    @Override
    protected void prepareSelection() {
        this.updateTemperature();
        if (this.roulette == null || this.roulette.length != this.actsrcsz) {
            this.roulette = new double[this.actsrcsz];
        }
        double acc = 0.0;
        int idx = 0;
        for (IIndividual ind : this.actsrc) {
            double val = ((IValueFitness)ind.getFitness()).getValue();
            val = Math.exp(val / this.actualTemp);
            this.roulette[idx++] = acc += val;
        }
        while (idx > 0) {
            int n = --idx;
            this.roulette[n] = this.roulette[n] / acc;
        }
    }

    protected final void updateTemperature() {
        this.actualTemp *= this.tempDecr;
    }
}

