/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.utilities;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import keel.Algorithms.Instance_Generation.utilities.Debug;
import org.core.Randomize;

public class RandomGenerator
extends Randomize {
    protected static Random random = null;
    protected static long seed = 0L;

    public static void setSeed(long s) {
        seed = s;
        Randomize.setSeed(s);
        random = new Random();
        random.setSeed(s);
    }

    public static ArrayList<Integer> generateDifferentRandomIntegersWithStep(int min, int max, int inc) {
        Debug.endsIf(max < min, "Limits of generateDifferentRandomIntegers are wrong. [" + min + ", " + max + "]");
        int number = (max - min + 1) / inc;
        ArrayList<Integer> list = new ArrayList<Integer>(number);
        for (int i = min; i <= max; i += inc) {
            list.add(i);
        }
        Collections.shuffle(list, random);
        return list;
    }

    public static ArrayList<Integer> generateDifferentRandomIntegers(int min, int max) {
        Debug.endsIf(max < min, "Limits of generateDifferentRandomIntegers are wrong. [" + min + ", " + max + "]");
        int number = max - min + 1;
        ArrayList<Integer> list = new ArrayList<Integer>(number);
        for (int i = min; i <= max; ++i) {
            list.add(i);
        }
        Collections.shuffle(list, random);
        return list;
    }

    public static ArrayList<Integer> generateDifferentRandomIntegers(int min, int max, int number) {
        Debug.endsIf(max < min, "Limits of generateDifferentRandomIntegers are wrong. [" + min + ", " + max + "]");
        ArrayList<Integer> list = new ArrayList<Integer>(number);
        int count = 0;
        for (int i = min; count < number && i <= max; ++count, ++i) {
            list.add(i);
        }
        Collections.shuffle(list, random);
        return list;
    }

    public static ArrayList<Double> generateDifferentRandomNumbersWithStep(double min, double max, double inc) {
        Debug.endsIf(max < min, "Limits of generateDifferentRandomIntegers are wrong. [" + min + ", " + max + "]");
        int number = (int)Math.floor((max - min + 1.0) / inc);
        ArrayList<Double> list = new ArrayList<Double>(number);
        for (double i = min; i <= max; i += inc) {
            list.add(i);
        }
        Collections.shuffle(list, random);
        return list;
    }

    public static ArrayList<Double> generateDifferentRandomNumbers(double min, double max) {
        Debug.endsIf(max < min, "Limits of generateDifferentRandomNumbers are wrong. [" + min + ", " + max + "]");
        int number = (int)(max - min + 1.0);
        ArrayList<Double> list = new ArrayList<Double>(number);
        for (double i = min; i <= max; i += 1.0) {
            list.add(i);
        }
        Collections.shuffle(list, random);
        return list;
    }

    public static ArrayList<Double> generateDifferentRandomNumbers(double min, double max, int number) {
        Debug.endsIf(max < min, "Limits of generateDifferentRandomNumbers are wrong. [" + min + ", " + max + "]");
        ArrayList<Double> list = new ArrayList<Double>(number);
        int count = 0;
        for (double i = min; count < number && i <= max; ++count, i += 1.0) {
            list.add(i);
        }
        Collections.shuffle(list, random);
        return list;
    }

    public static <T> T randomSelector(T a, T b) {
        T result = a;
        if (RandomGenerator.Randint(0, 1) == 0) {
            result = b;
        }
        return result;
    }
}

