/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.util.tests;

import cc.mallet.types.MatrixOps;
import cc.mallet.util.Randoms;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestRandom
extends TestCase {
    public TestRandom(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite((Class<?>)TestRandom.class);
    }

    public static void testAsJava() {
        Randoms mRand = new Randoms();
        Random jRand = mRand.asJavaRandom();
        int size = 100000;
        double[] vals = new double[size];
        for (int i = 0; i < size; ++i) {
            vals[i] = jRand.nextGaussian();
        }
        TestRandom.assertEquals(0.0, MatrixOps.mean(vals), 0.01);
        TestRandom.assertEquals(1.0, MatrixOps.stddev(vals), 0.01);
    }

    public static void main(String[] args) throws Throwable {
        TestSuite theSuite;
        if (args.length > 0) {
            theSuite = new TestSuite();
            for (int i = 0; i < args.length; ++i) {
                theSuite.addTest(new TestRandom(args[i]));
            }
        } else {
            theSuite = (TestSuite)TestRandom.suite();
        }
        TestRunner.run(theSuite);
    }
}

