## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
library(multilandr)

# Loads points
elchaco_sites <- terra::vect(system.file("extdata", "elchaco_sites.gpkg", package = "multilandr"))

## ----eval=FALSE---------------------------------------------------------------
#  # Loads main raster of land covers
#  elchaco <- terra::rast(system.file("extdata", "elchaco.tif", package = "multilandr"))
#  # Loads extra raster of NDVI values
#  elchaco_ndvi <- terra::rast(system.file("extdata", "elchaco_ndvi.tif", package = "multilandr"))

## -----------------------------------------------------------------------------
cl_names <- c(1, "Forest",
              2, "Grassland",
              3, "Crops",
              4, "Pastures",
              5, "Water",
              6, "Urban")

## ----message=FALSE, eval=FALSE------------------------------------------------
#  # Creates 'MultiLand' object by loading points, the main raster and an extra raster.
#  ernesdesign <- mland(points_layer = elchaco_sites,
#                       rast_layer = elchaco,
#                       radii = seq(1000, 5000, 1000),
#                       class_names = list(cl_names),
#                       site_ref = "name",
#                       ext_rast_layer = elchaco_ndvi,
#                       rast_names = c("landcover", "NDVI"))

## ----eval=FALSE---------------------------------------------------------------
#  # Returns basic information about the object
#  ernesdesign

## ----eval=FALSE---------------------------------------------------------------
#  class             : MultiLand
#  On the fly        : FALSE
#  Raster layers     : 1
#    n classes       : 6
#  Ext. raster layers: 1
#  n points          : 15
#  Site reference    : "name"
#  Radii (m)         : 1000 2000 3000 4000 5000

## ----eval = FALSE-------------------------------------------------------------
#  mland_save(ernesdesign)

## ----eval=FALSE---------------------------------------------------------------
#  mland_plot(ernesdesign, points = "Peje", title = "sitename")

## ----results = FALSE, message = FALSE, eval=FALSE-----------------------------
#  # User-defined function: quotient between mean and standard deviation
#  mean_sd <- function(x){ mean(x)/sd(x) }
#  
#  # Calculation of metrics
#  ed_metrics <- mland_metrics(ernesdesign,
#                              level = "class",
#                              metric = c("pland", "ed"),
#                              absence_values = list("pland" = 0),
#                              ext_calc = list(c("NDVI", "mean"), c(1, "mean_sd")))

## -----------------------------------------------------------------------------
# Returns basic information about the object
ed_metrics

## -----------------------------------------------------------------------------
head(ed_metrics@data)

