/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.stereo;

import java.util.List;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.interfaces.ITetrahedralChirality;
import org.openscience.cdk.stereo.AbstractStereo;

public final class ExtendedTetrahedral
extends AbstractStereo<IAtom, IAtom> {
    public ExtendedTetrahedral(IAtom focus, IAtom[] peripherals, ITetrahedralChirality.Stereo winding) {
        this(focus, peripherals, ITetrahedralChirality.Stereo.toConfig((ITetrahedralChirality.Stereo)winding));
    }

    public ExtendedTetrahedral(IAtom focus, IAtom[] peripherals, int config) {
        super((IChemObject)focus, (IChemObject[])peripherals, 0x4300 | 0xFF & config);
    }

    public IAtom focus() {
        return (IAtom)this.getFocus();
    }

    public IAtom[] peripherals() {
        return this.getCarriers().toArray(new IAtom[4]);
    }

    public ITetrahedralChirality.Stereo winding() {
        return ITetrahedralChirality.Stereo.toStereo((int)this.getConfigOrder());
    }

    private static IAtom getOtherNbr(IAtomContainer mol, IAtom atom, IAtom other) {
        IAtom res = null;
        for (IBond bond : mol.getConnectedBondsList(atom)) {
            IAtom nbr;
            if (bond.getOrder() != IBond.Order.DOUBLE || (nbr = bond.getOther(atom)).equals(other)) continue;
            if (res != null) {
                return null;
            }
            res = nbr;
        }
        return res;
    }

    public static IAtom[] findTerminalAtoms(IAtomContainer container, IAtom focus) {
        List focusBonds = container.getConnectedBondsList(focus);
        if (focusBonds.size() != 2) {
            throw new IllegalArgumentException("focus must have exactly 2 neighbors");
        }
        IAtom leftPrev = focus;
        IAtom rightPrev = focus;
        IAtom left = ((IBond)focusBonds.get(0)).getOther(focus);
        IAtom right = ((IBond)focusBonds.get(1)).getOther(focus);
        while (left != null && right != null) {
            IAtom tmp = ExtendedTetrahedral.getOtherNbr(container, left, leftPrev);
            leftPrev = left;
            left = tmp;
            tmp = ExtendedTetrahedral.getOtherNbr(container, right, rightPrev);
            rightPrev = right;
            right = tmp;
        }
        return new IAtom[]{leftPrev, rightPrev};
    }

    public IAtom[] findTerminalAtoms(IAtomContainer container) {
        List carriers;
        IAtom[] atoms = ExtendedTetrahedral.findTerminalAtoms(container, (IAtom)this.getFocus());
        if (container.getBond(atoms[0], (IAtom)(carriers = this.getCarriers()).get(2)) != null || container.getBond(atoms[0], (IAtom)carriers.get(3)) != null) {
            IAtom tmp = atoms[0];
            atoms[0] = atoms[1];
            atoms[1] = tmp;
        }
        return atoms;
    }

    public static int getLength(IAtomContainer container, IAtom focus) {
        int length = 0;
        List focusBonds = container.getConnectedBondsList(focus);
        if (focusBonds.size() != 2) {
            throw new IllegalArgumentException("focus must have exactly 2 neighbors");
        }
        IAtom leftPrev = focus;
        IAtom rightPrev = focus;
        IAtom left = ((IBond)focusBonds.get(0)).getOther(focus);
        IAtom right = ((IBond)focusBonds.get(1)).getOther(focus);
        while (left != null && right != null) {
            IAtom tmp = ExtendedTetrahedral.getOtherNbr(container, left, leftPrev);
            leftPrev = left;
            left = tmp;
            tmp = ExtendedTetrahedral.getOtherNbr(container, right, rightPrev);
            rightPrev = right;
            right = tmp;
            ++length;
        }
        return 2 * length;
    }

    @Override
    protected IStereoElement<IAtom, IAtom> create(IAtom focus, List<IAtom> carriers, int cfg) {
        return new ExtendedTetrahedral(focus, carriers.toArray(new IAtom[4]), cfg);
    }
}

