/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints;

import gnu.trove.list.array.TIntArrayList;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Function;
import org.chocosolver.memory.structure.IOperation;
import org.chocosolver.sat.Reason;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Identity;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.constraints.UpdatablePropagator;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.IntCircularQueue;
import org.chocosolver.util.objects.queues.CircularQueue;

public abstract class Propagator<V extends Variable>
implements ICause,
Identity,
Comparable<Propagator<V>> {
    private static final short NEW = 0;
    private static final short REIFIED = 1;
    protected static final short ACTIVE = 2;
    private static final short PASSIVE = 3;
    private boolean enabled = true;
    private final int ID;
    protected short state = 0;
    protected IOperation[] operations;
    private final boolean swapOnPassivate;
    protected final Priority priority;
    protected final boolean reactToFineEvt;
    protected Constraint constraint;
    protected final Model model;
    protected V[] vars;
    private int[] vindices;
    private boolean scheduled;
    private IntCircularQueue eventsets;
    private int[] eventmasks;
    private int position = -1;
    private IntIntConsumer fineevt = (i, m) -> {};
    private BoolVar reifVar;

    protected Propagator(V[] vars, Priority priority, boolean reactToFineEvt, boolean swapOnPassivate) {
        assert (vars != null && vars.length > 0 && vars[0] != null) : "wrong variable set in propagator constructor";
        this.model = vars[0].getModel();
        this.reactToFineEvt = reactToFineEvt;
        this.priority = priority;
        this.vars = this.model.getSettings().cloneVariableArrayInPropagator() ? (Variable[])vars.clone() : vars;
        this.vindices = new int[vars.length];
        Arrays.fill(this.vindices, -1);
        this.ID = this.model.nextId();
        this.swapOnPassivate = this.model.getSettings().swapOnPassivate() & swapOnPassivate;
        this.operations = new IOperation[3];
        this.operations[0] = () -> {
            this.state = 0;
        };
        this.operations[1] = () -> {
            this.state = 1;
        };
        this.operations[2] = () -> {
            this.state = (short)2;
        };
        this.eventmasks = new int[vars.length];
        if (this.reactToFineEvent()) {
            this.eventsets = new IntCircularQueue(vars.length);
            this.eventmasks = new int[vars.length];
            this.fineevt = (i, m) -> {
                if (this.eventmasks[i] == 0) {
                    this.eventsets.addLast(i);
                }
                int n = i;
                this.eventmasks[n] = this.eventmasks[n] | m;
            };
        }
    }

    protected Propagator(V[] vars, Priority priority, boolean reactToFineEvt) {
        this((Variable[])vars, priority, reactToFineEvt, true);
    }

    @SafeVarargs
    protected Propagator(V ... vars) {
        this((Variable[])vars, PropagatorPriority.LINEAR, false);
    }

    @SafeVarargs
    protected final void addVariable(V ... nvars) {
        assert (!this.swapOnPassivate) : "Cannot add variable to a propagator that allows being swapped on passivate";
        V[] tmp = this.vars;
        this.vars = (Variable[])Arrays.copyOf(this.vars, this.vars.length + nvars.length);
        System.arraycopy(nvars, 0, this.vars, tmp.length, nvars.length);
        int[] itmp = this.vindices;
        this.vindices = new int[this.vars.length];
        System.arraycopy(itmp, 0, this.vindices, 0, itmp.length);
        for (int v = tmp.length; v < this.vars.length; ++v) {
            this.vars[v].link(this, v);
        }
        if (this.reactToFineEvt) {
            itmp = this.eventmasks;
            this.eventmasks = new int[this.vars.length];
            System.arraycopy(itmp, 0, this.eventmasks, 0, itmp.length);
        }
        if (this.model.getSolver().getEngine().isInitialized()) {
            this.model.getSolver().getEngine().updateInvolvedVariables(this);
        }
    }

    public final void linkVariables() {
        for (int v = 0; v < this.vars.length; ++v) {
            if (this.vars[v].isAConstant()) continue;
            this.vars[v].link(this, v);
        }
    }

    public final void unlinkVariables() {
        for (int v = 0; v < this.vars.length; ++v) {
            if (this.vars[v].isAConstant()) continue;
            this.vars[v].unlink(this, v);
            this.vindices[v] = -1;
        }
    }

    void defineIn(Constraint c) throws SolverException {
        if (this.constraint != null && this.constraint.getStatus() != Constraint.Status.FREE || c.getStatus() != Constraint.Status.FREE) {
            throw new SolverException("This propagator is already defined in a constraint. This happens when a constraint is reified and posted.");
        }
        this.constraint = c;
    }

    public int getPropagationConditions(int vIdx) {
        return 255;
    }

    public abstract void propagate(int var1) throws ContradictionException;

    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        if (this.reactToFineEvt) {
            throw new SolverException(this + " has been declared to ignore which variable is modified.\nTo change the configuration, consider:\n- to set 'reactToFineEvt' to false or,\n- to override the following method:\n\t'public void propagate(int idxVarInProp, int mask) throws ContradictionException'.The latter enables incrementality but also to delay calls to complex filtering algorithm (see the method 'forcePropagate(EventType evt)'.");
        }
        this.propagate(PropagatorEventType.CUSTOM_PROPAGATION.getMask());
    }

    public final void forcePropagate(PropagatorEventType evt) throws ContradictionException {
        this.model.getSolver().getEngine().delayedPropagation(this, evt);
    }

    public void setActive() throws SolverException {
        if (this.isStateLess()) {
            this.state = (short)2;
            this.model.getEnvironment().save(this.operations[0]);
            assert (this.eventsets == null || this.eventsets.isEmpty());
        } else {
            throw new SolverException("Try to activate a propagator already active, passive or reified.\n" + this + " of " + this.getConstraint());
        }
    }

    public void setReifiedTrue() throws SolverException {
        if (!this.isReifiedAndSilent()) {
            throw new SolverException("Reification process tries to force activation of a propagator already active or passive.\n" + this + " of " + this.getConstraint());
        }
        this.state = (short)2;
        this.model.getEnvironment().save(this.operations[1]);
    }

    public void setReifiedSilent(BoolVar boolVar) throws SolverException {
        if (!this.isStateLess() && !this.isReifiedAndSilent()) {
            throw new SolverException("Reification process try to reify a propagator already active or posted.\n" + this + " of " + this.getConstraint());
        }
        this.state = 1;
        this.reifVar = boolVar;
    }

    public void setPassive() throws SolverException {
        if (this.isActive()) {
            this.state = (short)3;
            this.model.getEnvironment().save(this.operations[2]);
            this.model.getSolver().getEngine().deactivatePropagator(this);
            if (this.swapOnPassivate) {
                for (int i = 0; i < this.vars.length; ++i) {
                    if (this.vars[i].isInstantiated()) continue;
                    this.vars[i].swapOnPassivate(this, i);
                }
            }
        } else {
            throw new SolverException("Try to passivate a propagator already passive or reified.\n" + this + " of " + this.getConstraint());
        }
    }

    protected void forcePropagationOnBacktrack() {
        if (this.isStateLess()) {
            return;
        }
        if (this.isPassive()) {
            if (this instanceof UpdatablePropagator) {
                this.state = (short)2;
            } else {
                throw new SolverException("Try to force propagation on an inactive propagator.\n" + this + " of " + this.getConstraint());
            }
        }
        this.model.getSolver().getEngine().propagateOnBacktrack(this);
    }

    public abstract ESat isEntailed();

    public boolean isCompletelyInstantiated() {
        for (int i = 0; i < this.vars.length; ++i) {
            if (this.vars[i].isInstantiated()) continue;
            return false;
        }
        return true;
    }

    public int arity() {
        int arity = 0;
        for (int i = 0; i < this.vars.length; ++i) {
            arity += this.vars[i].isInstantiated() ? 0 : 1;
        }
        return arity;
    }

    public int dynPriority() {
        int arity = 0;
        for (int i = 0; i < this.vars.length && arity <= 3; arity += this.vars[i].isInstantiated() ? 0 : 1, ++i) {
        }
        if (arity > 3) {
            return this.priority.getValue();
        }
        return arity;
    }

    public void fails() throws ContradictionException {
        this.fails(this.defaultReason(null));
    }

    public void fails(Reason reason) throws ContradictionException {
        this.model.getSolver().throwsException(this, null, null, reason);
    }

    @Override
    public int compareTo(Propagator<V> o) {
        return this.ID - o.ID;
    }

    public boolean isReified() {
        return this.reifVar != null;
    }

    @Override
    public Function<Reason, Reason> manageReification() {
        if (this.isReified() && this.reifVar.isInstantiated()) {
            return r -> Reason.gather(r, this.reifVar.isInstantiated() ? this.reifVar.getValLit() : 1);
        }
        return ICause.super.manageReification();
    }

    public final boolean lcg() {
        return this.getModel().getSolver().isLCG();
    }

    @Override
    public int getId() {
        return this.ID;
    }

    public Model getModel() {
        return this.model;
    }

    public int hashCode() {
        return this.ID;
    }

    public boolean equals(Object o) {
        return o instanceof Propagator && ((Propagator)o).ID == this.ID;
    }

    public final V getVar(int i) {
        return this.vars[i];
    }

    public final V[] getVars() {
        return this.vars;
    }

    public int[] getVIndices() {
        return this.vindices;
    }

    public int getVIndice(int idx) {
        return this.vindices[idx];
    }

    public void setVIndices(int idx, int val) {
        this.vindices[idx] = val;
    }

    public final int getNbVars() {
        return this.vars.length;
    }

    public final Constraint getConstraint() {
        return this.constraint;
    }

    public final Priority getPriority() {
        return this.priority;
    }

    public boolean isStateLess() {
        return this.state == 0;
    }

    public boolean isReifiedAndSilent() {
        return this.state == 1;
    }

    public boolean isActive() {
        return this.state == 2 && this.enabled;
    }

    public boolean isPassive() {
        return this.state == 3;
    }

    public final boolean reactToFineEvent() {
        return this.reactToFineEvt;
    }

    public String toString() {
        StringBuilder st = new StringBuilder();
        st.append(this.getClass().getSimpleName()).append("(");
        int i = 0;
        if (this.vars.length >= 3) {
            st.append(this.vars[i++].getName()).append(", ");
        }
        if (this.vars.length >= 2) {
            st.append(this.vars[i++].getName()).append(", ");
        }
        if (this.vars.length >= 1) {
            st.append(this.vars[i++].getName());
        }
        if (i < this.vars.length) {
            if (this.vars.length > 4) {
                st.append(", ...");
            }
            st.append(", ").append(this.vars[this.vars.length - 1].getName());
        }
        st.append(')');
        return st.toString();
    }

    @Override
    public void forEachIntVar(Consumer<IntVar> action) {
        for (int i = 0; i < this.vars.length; ++i) {
            action.accept((IntVar)this.vars[i]);
        }
    }

    @Override
    public Reason defaultReason(Variable pivot) {
        if (this.lcg()) {
            return Propagator.reason(pivot, this.vars);
        }
        return Reason.undef();
    }

    public static Reason reason(Variable pivot, Variable ... variables) {
        assert (variables.length > 0) : "A propagator should have at least one variable";
        assert (variables[0].getModel().getSolver().isLCG()) : "This method should not be called if the LCG is not enabled";
        TIntArrayList ps = new TIntArrayList();
        ps.add(0);
        for (int i = 0; i < variables.length; ++i) {
            IntVar var = (IntVar)variables[i];
            if (var == pivot) continue;
            if (var.isInstantiated()) {
                ps.add(var.getValLit());
                continue;
            }
            ps.add(var.getMinLit());
            ps.add(var.getMaxLit());
            int j = var.nextValueOut(var.getLB());
            int to = var.previousValueOut(var.getUB());
            while (j <= to) {
                ps.add(var.getLit(j, 1));
                j = var.nextValueOut(j);
            }
        }
        return Reason.r(ps.toArray());
    }

    public static Reason bounds(Variable pivot, Variable ... variables) {
        assert (variables.length > 0) : "A propagator should have at least one variable";
        assert (variables[0].getModel().getSolver().isLCG()) : "This method should not be called if the LCG is not enabled";
        TIntArrayList ps = new TIntArrayList();
        ps.add(0);
        for (int i = 0; i < variables.length; ++i) {
            IntVar var = (IntVar)variables[i];
            if (var == pivot) continue;
            ps.add(var.getMinLit());
            ps.add(var.getMaxLit());
        }
        return Reason.r(ps.toArray());
    }

    public static Reason lbounds(Variable pivot, Variable ... variables) {
        assert (variables.length > 0) : "A propagator should have at least one variable";
        assert (variables[0].getModel().getSolver().isLCG()) : "This method should not be called if the LCG is not enabled";
        TIntArrayList ps = new TIntArrayList();
        ps.add(0);
        for (int i = 0; i < variables.length; ++i) {
            IntVar var = (IntVar)variables[i];
            if (var == pivot) continue;
            ps.add(var.getMinLit());
        }
        return Reason.r(ps.toArray());
    }

    public static Reason ubounds(Variable pivot, Variable ... variables) {
        assert (variables.length > 0) : "A propagator should have at least one variable";
        assert (variables[0].getModel().getSolver().isLCG()) : "This method should not be called if the LCG is not enabled";
        TIntArrayList ps = new TIntArrayList();
        ps.add(0);
        for (int i = 0; i < variables.length; ++i) {
            IntVar var = (IntVar)variables[i];
            if (var == pivot) continue;
            ps.add(var.getMaxLit());
        }
        return Reason.r(ps.toArray());
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int p) {
        this.position = p;
    }

    public final void unschedule() {
        this.scheduled = false;
    }

    private void schedule() {
        this.scheduled = true;
    }

    public int doSchedule(CircularQueue<Propagator<?>>[] queues) {
        int prio = this.priority.getValue();
        if (!this.scheduled) {
            queues[prio].addLast(this);
            this.schedule();
        }
        return prio;
    }

    public void doScheduleEvent(int pindice, int mask) {
        this.fineevt.accept(pindice, mask);
    }

    public void doFinePropagation() throws ContradictionException {
        while (!this.eventsets.isEmpty()) {
            int v = this.eventsets.pollFirst();
            assert (this.isActive()) : "propagator is not active:" + this.getClass();
            int mask = this.eventmasks[v];
            this.eventmasks[v] = 0;
            this.propagate(v, mask);
        }
    }

    public void doFlush() {
        if (this.reactToFineEvent()) {
            while (!this.eventsets.isEmpty()) {
                int v = this.eventsets.pollLast();
                this.eventmasks[v] = 0;
            }
        }
        this.unschedule();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    private static interface IntIntConsumer {
        public void accept(int var1, int var2);
    }
}

