/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.memory.trailing.trail.chunck;

import org.chocosolver.memory.trailing.StoredBool;
import org.chocosolver.memory.trailing.trail.IStoredBoolTrail;
import org.chocosolver.memory.trailing.trail.chunck.BoolWorld;
import org.chocosolver.memory.trailing.trail.chunck.ChunckedTrail;

public class ChunckedBoolTrail
extends ChunckedTrail<BoolWorld>
implements IStoredBoolTrail {
    private final int ws;
    private final double loadfactor;

    public ChunckedBoolTrail(int ws, int nbWorlds, double loadfactor) {
        this.worlds = new BoolWorld[nbWorlds];
        this.ws = ws;
        this.loadfactor = loadfactor;
        this.current = new BoolWorld(ws, loadfactor);
        ((BoolWorld[])this.worlds)[0] = this.current;
    }

    @Override
    public void worldPush(int worldIndex) {
        if (((BoolWorld[])this.worlds)[worldIndex] == null) {
            this.current = new BoolWorld(this.ws, this.loadfactor);
            ((BoolWorld[])this.worlds)[worldIndex] = (BoolWorld)this.current;
        } else {
            this.current = ((BoolWorld[])this.worlds)[worldIndex];
            ((BoolWorld)this.current).clear();
        }
        if (worldIndex == ((BoolWorld[])this.worlds).length - 1) {
            this.resizeWorlds();
        }
    }

    private void resizeWorlds() {
        int newCapacity = (int)((double)((BoolWorld[])this.worlds).length * this.loadfactor);
        BoolWorld[] tmp = new BoolWorld[newCapacity];
        System.arraycopy(this.worlds, 0, tmp, 0, ((BoolWorld[])this.worlds).length);
        this.worlds = tmp;
    }

    @Override
    public void savePreviousState(StoredBool v, boolean oldValue, int oldStamp) {
        ((BoolWorld)this.current).savePreviousState(v, oldValue, oldStamp);
    }
}

