
test_that("fetch_ggproto returns correct value when found", {
  mock_x <- list(name = "value", super = NULL)
  mock_subset2 <- mockery::mock("value")
  mockery::stub(fetch_ggproto, ".subset2", mock_subset2)

  result <- fetch_ggproto(mock_x, "name")
  expect_equal(result, "value")
})

test_that("$.ggproto returns correct value", {
  mock_x <- list(name = "value", super = NULL)
  mock_fetch_ggproto <- mockery::mock("value")
  mockery::stub(`$.ggproto`, "fetch_ggproto", mock_fetch_ggproto)

  result <- `$.ggproto`(mock_x, "name")
  expect_equal(result, "value")
})

test_that("$.ggproto returns function wrapped with make_proto_method", {
  mock_x <- list(name = function() "value", super = NULL)
  mock_fetch_ggproto <- mockery::mock(function() "value")
  mockery::stub(`$.ggproto`, "fetch_ggproto", mock_fetch_ggproto)
  mock_make_proto_method <- mockery::mock(function() "wrapped_value")
  mockery::stub(`$.ggproto`, "make_proto_method", mock_make_proto_method)

  result <- `$.ggproto`(mock_x, "name")
  expect_equal(result(), "value")
})
