/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.arima;

import jdplus.toolkit.base.core.arima.ArimaException;
import jdplus.toolkit.base.core.arima.AutoCovarianceFunction;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.arima.Spectrum;
import jdplus.toolkit.base.core.math.linearfilters.IRationalFilter;
import jdplus.toolkit.base.core.math.linearfilters.RationalBackFilter;
import jdplus.toolkit.base.core.math.linearfilters.SymmetricFilter;

public abstract class AbstractArimaModel
implements IArimaModel {
    private volatile RationalBackFilter pi;
    private volatile RationalBackFilter psi;
    private volatile Spectrum spectrum;
    private volatile AutoCovarianceFunction acf;

    protected SymmetricFilter symmetricMa() {
        return SymmetricFilter.convolutionOf(this.getMa(), this.getInnovationVariance());
    }

    protected SymmetricFilter symmetricAr() {
        return SymmetricFilter.convolutionOf(this.getAr());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Spectrum getSpectrum() {
        Spectrum s = this.spectrum;
        if (s == null) {
            AbstractArimaModel abstractArimaModel = this;
            synchronized (abstractArimaModel) {
                s = this.spectrum;
                if (s == null) {
                    this.spectrum = s = new Spectrum(this.symmetricMa(), this.symmetricAr());
                }
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AutoCovarianceFunction getAutoCovarianceFunction() {
        if (!this.isStationary()) {
            throw new ArimaException("acgf of non stationary model");
        }
        AutoCovarianceFunction fn = this.acf;
        if (fn == null) {
            AbstractArimaModel abstractArimaModel = this;
            synchronized (abstractArimaModel) {
                fn = this.acf;
                if (fn == null) {
                    this.acf = fn = new AutoCovarianceFunction(this.getMa().asPolynomial(), this.getStationaryAr().asPolynomial(), this.getInnovationVariance());
                }
            }
        }
        return fn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RationalBackFilter getPiWeights() {
        RationalBackFilter filter = this.pi;
        if (filter == null) {
            AbstractArimaModel abstractArimaModel = this;
            synchronized (abstractArimaModel) {
                filter = this.pi;
                if (filter == null) {
                    this.pi = filter = new RationalBackFilter(this.getAr(), this.getMa(), 0);
                }
            }
        }
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RationalBackFilter getPsiWeights() {
        RationalBackFilter filter = this.psi;
        if (filter == null) {
            AbstractArimaModel abstractArimaModel = this;
            synchronized (abstractArimaModel) {
                filter = this.psi;
                if (filter == null) {
                    this.psi = filter = new RationalBackFilter(this.getMa(), this.getAr(), 0);
                }
            }
        }
        return filter;
    }

    @Override
    public IRationalFilter getFilter() throws ArimaException {
        return this.getPsiWeights();
    }

    @Override
    public boolean isStationary() {
        return this.getNonStationaryArOrder() == 0;
    }

    public String toString() {
        try {
            StringBuilder builder = new StringBuilder();
            builder.append("AR = ").append(this.getAr().toString()).append("; ");
            builder.append("MA = ").append(this.getMa().toString()).append("; ");
            builder.append("var =").append(this.getInnovationVariance());
            return builder.toString();
        }
        catch (ArimaException ex) {
            return "Invalid model";
        }
    }
}

