/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.linearfilters;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.core.math.linearfilters.Filtering;
import jdplus.toolkit.base.core.math.linearfilters.IFiniteFilter;
import jdplus.toolkit.base.core.math.linearfilters.IQuasiSymmetricFiltering;
import jdplus.toolkit.base.core.math.linearfilters.SymmetricFilter;

public class QuasiSymmetricFiltering
implements IQuasiSymmetricFiltering {
    private final SymmetricFilter cf;
    private final IFiniteFilter[] lf;
    private final IFiniteFilter[] rf;

    public QuasiSymmetricFiltering(SymmetricFilter cf, IFiniteFilter[] lf, IFiniteFilter[] rf) {
        this.cf = cf;
        this.lf = (IFiniteFilter[])lf.clone();
        this.rf = (IFiniteFilter[])rf.clone();
    }

    @Override
    public SymmetricFilter centralFilter() {
        return this.cf;
    }

    @Override
    public IFiniteFilter[] leftEndPointsFilters() {
        return (IFiniteFilter[])this.lf.clone();
    }

    @Override
    public IFiniteFilter[] rightEndPointsFilters() {
        return (IFiniteFilter[])this.rf.clone();
    }

    public static QuasiSymmetricFiltering of(DoubleSeq cf, Matrix lf, Matrix rf) {
        int l = rf.getColumnsCount();
        if (cf.length() != 2 * l + 1) {
            throw new IllegalArgumentException();
        }
        SymmetricFilter fcf = SymmetricFilter.of(cf);
        IFiniteFilter[] flf = Filtering.leftFilters(lf);
        IFiniteFilter[] frf = Filtering.rightFilters(rf);
        return new QuasiSymmetricFiltering(fcf, flf, frf);
    }
}

