/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.api.x13;

import jdplus.sa.base.api.DecompositionMode;
import jdplus.sa.base.api.SaSpecification;
import jdplus.sa.base.api.benchmarking.SaBenchmarkingSpec;
import jdplus.toolkit.base.api.processing.AlgorithmDescriptor;
import jdplus.toolkit.base.api.util.Validatable;
import jdplus.x13.base.api.regarima.RegArimaSpec;
import jdplus.x13.base.api.x11.X11Spec;
import jdplus.x13.base.api.x13.X13Exception;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class X13Spec
implements Validatable<X13Spec>,
SaSpecification {
    public static final String METHOD = "x13";
    public static final String VERSION = "0.1.0.0";
    public static final String VERSION_V3 = "3.0.0";
    public static final AlgorithmDescriptor DESCRIPTOR_LEGACY = new AlgorithmDescriptor("Seasonal adjustment", "x13", "0.1.0.0");
    public static final AlgorithmDescriptor DESCRIPTOR_V3 = new AlgorithmDescriptor("Seasonal adjustment", "x13", "3.0.0");
    private static final X13Spec DEFAULT = (X13Spec)X13Spec.builder().build();
    @NonNull
    private final RegArimaSpec regArima;
    @NonNull
    private final X11Spec x11;
    @NonNull
    private final SaBenchmarkingSpec benchmarking;
    public static final X13Spec RSAX11 = (X13Spec)X13Spec.builder().regArima(RegArimaSpec.RGDISABLED).x11((X11Spec)X11Spec.builder().mode(DecompositionMode.Multiplicative).forecastHorizon(0).build()).build();
    public static final X13Spec RSA0 = (X13Spec)X13Spec.builder().regArima(RegArimaSpec.RG0).x11(X11Spec.DEFAULT_UNDEFINED).build();
    public static final X13Spec RSA1 = (X13Spec)X13Spec.builder().regArima(RegArimaSpec.RG1).x11(X11Spec.DEFAULT_UNDEFINED).build();
    public static final X13Spec RSA2 = (X13Spec)X13Spec.builder().regArima(RegArimaSpec.RG2).x11(X11Spec.DEFAULT_UNDEFINED).build();
    public static final X13Spec RSA3 = (X13Spec)X13Spec.builder().regArima(RegArimaSpec.RG3).x11(X11Spec.DEFAULT_UNDEFINED).build();
    public static final X13Spec RSA4 = (X13Spec)X13Spec.builder().regArima(RegArimaSpec.RG4).x11(X11Spec.DEFAULT_UNDEFINED).build();
    public static final X13Spec RSA5 = (X13Spec)X13Spec.builder().regArima(RegArimaSpec.RG5).x11(X11Spec.DEFAULT_UNDEFINED).build();
    private static final String SMETHOD = "X13";

    public AlgorithmDescriptor getAlgorithmDescriptor() {
        return DESCRIPTOR_V3;
    }

    public static Builder builder() {
        return new Builder().regArima(RegArimaSpec.DEFAULT_ENABLED).x11(X11Spec.DEFAULT_UNDEFINED).benchmarking(SaBenchmarkingSpec.DEFAULT_DISABLED);
    }

    public boolean isDefault() {
        return this.equals(DEFAULT);
    }

    public X13Spec validate() throws IllegalArgumentException {
        this.regArima.validate();
        this.x11.validate();
        this.benchmarking.validate();
        return this;
    }

    public static final X13Spec[] allSpecifications() {
        return new X13Spec[]{RSAX11, RSA0, RSA1, RSA2, RSA3, RSA4, RSA5};
    }

    public static X13Spec fromString(String name) {
        if (name.equalsIgnoreCase("X11") || name.equalsIgnoreCase("X11")) {
            return RSAX11;
        }
        if (name.equalsIgnoreCase("RSA0") || name.equalsIgnoreCase("RSA0")) {
            return RSA0;
        }
        if (name.equalsIgnoreCase("RSA1") || name.equalsIgnoreCase("RSA1")) {
            return RSA1;
        }
        if (name.equalsIgnoreCase("RSA2c") || name.equalsIgnoreCase("RSA2")) {
            return RSA2;
        }
        if (name.equalsIgnoreCase("RSA3") || name.equalsIgnoreCase("RSA3")) {
            return RSA3;
        }
        if (name.equalsIgnoreCase("RSA4c") || name.equalsIgnoreCase("RSA4")) {
            return RSA4;
        }
        if (name.equalsIgnoreCase("RSA5c") || name.equalsIgnoreCase("RSA5")) {
            return RSA5;
        }
        throw new X13Exception();
    }

    public String display() {
        if (this == RSAX11) {
            return "X11";
        }
        if (this == RSA0) {
            return "RSA0";
        }
        if (this == RSA1) {
            return "RSA1";
        }
        if (this == RSA2) {
            return "RSA2";
        }
        if (this == RSA3) {
            return "RSA3";
        }
        if (this == RSA4) {
            return "RSA4";
        }
        if (this == RSA5) {
            return "RSA5";
        }
        if (this.equals(RSA0)) {
            return "RSA0";
        }
        if (this.equals(RSA1)) {
            return "RSA1";
        }
        if (this.equals(RSA2)) {
            return "RSA2";
        }
        if (this.equals(RSA3)) {
            return "RSA3";
        }
        if (this.equals(RSA4)) {
            return "RSA4";
        }
        if (this.equals(RSA5)) {
            return "RSA5";
        }
        return SMETHOD;
    }

    @Generated
    X13Spec(@NonNull RegArimaSpec regArima, @NonNull X11Spec x11, @NonNull SaBenchmarkingSpec benchmarking) {
        if (regArima == null) {
            throw new NullPointerException("regArima is marked non-null but is null");
        }
        if (x11 == null) {
            throw new NullPointerException("x11 is marked non-null but is null");
        }
        if (benchmarking == null) {
            throw new NullPointerException("benchmarking is marked non-null but is null");
        }
        this.regArima = regArima;
        this.x11 = x11;
        this.benchmarking = benchmarking;
    }

    @Generated
    public @org.jspecify.annotations.NonNull Builder toBuilder() {
        return new Builder().regArima(this.regArima).x11(this.x11).benchmarking(this.benchmarking);
    }

    @NonNull
    @Generated
    public RegArimaSpec getRegArima() {
        return this.regArima;
    }

    @NonNull
    @Generated
    public X11Spec getX11() {
        return this.x11;
    }

    @NonNull
    @Generated
    public SaBenchmarkingSpec getBenchmarking() {
        return this.benchmarking;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof X13Spec)) {
            return false;
        }
        X13Spec other = (X13Spec)o;
        RegArimaSpec this$regArima = this.getRegArima();
        RegArimaSpec other$regArima = other.getRegArima();
        if (this$regArima == null ? other$regArima != null : !((Object)this$regArima).equals(other$regArima)) {
            return false;
        }
        X11Spec this$x11 = this.getX11();
        X11Spec other$x11 = other.getX11();
        if (this$x11 == null ? other$x11 != null : !((Object)this$x11).equals(other$x11)) {
            return false;
        }
        SaBenchmarkingSpec this$benchmarking = this.getBenchmarking();
        SaBenchmarkingSpec other$benchmarking = other.getBenchmarking();
        return !(this$benchmarking == null ? other$benchmarking != null : !this$benchmarking.equals(other$benchmarking));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RegArimaSpec $regArima = this.getRegArima();
        result = result * 59 + ($regArima == null ? 43 : ((Object)$regArima).hashCode());
        X11Spec $x11 = this.getX11();
        result = result * 59 + ($x11 == null ? 43 : ((Object)$x11).hashCode());
        SaBenchmarkingSpec $benchmarking = this.getBenchmarking();
        result = result * 59 + ($benchmarking == null ? 43 : $benchmarking.hashCode());
        return result;
    }

    @Generated
    public @org.jspecify.annotations.NonNull String toString() {
        return "X13Spec(regArima=" + String.valueOf(this.getRegArima()) + ", x11=" + String.valueOf(this.getX11()) + ", benchmarking=" + String.valueOf(this.getBenchmarking()) + ")";
    }

    public static class Builder
    implements Validatable.Builder<X13Spec> {
        @Generated
        private RegArimaSpec regArima;
        @Generated
        private X11Spec x11;
        @Generated
        private SaBenchmarkingSpec benchmarking;

        @Generated
        Builder() {
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder regArima(@NonNull RegArimaSpec regArima) {
            if (regArima == null) {
                throw new NullPointerException("regArima is marked non-null but is null");
            }
            this.regArima = regArima;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder x11(@NonNull X11Spec x11) {
            if (x11 == null) {
                throw new NullPointerException("x11 is marked non-null but is null");
            }
            this.x11 = x11;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder benchmarking(@NonNull SaBenchmarkingSpec benchmarking) {
            if (benchmarking == null) {
                throw new NullPointerException("benchmarking is marked non-null but is null");
            }
            this.benchmarking = benchmarking;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull X13Spec buildWithoutValidation() {
            return new X13Spec(this.regArima, this.x11, this.benchmarking);
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "X13Spec.Builder(regArima=" + String.valueOf(this.regArima) + ", x11=" + String.valueOf(this.x11) + ", benchmarking=" + String.valueOf(this.benchmarking) + ")";
        }
    }
}

