/*
 * Decompiled with CFR 0.152.
 */
package dmLab.utils.statFunctions;

import dmLab.utils.MathUtils;
import jdistlib.T;
import jdistlib.disttest.DistributionTest;
import jdistlib.disttest.NormalityTest;
import jdistlib.disttest.TestKind;

public final class StatFunctions {
    /*
     * WARNING - void declaration
     */
    public static double[] getConfidenceInterval(double alpha, double[] x) {
        void var3_3;
        double t;
        void var2_2;
        int size = x.length;
        double stdev = MathUtils.stdev(x);
        double avg = MathUtils.mean((double[])var2_2);
        try {
            t = T.quantile((double)(1.0 - alpha / 2.0), (double)(size - 1), (boolean)true, (boolean)false);
        }
        catch (Exception exception) {
            double d;
            System.out.println("T-Student Inverse Error:");
            System.out.println("alpha: " + d + " size: " + (size - 1));
            return null;
        }
        double conf1 = avg - t * stdev / Math.sqrt(size);
        double conf2 = avg + t * stdev / Math.sqrt((double)var3_3);
        double[] dArray = new double[]{conf1, conf2};
        return dArray;
    }

    /*
     * WARNING - void declaration
     */
    public static double tTestOneSample(double[] x, double mu) {
        void var1_1;
        double[] dArray = DistributionTest.t_test((double[])x, (double)var1_1, (TestKind)TestKind.TWO_SIDED);
        return dArray[1];
    }

    public static double andersonDarlingNormTest(double[] x) {
        double[] dArray;
        double d = NormalityTest.anderson_darling_statistic((double[])x);
        double d2 = NormalityTest.anderson_darling_pvalue((double)d, (int)dArray.length);
        return d2;
    }

    /*
     * WARNING - void declaration
     */
    public static float pearson(double[] x, double[] y) {
        void var2_8;
        if (x.length != y.length) {
            return Float.NaN;
        }
        double avg_x = MathUtils.mean(x);
        double avg_y = MathUtils.mean(y);
        double numerator = 0.0;
        double denominator_x = 0.0;
        double denominator_y = 0.0;
        for (int i = 0; i < x.length; ++i) {
            numerator += (x[i] - avg_x) * (y[i] - avg_y);
            denominator_x += Math.pow(x[i] - avg_x, 2.0);
            denominator_y += Math.pow(y[i] - avg_y, 2.0);
        }
        double pearson = numerator / (Math.sqrt(denominator_x) * Math.sqrt(denominator_y));
        if (Double.isNaN(pearson)) {
            pearson = 0.0;
        }
        return (float)var2_8;
    }

    public static float mae(double[] x, double[] y) {
        double[] dArray;
        if (x.length != y.length) {
            return Float.NaN;
        }
        double mae = 0.0;
        for (int i = 0; i < x.length; ++i) {
            mae += Math.abs(x[i] - y[i]);
        }
        return (float)(var2_2 /= (double)dArray.length);
    }

    public static float rmse(double[] x, double[] y) {
        double[] dArray;
        double d;
        if (x.length != y.length) {
            return Float.NaN;
        }
        double rmse = 0.0;
        for (int i = 0; i < x.length; ++i) {
            rmse += Math.pow(x[i] - y[i], 2.0);
        }
        d = Math.sqrt((double)(d / (double)dArray.length));
        return (float)d;
    }

    public static float smape(double[] x, double[] y) {
        double[] dArray;
        if (x.length != y.length) {
            return Float.NaN;
        }
        double smape = 0.0;
        for (int i = 0; i < x.length; ++i) {
            smape += Math.abs(x[i] - y[i]) / (Math.abs(x[i]) + Math.abs(y[i]));
        }
        return (float)(var2_2 /= (double)dArray.length);
    }
}

