/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.rules.driftdetection;

import java.io.Serializable;

public class PageHinkleyTest
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected double cumulativeSum;
    protected double minimumValue;
    protected double sumAbsolutError;
    protected long phinstancesSeen;
    protected double threshold;
    protected double alpha;

    public double getCumulativeSum() {
        return this.cumulativeSum;
    }

    public double getMinimumValue() {
        return this.minimumValue;
    }

    public PageHinkleyTest(double threshold, double alpha) {
        this.threshold = threshold;
        this.alpha = alpha;
        this.reset();
    }

    public void reset() {
        this.cumulativeSum = 0.0;
        this.minimumValue = Double.MAX_VALUE;
        this.sumAbsolutError = 0.0;
        this.phinstancesSeen = 0L;
    }

    public boolean update(double error) {
        ++this.phinstancesSeen;
        double absolutError = Math.abs(error);
        this.sumAbsolutError += absolutError;
        if (this.phinstancesSeen > 30L) {
            double mT = absolutError - this.sumAbsolutError / (double)this.phinstancesSeen - this.alpha;
            this.cumulativeSum += mT;
            if (this.cumulativeSum < this.minimumValue) {
                this.minimumValue = this.cumulativeSum;
            }
            return this.cumulativeSum - this.minimumValue > this.threshold;
        }
        return false;
    }
}

