/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood;

import java.io.Serializable;
import java.util.Arrays;

public class BufferIndexHelper
implements Serializable {
    private final int minIndexValue;
    private final int constantOffset;
    private final int doubleBufferCount;
    private final boolean[] indexOffsetsFlipped;
    private int[] indexOffsets;
    private int[] storedIndexOffsets;

    public BufferIndexHelper(int n, int n2) {
        this(n, n2, 0);
    }

    public BufferIndexHelper(int n, int n2, int n3) {
        this.minIndexValue = n2;
        this.doubleBufferCount = n - n2;
        this.indexOffsets = new int[this.doubleBufferCount];
        this.storedIndexOffsets = new int[this.doubleBufferCount];
        this.indexOffsetsFlipped = new boolean[this.doubleBufferCount];
        this.constantOffset = this.computeOffset(n3);
    }

    protected int computeOffset(int n) {
        return n * this.getBufferCount();
    }

    public int getBufferCount() {
        return 2 * this.doubleBufferCount + this.minIndexValue;
    }

    public void flipOffset(int n) {
        assert (n >= this.minIndexValue) : "shouldn't be trying to flip the first 'static' indices";
        if (!this.indexOffsetsFlipped[n - this.minIndexValue]) {
            this.indexOffsets[n - this.minIndexValue] = this.doubleBufferCount - this.indexOffsets[n - this.minIndexValue];
            this.indexOffsetsFlipped[n - this.minIndexValue] = true;
        }
    }

    public int getOffsetIndex(int n) {
        if (n < this.minIndexValue) {
            return n + this.constantOffset;
        }
        return this.indexOffsets[n - this.minIndexValue] + n + this.constantOffset;
    }

    private int getStoredOffsetIndex(int n) {
        assert (n >= this.minIndexValue);
        return this.storedIndexOffsets[n - this.minIndexValue] + n + this.constantOffset;
    }

    public boolean isSafeUpdate(int n) {
        return this.getStoredOffsetIndex(n) != this.getOffsetIndex(n);
    }

    public void storeState() {
        Arrays.fill(this.indexOffsetsFlipped, false);
        System.arraycopy(this.indexOffsets, 0, this.storedIndexOffsets, 0, this.indexOffsets.length);
    }

    public void restoreState() {
        int[] nArray = this.storedIndexOffsets;
        this.storedIndexOffsets = this.indexOffsets;
        this.indexOffsets = nArray;
        Arrays.fill(this.indexOffsetsFlipped, false);
    }
}

