# Contributing to HistData

<!-- This CONTRIBUTING.md is adapted from https://gist.github.com/peterdesmet/e90a1b0dc17af6c12daf6e8b2f044e7c -->

First of all, thanks for considering contributing to HistData! 👍 It's people like you that make it rewarding for us - the project maintainers - to work on HistData. 😊

HistData is an open source project.

* **repo**: https://github.com/friendly/HistData
* **issues**: https://github.com/friendly/HistData/issues
* **new_issue**: https://github.com/friendly/HistData/issues/new
* **website**: https://friendly.github.io/HistData 
* **citation**: https://friendly.github.io/HistData/authors.html
* **email**: mailto:friendly@yorku.ca

## Code of Conduct

Please note that the HistData project is released with a [Contributor Code of Conduct](https://friendly.github.io/HistData/CODE_OF_CONDUCT.html). By contributing to this project, you agree to abide by its terms.

## How you can contribute

There are several ways you can contribute to this project. If you want to know more about why and how to contribute to open source projects like this one, see this [Open Source Guide](https://opensource.guide/how-to-contribute/).

### Share the love ❤️

Think HistData is useful? Let others discover it, by telling them in person, via Twitter or a blog post.

Using HistData for a paper you are writing? Consider [citing it](https://friendly.github.io/HistData/authors.html).

### Ask a question ⁉️

Using HistData and got stuck? Browse the [documentation](https://friendly.github.io/HistData) to see if you can find a solution. Still stuck? Post your question as an [issue on GitHub](https://github.com/friendly/HistData/issues/new). While we cannot offer user support, we'll try to do our best to address it, as questions often lead to better documentation or the discovery of bugs.

Want to ask a question in private? Contact the package maintainer by [email](mailto:friendly@yorku.ca).

### Propose an idea 💡

Have an idea for a new HistData feature? Take a look at the [documentation](https://friendly.github.io/HistData) and [issue list](https://github.com/friendly/HistData/issues) to see if it isn't included or suggested yet. If not, suggest your idea as an [issue on GitHub](https://github.com/friendly/HistData/issues/new). While we can't promise to implement your idea, it helps to:

* Explain in detail how it would work.
* Keep the scope as narrow as possible.

See below if you want to contribute code for your idea as well.

### Improve the documentation 📖

Noticed a typo on the website? Think a data set could use a better or additional example? Good documentation makes all the difference, so your help to improve it is very welcome!

#### The website

[This website](https://friendly.github.io/HistData) is generated with [`pkgdown`](http://pkgdown.r-lib.org/). That means we don't have to write any html: content is pulled together from documentation in the code, vignettes, [Markdown](https://guides.github.com/features/mastering-markdown/) files, the package `DESCRIPTION` and `_pkgdown.yml` settings. If you know your way around `pkgdown`, you can [propose a file change](https://help.github.com/articles/editing-files-in-another-user-s-repository/) to improve documentation. If not, [report an issue](https://github.com/friendly/HistData/issues/new) and we can point you in the right direction.

### Contribute a new data set 

If you have an interesting historical data set you think should be added to the package,
first suggest it as an [issue on GitHub](https://github.com/friendly/HistData/issues/new).
To be acceptable for the package, your contribution should consist of:

1. The data set, as an `.RData` or `.rda` file, as generated by `save(mydata, file="mydata.RData")`. Please make sure that the data set is **tidy**, and that variable types are appropriate for analysis and plotting. This will go into the `data/` directory of the package.

2. Optionally, you can also submit a new data set as a `mydata.csv` file, together with the script, `mydata.R` used to create the data.frame.  These will go into the `data-raw/` directory.

3. Documentation for the data set, in the form of an `.Rd` file, such as generated by `promptData(mydata, filename = "mydata.Rd")`.  You will need to edit this file to fill in the `\title{}`, `\description{}`, `\references{}`, `\source{}` fields, as well as sufficient `\examples{}` to illustrate something about the data and/or its context in history. 

4. Optionally, you can document your data set in a `mydata.R` file in [`roxygen2`](https://klutometis.github.io/roxygen/) format. This will go into the `R/` directory and be converted to `.Rd` format.


## Development guidelines

We try to follow the [GitHub flow](https://guides.github.com/introduction/flow/) for development.

1. Fork [this repo](https://github.com/friendly/HistData) and clone it to your computer. To learn more about this process, see [this guide](https://guides.github.com/activities/forking/).
2. If you have forked and cloned the project before and it has been a while since you worked on it, [pull changes from the original repo](https://help.github.com/articles/merging-an-upstream-repository-into-your-fork/) to your clone by using `git pull upstream master`.
3. Open the RStudio project file (`.Rproj`).
4. Make your changes:
    * Write your code.
    * Test your code (bonus points for adding unit tests).
    * Document your code (see function documentation above).
    * Check your code with `devtools::check()` and aim for 0 errors and warnings.
5. Commit and push your changes.
6. Submit a [pull request](https://guides.github.com/activities/forking/#making-a-pull-request).
