/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Genotypes;

import java.util.Vector;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Genotypes.Genotype;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Node.Node;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Node.NodeAnd;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Node.NodeAssert;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Node.NodeConsequent;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Node.NodeIs;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Node.NodeLabel;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Node.NodeOr;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Node.NodeRule;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Node.NodeRuleBase;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Node.NodeVariable;
import keel.Algorithms.Fuzzy_Rule_Learning.Shared.Fuzzy.Fuzzy;
import keel.Algorithms.Fuzzy_Rule_Learning.Shared.Fuzzy.FuzzyPartition;
import keel.Algorithms.Shared.Exceptions.invalidCrossover;
import keel.Algorithms.Shared.Exceptions.invalidMutation;
import org.core.Randomize;

public class GenotypeFuzzyGAP
extends Genotype {
    static int MAXH;
    Node rootNode;
    Vector theNodes;
    Vector theParents;
    Vector theDepthAtEachNode;
    FuzzyPartition[] A;
    FuzzyPartition B;

    public GenotypeFuzzyGAP(FuzzyPartition[] a, FuzzyPartition b, int mh, Randomize r) {
        super(r);
        this.theNodes = new Vector();
        this.theParents = new Vector();
        this.theDepthAtEachNode = new Vector();
        this.rootNode = new NodeRuleBase(new NodeRule[0]);
        this.A = new FuzzyPartition[a.length];
        for (int i = 0; i < a.length; ++i) {
            this.A[i] = a[i].clone();
        }
        this.B = b.clone();
        MAXH = mh;
    }

    public GenotypeFuzzyGAP(GenotypeFuzzyGAP p) {
        super(rand);
        this.rootNode = p.rootNode.clone();
        this.A = new FuzzyPartition[p.A.length];
        for (int i = 0; i < p.A.length; ++i) {
            this.A[i] = p.A[i].clone();
        }
        this.B = p.B.clone();
        this.buildNodeLists();
    }

    public void set(GenotypeFuzzyGAP p) {
        this.rootNode = p.rootNode.clone();
        this.A = new FuzzyPartition[p.A.length];
        for (int i = 0; i < p.A.length; ++i) {
            this.A[i] = p.A[i].clone();
        }
        this.B = p.B.clone();
        this.buildNodeLists();
    }

    @Override
    public boolean isRelated(Genotype g) {
        GenotypeFuzzyGAP p = (GenotypeFuzzyGAP)g;
        return this.rootNode.compatible(p.rootNode);
    }

    @Override
    public Genotype clone() {
        return new GenotypeFuzzyGAP(this);
    }

    public void rebuild(Genotype g) {
    }

    @Override
    public void mutation(double alpha, int mutationID) throws invalidMutation {
        if (mutationID != 1003 && mutationID != 1004) {
            throw new invalidMutation();
        }
        GenotypeFuzzyGAP offspng1 = new GenotypeFuzzyGAP(this.A, this.B, MAXH, rand);
        GenotypeFuzzyGAP offspng2 = new GenotypeFuzzyGAP(this.A, this.B, MAXH, rand);
        GenotypeFuzzyGAP randomGenotype = new GenotypeFuzzyGAP(this.A, this.B, MAXH, rand);
        randomGenotype.Random();
        try {
            if (mutationID == 1003) {
                this.crossover(randomGenotype, offspng1, offspng2, 1001);
                this.set(offspng1);
            } else {
                this.crossover(randomGenotype, offspng1, offspng2, 1002);
                this.set(offspng1);
            }
        }
        catch (invalidCrossover c) {
            System.out.println("Internal error within the mutacion of a GenotypeFuzzyGAP");
        }
    }

    private void partBInternalCrossover(double[] cont3, double[] cont4) {
        int j;
        int j2;
        double[] ind3 = new double[cont3.length];
        double[] ind4 = new double[cont4.length];
        double min = cont3[0];
        double max = cont3[cont3.length - 1];
        double factor = max - min;
        for (j2 = 0; j2 < ind3.length; ++j2) {
            ind3[j2] = (cont3[j2] - min) / factor;
        }
        for (j2 = 0; j2 < ind4.length; ++j2) {
            ind4[j2] = (cont4[j2] - min) / factor;
        }
        double alpha = (rand.Rand() - 0.5) * 0.25;
        for (j = 0; j < ind3.length; ++j) {
            double val1 = ind3[j] + alpha * (ind4[j] - ind3[j]);
            double val2 = ind4[j] + alpha * (ind3[j] - ind4[j]);
            ind3[j] = val1;
            ind4[j] = val2;
        }
        for (j = 0; j < ind3.length - 1; ++j) {
            if (!(ind3[j + 1] - ind3[j] < 0.0)) continue;
            ind3[j + 1] = ind3[j];
        }
        for (j = 0; j < ind4.length - 1; ++j) {
            if (!(ind4[j + 1] - ind4[j] < 0.0)) continue;
            ind4[j + 1] = ind4[j];
        }
        j = 0;
        while (j < ind3.length) {
            int n = j++;
            ind3[n] = ind3[n] / ind3[ind3.length - 1];
        }
        j = 0;
        while (j < ind4.length) {
            int n = j++;
            ind4[n] = ind4[n] / ind4[ind4.length - 1];
        }
        for (j = 0; j < ind3.length; ++j) {
            cont3[j] = ind3[j] * factor + min;
        }
        for (j = 0; j < ind4.length; ++j) {
            cont4[j] = ind4[j] * factor + min;
        }
    }

    @Override
    public void crossover(Genotype parent, Genotype of1, Genotype of2, int crossoverID) throws invalidCrossover {
        boolean debug = false;
        if (crossoverID != 1001 && crossoverID != 1002) {
            throw new invalidCrossover("Cruce no valido en FuzzyGAP");
        }
        GenotypeFuzzyGAP f3 = (GenotypeFuzzyGAP)of1;
        GenotypeFuzzyGAP f4 = (GenotypeFuzzyGAP)of2;
        f3.set(this);
        f4.set((GenotypeFuzzyGAP)parent);
        if (crossoverID == 1001) {
            double[] cont4;
            double[] cont3;
            for (int i = 0; i < f3.A.length; ++i) {
                cont3 = f3.A[i].toVector();
                cont4 = f4.A[i].toVector();
                this.partBInternalCrossover(cont3, cont4);
                f3.A[i] = new FuzzyPartition(cont3);
                f4.A[i] = new FuzzyPartition(cont4);
            }
            cont3 = f3.B.toVector();
            cont4 = f4.B.toVector();
            if (cont3.length > 0) {
                this.partBInternalCrossover(cont3, cont4);
                f3.B = new FuzzyPartition(cont3);
                f4.B = new FuzzyPartition(cont4);
            }
        } else {
            Node tmp;
            int lTypeOfNode;
            int firstCrossPoint = 0;
            while ((lTypeOfNode = (tmp = (Node)f3.theNodes.elementAt(firstCrossPoint = (int)(rand.Rand() * (double)(f3.theNodes.size() - 1)) + 1)).type()) == 0 || lTypeOfNode == 2 || lTypeOfNode == 6) {
            }
            GenotypeFuzzyGAP f2 = (GenotypeFuzzyGAP)parent;
            tmp = (Node)f3.theNodes.elementAt(firstCrossPoint);
            int T1 = tmp.type();
            Vector<Integer> ableToCrossNodes = new Vector<Integer>();
            switch (T1) {
                case 0: 
                case 1: 
                case 2: 
                case 6: 
                case 7: {
                    Integer itmp;
                    int i;
                    for (i = 0; i < f4.theNodes.size(); ++i) {
                        tmp = (Node)f4.theNodes.elementAt(i);
                        itmp = (Integer)this.theDepthAtEachNode.elementAt(firstCrossPoint);
                        if (tmp.type() != T1 || MAXH - itmp < this.getHeight(tmp)) continue;
                        ableToCrossNodes.addElement(new Integer(i));
                    }
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    Integer itmp;
                    int i;
                    for (i = 0; i < f4.theNodes.size(); ++i) {
                        tmp = (Node)f4.theNodes.elementAt(i);
                        lTypeOfNode = tmp.type();
                        itmp = (Integer)this.theDepthAtEachNode.elementAt(firstCrossPoint);
                        if (lTypeOfNode != 3 && lTypeOfNode != 4 && lTypeOfNode != 5 || MAXH - itmp < this.getHeight(tmp)) continue;
                        ableToCrossNodes.addElement(new Integer(i));
                    }
                    break;
                }
            }
            if (ableToCrossNodes.size() != 0) {
                int secondCrossPoint = (int)(rand.Rand() * (double)ableToCrossNodes.size());
                int nh = -1;
                tmp = (Node)f3.theParents.elementAt(firstCrossPoint);
                Node tmp1 = (Node)f3.theNodes.elementAt(firstCrossPoint);
                for (int i = 0; i < tmp.nChildren(); ++i) {
                    if (tmp.child(i) != tmp1) continue;
                    nh = i;
                    break;
                }
                int nh1 = -1;
                Integer itmp = (Integer)ableToCrossNodes.elementAt(secondCrossPoint);
                tmp = (Node)f4.theParents.elementAt(itmp);
                tmp1 = (Node)f4.theNodes.elementAt(itmp);
                for (int i = 0; i < tmp.nChildren(); ++i) {
                    if (tmp.child(i) != tmp1) continue;
                    nh1 = i;
                    break;
                }
                tmp = (Node)f3.theParents.elementAt(firstCrossPoint);
                itmp = (Integer)ableToCrossNodes.elementAt(secondCrossPoint);
                tmp1 = (Node)f4.theParents.elementAt(itmp);
                Node tmpswap = tmp.child(nh);
                tmp.changeChild(tmp1.child(nh1), nh);
                tmp1.changeChild(tmpswap, nh1);
                f3.buildNodeLists();
                f4.buildNodeLists();
            }
        }
    }

    @Override
    public void Random() {
        double[] ind;
        double[] cont;
        this.rootNode = (NodeRuleBase)this.RandomTree(7, MAXH, 0);
        for (int i = 0; i < this.A.length; ++i) {
            int j;
            cont = this.A[i].toVector();
            ind = new double[cont.length];
            ind[0] = 0.0;
            for (j = 1; j < ind.length; ++j) {
                ind[j] = ind[j - 1] + rand.Rand();
            }
            j = 1;
            while (j < ind.length) {
                int n = j++;
                ind[n] = ind[n] / ind[ind.length - 1];
            }
            double min = cont[0];
            double max = cont[cont.length - 1];
            double factor = max - min;
            for (int j2 = 0; j2 < ind.length; ++j2) {
                cont[j2] = ind[j2] * factor + min;
            }
            this.A[i] = new FuzzyPartition(cont);
        }
        cont = this.B.toVector();
        if (cont.length > 0) {
            int j;
            ind = new double[cont.length];
            ind[0] = 0.0;
            for (j = 1; j < ind.length; ++j) {
                ind[j] = ind[j - 1] + rand.Rand();
            }
            j = 1;
            while (j < ind.length) {
                int n = j++;
                ind[n] = ind[n] / ind[ind.length - 1];
            }
            double min = cont[0];
            double max = cont[cont.length - 1];
            double factor = max - min;
            for (int j3 = 0; j3 < ind.length; ++j3) {
                cont[j3] = ind[j3] * factor + min;
            }
            this.B = new FuzzyPartition(cont);
        }
        this.buildNodeLists();
    }

    @Override
    public void debug() {
        this.rootNode.debug();
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    private int getNumConsequents() {
        return this.B.size();
    }

    private int getNumInputs() {
        return this.A.length;
    }

    private Fuzzy getLabel(int nv, int nlabel) {
        return this.A[nv].getComponent(nlabel);
    }

    int getNumLabels(int nv) {
        return this.A[nv].size();
    }

    private int getHeight(Node n) {
        int mh = 0;
        for (int i = 0; i < n.nChildren(); ++i) {
            int h = this.getHeight(n.child(i));
            if (h <= mh) continue;
            mh = h;
        }
        return 1 + mh;
    }

    private void insertNode(Node n, Node parent, int p) {
        this.theNodes.addElement(n);
        this.theParents.addElement(parent);
        this.theDepthAtEachNode.addElement(new Integer(p));
        for (int i = 0; i < n.nChildren(); ++i) {
            this.insertNode(n.child(i), n, p + 1);
        }
    }

    private void buildNodeLists() {
        this.theNodes = new Vector();
        this.theParents = new Vector();
        this.theDepthAtEachNode = new Vector();
        this.insertNode(this.rootNode, null, 0);
    }

    Node RandomTree(int t, int maxh, int par) {
        switch (t) {
            case 0: {
                return new NodeVariable(par);
            }
            case 1: {
                int nlabel = (int)(rand.Rand() * (double)this.getNumLabels(par));
                return new NodeLabel(this.getLabel(par, nlabel));
            }
            case 2: {
                return new NodeConsequent(par);
            }
            case 3: {
                int[] tr = new int[2];
                for (int i = 0; i < 2; ++i) {
                    if (maxh <= 2) {
                        tr[i] = 5;
                        continue;
                    }
                    int typeOfAssert = (int)(rand.Rand() * 3.0);
                    if (typeOfAssert == 0) {
                        tr[i] = 3;
                        continue;
                    }
                    if (typeOfAssert == 1) {
                        tr[i] = 4;
                        continue;
                    }
                    if (typeOfAssert != 2) continue;
                    tr[i] = 5;
                }
                NodeAssert na1 = (NodeAssert)this.RandomTree(tr[0], maxh - 1, 0);
                NodeAssert na2 = (NodeAssert)this.RandomTree(tr[1], maxh - 1, 0);
                NodeAnd result = new NodeAnd(na1, na2);
                return result;
            }
            case 4: {
                int[] tr = new int[2];
                for (int i = 0; i < 2; ++i) {
                    if (maxh <= 2) {
                        tr[i] = 5;
                        continue;
                    }
                    int typeOfAssert = (int)(rand.Rand() * 3.0);
                    if (typeOfAssert == 0) {
                        tr[i] = 3;
                        continue;
                    }
                    if (typeOfAssert == 1) {
                        tr[i] = 4;
                        continue;
                    }
                    if (typeOfAssert != 2) continue;
                    tr[i] = 5;
                }
                NodeAssert na1 = (NodeAssert)this.RandomTree(tr[0], maxh - 1, 0);
                NodeAssert na2 = (NodeAssert)this.RandomTree(tr[1], maxh - 1, 0);
                NodeOr result = new NodeOr(na1, na2);
                return result;
            }
            case 5: {
                int nv = (int)(rand.Rand() * (double)this.getNumInputs());
                NodeVariable nvar = (NodeVariable)this.RandomTree(0, maxh - 1, nv);
                NodeLabel nval = (NodeLabel)this.RandomTree(1, maxh - 1, nv);
                NodeIs result = new NodeIs(nvar, nval);
                return result;
            }
            case 6: {
                int typeOfAssert = (int)(rand.Rand() * 3.0);
                int tr = 3;
                if (typeOfAssert == 0) {
                    tr = 3;
                } else if (typeOfAssert == 1) {
                    tr = 4;
                } else if (typeOfAssert == 2) {
                    tr = 5;
                }
                NodeAssert na = (NodeAssert)this.RandomTree(tr, maxh - 1, 0);
                int ncons = (int)(rand.Rand() * (double)this.getNumConsequents());
                NodeConsequent nc = (NodeConsequent)this.RandomTree(2, maxh - 1, par);
                NodeRule result = new NodeRule(na, nc, 1.0);
                return result;
            }
            case 7: {
                NodeRule[] proot = new NodeRule[this.getNumConsequents()];
                for (int i = 0; i < proot.length; ++i) {
                    proot[i] = (NodeRule)this.RandomTree(6, maxh - 1, i);
                }
                NodeRuleBase result = new NodeRuleBase(proot);
                return result;
            }
        }
        return new NodeVariable(par);
    }
}

