/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Decision_Trees.DT_GA.C45;

import java.util.Enumeration;
import keel.Algorithms.Decision_Trees.DT_GA.C45.Classification;
import keel.Algorithms.Decision_Trees.DT_GA.C45.Dataset;
import keel.Algorithms.Decision_Trees.DT_GA.C45.Itemset;

public class Cut {
    protected Classification classification;
    protected int numSubsets;
    private int nBranches;
    private int attributeIndex;
    private int minItemsets;
    private double cutPoint;
    private double infoGain;
    private double gainRatio;
    private double sumOfWeights;
    private int nCuts;

    public Cut(int index, int nObj, double weights) {
        this.attributeIndex = index;
        this.minItemsets = nObj;
        this.sumOfWeights = weights;
    }

    public Cut(Classification dist) {
        this.classification = new Classification(dist);
        this.numSubsets = 1;
    }

    public void classify(Dataset trainItemsets) throws Exception {
        if (this.numSubsets == 1) {
            this.classification = new Classification(trainItemsets);
        } else {
            this.numSubsets = 0;
            this.cutPoint = Double.MAX_VALUE;
            this.infoGain = 0.0;
            this.gainRatio = 0.0;
            if (trainItemsets.getAttribute(this.attributeIndex).isDiscret()) {
                this.nCuts = this.nBranches != 2 ? (this.nBranches = trainItemsets.getAttribute(this.attributeIndex).numValues()) : 0;
                this.cutDiscret(trainItemsets);
            } else {
                this.nCuts = 0;
                trainItemsets.sort(this.attributeIndex);
                this.cutContinuous(trainItemsets);
            }
        }
    }

    public final double classProbability(int classIndex, Itemset itemset, int subset) {
        if (this.numSubsets == 1) {
            if (subset > -1) {
                return this.classification.probability(classIndex, subset);
            }
            double[] weights = this.weights(itemset);
            if (weights == null) {
                return this.classification.probability(classIndex);
            }
            double prob = 0.0;
            for (int i = 0; i < weights.length; ++i) {
                prob += weights[i] * this.classification.probability(classIndex, i);
            }
            return prob;
        }
        if (subset <= -1) {
            double[] weights = this.weights(itemset);
            if (weights == null) {
                return this.classification.probability(classIndex);
            }
            double prob = 0.0;
            for (int i = 0; i < weights.length; ++i) {
                prob += weights[i] * this.classification.probability(classIndex, i);
            }
            return prob;
        }
        if (this.classification.perValue(subset) > 0.0) {
            return this.classification.probability(classIndex, subset);
        }
        if (this.classification.maxClass() == classIndex) {
            return 1.0;
        }
        return 0.0;
    }

    private void cutContinuous(Dataset trainItemsets) {
        Itemset itemset;
        int next = 1;
        int last = 0;
        int cutIndex = -1;
        this.classification = new Classification(2, trainItemsets.numClasses());
        Enumeration enum2 = trainItemsets.enumerateItemsets();
        int i = 0;
        while (enum2.hasMoreElements() && !(itemset = (Itemset)enum2.nextElement()).isMissing(this.attributeIndex)) {
            this.classification.add(1, itemset);
            ++i;
        }
        int firstMiss = i;
        double minCut = 0.1 * this.classification.getTotal() / (double)trainItemsets.numClasses();
        if (minCut <= (double)this.minItemsets) {
            minCut = this.minItemsets;
        } else if (minCut > 5.0) {
            minCut = 25.0;
        }
        if ((double)firstMiss < 2.0 * minCut) {
            return;
        }
        double defaultEnt = this.oldEntropy(this.classification);
        while (next < firstMiss) {
            if (trainItemsets.itemset(next - 1).getValue(this.attributeIndex) + 1.0E-5 < trainItemsets.itemset(next).getValue(this.attributeIndex)) {
                this.classification.shiftRange(1, 0, trainItemsets, last, next);
                if (this.classification.perValue(0) >= minCut && this.classification.perValue(1) >= minCut) {
                    double currentInfoGain = this.infoGainCutCrit(this.classification, this.sumOfWeights, defaultEnt);
                    if (currentInfoGain > this.infoGain) {
                        this.infoGain = currentInfoGain;
                        cutIndex = next - 1;
                    }
                    ++this.nCuts;
                }
                last = next;
            }
            ++next;
        }
        if (this.nCuts == 0) {
            return;
        }
        this.infoGain -= Math.log(this.nCuts) / Math.log(2.0) / this.sumOfWeights;
        if (this.infoGain <= 0.0) {
            return;
        }
        this.numSubsets = 2;
        this.cutPoint = (trainItemsets.itemset(cutIndex + 1).getValue(this.attributeIndex) + trainItemsets.itemset(cutIndex).getValue(this.attributeIndex)) / 2.0;
        this.classification = new Classification(2, trainItemsets.numClasses());
        this.classification.addRange(0, trainItemsets, 0, cutIndex + 1);
        this.classification.addRange(1, trainItemsets, cutIndex + 1, firstMiss);
        this.gainRatio = this.gainRatioCutCrit(this.classification, this.sumOfWeights, this.infoGain);
    }

    private void cutDiscret(Dataset trainItemsets) {
        this.classification = new Classification(this.nBranches, trainItemsets.numClasses());
        Enumeration enum2 = trainItemsets.enumerateItemsets();
        while (enum2.hasMoreElements()) {
            Itemset itemset = (Itemset)enum2.nextElement();
            if (itemset.isMissing(this.attributeIndex)) continue;
            this.classification.add((int)itemset.getValue(this.attributeIndex), itemset);
        }
        if (this.classification.check(this.minItemsets)) {
            this.numSubsets = this.nBranches;
            this.infoGain = this.infoGainCutCrit(this.classification, this.sumOfWeights, this.oldEntropy(this.classification));
            this.gainRatio = this.gainRatioCutCrit(this.classification, this.sumOfWeights, this.infoGain);
        }
    }

    public final void setCutPoint(Dataset allItemsets) {
        double newCutPoint = -1.7976931348623157E308;
        if (allItemsets.getAttribute(this.attributeIndex).isContinuous() && this.numSubsets > 1) {
            Enumeration enum2 = allItemsets.enumerateItemsets();
            while (enum2.hasMoreElements()) {
                double tempValue;
                Itemset itemset = (Itemset)enum2.nextElement();
                if (itemset.isMissing(this.attributeIndex) || !((tempValue = itemset.getValue(this.attributeIndex)) > newCutPoint) || !(tempValue <= this.cutPoint)) continue;
                newCutPoint = tempValue;
            }
            this.cutPoint = newCutPoint;
        }
    }

    public final Dataset[] cutDataset(Dataset data) throws Exception {
        int j;
        Dataset[] itemsets = new Dataset[this.numSubsets];
        for (j = 0; j < this.numSubsets; ++j) {
            itemsets[j] = new Dataset(data, data.numItemsets());
        }
        for (int i = 0; i < data.numItemsets(); ++i) {
            Itemset itemset = data.itemset(i);
            double[] weights = this.weights(itemset);
            int subset = this.whichSubset(itemset);
            if (subset > -1) {
                itemsets[subset].addItemset(itemset);
                continue;
            }
            for (j = 0; j < this.numSubsets; ++j) {
                if (!(weights[j] > 0.0)) continue;
                double newWeight = weights[j] * itemset.getWeight();
                itemsets[j].addItemset(itemset);
                itemsets[j].lastItemset().setWeight(newWeight);
            }
        }
        for (j = 0; j < this.numSubsets; ++j) {
            itemsets[j].itemsets.trimToSize();
        }
        return itemsets;
    }

    public void resetClassification(Dataset data) throws Exception {
        if (this.numSubsets == 1) {
            this.classification = new Classification(data, this);
        } else {
            Dataset insts = new Dataset(data, data.numItemsets());
            for (int i = 0; i < data.numItemsets(); ++i) {
                if (this.whichSubset(data.itemset(i)) <= -1) continue;
                insts.addItemset(data.itemset(i));
            }
            Classification newD = new Classification(insts, this);
            newD.addWithUnknownValue(data, this.attributeIndex);
            this.classification = newD;
        }
    }

    public final double[] weights(Itemset itemset) {
        if (this.numSubsets == 1) {
            return null;
        }
        if (itemset.isMissing(this.attributeIndex)) {
            double[] weights = new double[this.numSubsets];
            for (int i = 0; i < this.numSubsets; ++i) {
                weights[i] = this.classification.perValue(i) / this.classification.getTotal();
            }
            return weights;
        }
        return null;
    }

    public final int whichSubset(Itemset itemset) {
        if (this.numSubsets == 1) {
            return 0;
        }
        if (itemset.isMissing(this.attributeIndex)) {
            return -1;
        }
        if (itemset.getAttribute(this.attributeIndex).isDiscret()) {
            return (int)itemset.getValue(this.attributeIndex);
        }
        if (itemset.getValue(this.attributeIndex) <= this.cutPoint) {
            return 0;
        }
        return 1;
    }

    public final boolean checkModel() {
        return this.numSubsets > 0;
    }

    public final Classification classification() {
        return this.classification;
    }

    public final int numSubsets() {
        return this.numSubsets;
    }

    public final double gainRatioCutCrit(Classification values, double totalnoInst, double numerator) {
        double denumerator = this.cutEntropy(values, totalnoInst);
        if (denumerator == 0.0) {
            return 0.0;
        }
        return numerator / (denumerator /= totalnoInst);
    }

    public final double infoGainCutCrit(Classification values, double totalNoInst, double oldEnt) {
        double noUnknown = totalNoInst - values.getTotal();
        double unknownRate = noUnknown / totalNoInst;
        double numerator = oldEnt - this.newEntropy(values);
        if ((numerator = (1.0 - unknownRate) * numerator) == 0.0) {
            return 0.0;
        }
        return numerator / values.getTotal();
    }

    private final double cutEntropy(Classification values, double totalnoInst) {
        double returnValue = 0.0;
        double noUnknown = totalnoInst - values.getTotal();
        if (values.getTotal() > 0.0) {
            for (int i = 0; i < values.numValues(); ++i) {
                returnValue -= this.logFunc(values.perValue(i));
            }
            returnValue -= this.logFunc(noUnknown);
            returnValue += this.logFunc(totalnoInst);
        }
        return returnValue;
    }

    public final double oldEntropy(Classification values) {
        double returnValue = 0.0;
        for (int j = 0; j < values.numClasses(); ++j) {
            returnValue += this.logFunc(values.perClass(j));
        }
        return this.logFunc(values.getTotal()) - returnValue;
    }

    public final double newEntropy(Classification values) {
        double returnValue = 0.0;
        for (int i = 0; i < values.numValues(); ++i) {
            for (int j = 0; j < values.numClasses(); ++j) {
                returnValue += this.logFunc(values.perClassPerValue(i, j));
            }
            returnValue -= this.logFunc(values.perValue(i));
        }
        return -returnValue;
    }

    protected final double logFunc(double num) {
        if (num < 1.0E-6) {
            return 0.0;
        }
        return num * Math.log(num) / Math.log(2.0);
    }

    public final double getInfoGain() {
        return this.infoGain;
    }

    public final double getGainRatio() {
        return this.gainRatio;
    }

    public final String leftSide(Dataset data) {
        if (this.numSubsets == 1) {
            return "";
        }
        return "Att" + this.attributeIndex;
    }

    public final String leftSide2(Dataset data) {
        if (this.numSubsets == 1) {
            return "";
        }
        return data.getAttribute(this.attributeIndex).name();
    }

    public final String rightSide(int index, Dataset data) {
        if (this.numSubsets == 1) {
            return "";
        }
        StringBuffer text = new StringBuffer();
        if (data.getAttribute(this.attributeIndex).isDiscret()) {
            text.append(" = " + data.getAttribute(this.attributeIndex).value(index));
        } else if (index == 0) {
            text.append(" <= " + Cut.doubleToString(this.cutPoint, 6));
        } else {
            text.append(" > " + Cut.doubleToString(this.cutPoint, 6));
        }
        return text.toString();
    }

    public final String rightSide2(int index, Dataset data) {
        if (this.numSubsets == 1) {
            return "";
        }
        StringBuffer text = new StringBuffer();
        if (data.getAttribute(this.attributeIndex).isDiscret()) {
            text.append(" = " + data.getAttribute(this.attributeIndex).value(index));
        } else if (index == 0) {
            text.append(" <= " + Cut.doubleToString(this.cutPoint, 6));
        } else {
            text.append(" > " + Cut.doubleToString(this.cutPoint, 6));
        }
        return text.toString();
    }

    public final String label2(int index, Dataset data) {
        StringBuffer text = new StringBuffer();
        text.append(this.classification.maxClass(index));
        return text.toString();
    }

    public final String label(int index, Dataset data) {
        StringBuffer text = new StringBuffer();
        text.append(data.getClassAttribute().value(this.classification.maxClass(index)));
        return text.toString();
    }

    public final int attributeIndex() {
        return this.attributeIndex;
    }

    public static String doubleToString(double value, int afterDecimalPoint) {
        double temp = value * Math.pow(10.0, afterDecimalPoint);
        if (Math.abs(temp) < 9.223372036854776E18) {
            int dotPosition;
            long precisionValue = temp > 0.0 ? (long)(temp + 0.5) : -((long)(Math.abs(temp) + 0.5));
            StringBuffer stringBuffer = precisionValue == 0L ? new StringBuffer(String.valueOf(0)) : new StringBuffer(String.valueOf(precisionValue));
            if (afterDecimalPoint == 0) {
                return stringBuffer.toString();
            }
            for (dotPosition = stringBuffer.length() - afterDecimalPoint; precisionValue < 0L && dotPosition < 1 || dotPosition < 0; ++dotPosition) {
                if (precisionValue < 0L) {
                    stringBuffer.insert(1, 0);
                    continue;
                }
                stringBuffer.insert(0, 0);
            }
            stringBuffer.insert(dotPosition, '.');
            if (precisionValue < 0L && stringBuffer.charAt(1) == '.') {
                stringBuffer.insert(1, 0);
            } else if (stringBuffer.charAt(0) == '.') {
                stringBuffer.insert(0, 0);
            }
            int currentPos = stringBuffer.length() - 1;
            if (stringBuffer.charAt(currentPos) == '.') {
                stringBuffer.setCharAt(currentPos, ' ');
            }
            return stringBuffer.toString().trim();
        }
        return new String("" + value);
    }

    public static String doubleToString(double value, int width, int afterDecimalPoint) {
        int i;
        int dotPosition;
        String tempString = Cut.doubleToString(value, afterDecimalPoint);
        if (afterDecimalPoint >= width || tempString.indexOf(69) != -1) {
            return tempString;
        }
        char[] result = new char[width];
        for (int i2 = 0; i2 < result.length; ++i2) {
            result[i2] = 32;
        }
        if (afterDecimalPoint > 0) {
            dotPosition = tempString.indexOf(46);
            if (dotPosition == -1) {
                dotPosition = tempString.length();
            } else {
                result[width - afterDecimalPoint - 1] = 46;
            }
        } else {
            dotPosition = tempString.length();
        }
        int offset = width - afterDecimalPoint - dotPosition;
        if (afterDecimalPoint > 0) {
            --offset;
        }
        if (offset < 0) {
            return tempString;
        }
        for (i = 0; i < dotPosition; ++i) {
            result[offset + i] = tempString.charAt(i);
        }
        for (i = dotPosition + 1; i < tempString.length(); ++i) {
            result[offset + i] = tempString.charAt(i);
        }
        return new String(result);
    }
}

