/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Rule_Learning.Ripper;

import java.util.Vector;
import keel.Algorithms.Rule_Learning.Ripper.IncrementalMask;
import keel.Algorithms.Rule_Learning.Ripper.Mask;
import keel.Algorithms.Rule_Learning.Ripper.MyDataset;
import keel.Algorithms.Rule_Learning.Ripper.Rule;
import keel.Algorithms.Rule_Learning.Ripper.Stats;
import keel.Algorithms.Rule_Learning.Ripper.Utilities;

public class Ruleset {
    private Vector rules = new Vector();
    private String type;

    public void addRule(Rule r) {
        this.rules.add(r);
    }

    public Stats apply(MyDataset data) {
        Stats stats = new Stats();
        Mask positives = new Mask(data.size());
        data.filterByClass(positives, this.type);
        Mask negatives = positives.complement();
        int npositives = positives.getnActive();
        int nnegatives = negatives.getnActive();
        for (int i = 0; i < this.rules.size(); ++i) {
            data.substract(positives, (Rule)this.rules.elementAt(i));
            data.substract(negatives, (Rule)this.rules.elementAt(i));
        }
        stats.fn = positives.getnActive();
        stats.tp = npositives - stats.fn;
        stats.tn = negatives.getnActive();
        stats.fp = nnegatives - stats.tn;
        return stats;
    }

    public Stats apply(MyDataset data, Mask positives, Mask negatives) {
        Stats stats = new Stats();
        int npositives = positives.getnActive();
        int nnegatives = negatives.getnActive();
        Mask p = positives.copy();
        Mask n = negatives.copy();
        for (int i = 0; i < this.rules.size(); ++i) {
            data.substract(p, (Rule)this.rules.elementAt(i));
            data.substract(n, (Rule)this.rules.elementAt(i));
        }
        stats.fn = p.getnActive();
        stats.tp = npositives - stats.fn;
        stats.tn = n.getnActive();
        stats.fp = nnegatives - stats.tn;
        return stats;
    }

    public double getExceptionCost(MyDataset data, Mask positives, Mask negatives) {
        double uncoverBits;
        double coverBits;
        if (this.rules.size() == 0) {
            return 0.0;
        }
        Stats quartet = this.apply(data, positives, negatives);
        double tp = quartet.tp;
        double tn = quartet.tn;
        double fp = quartet.fp;
        double fn = quartet.fn;
        double U = tn + fn;
        double C = tp + fp;
        double D = U + C;
        double e = fn + fp;
        double mdl = 0.0;
        if (C > U) {
            coverBits = e / (2.0 * C);
            uncoverBits = U > 0.0 ? fn / U : 0.0;
        } else {
            coverBits = C > 0.0 ? fp / C : 0.0;
            uncoverBits = e / (2.0 * U);
        }
        double tp_prob = coverBits == 0.0 ? 0.0 : tp * -Utilities.log2(1.0 - coverBits);
        double fp_prob = coverBits == 0.0 ? 0.0 : fp * -Utilities.log2(coverBits);
        double tn_prob = uncoverBits == 0.0 ? 0.0 : tn * -Utilities.log2(1.0 - uncoverBits);
        double fn_prob = uncoverBits == 0.0 ? 0.0 : fn * -Utilities.log2(uncoverBits);
        mdl = Utilities.log2(D + 1.0) + tp_prob + tn_prob + fp_prob + fn_prob;
        return mdl;
    }

    public double getMDL(MyDataset data, Mask positives, Mask negatives) {
        return this.getTheoryCost(data) + this.getExceptionCost(data, positives, negatives);
    }

    public double getExceptionCost(MyDataset data) {
        Mask positives = new Mask(data.size());
        data.filterByClass(positives, this.type);
        Mask negatives = positives.complement();
        return this.getExceptionCost(data, positives, negatives);
    }

    public double getMDL(MyDataset data) {
        return this.getTheoryCost(data) + this.getExceptionCost(data);
    }

    public double getExceptionCost(MyDataset data, Mask positives, Mask negatives, IncrementalMask rulesetMask) {
        int tp = rulesetMask.and(positives).getnActive();
        int fp = rulesetMask.and(negatives).getnActive();
        int fn = positives.getnActive() - tp;
        int tn = negatives.getnActive() - fp;
        double mdl_ruleset = Rule.getExceptionCost(data, tp, tn, fp, fn);
        return mdl_ruleset;
    }

    public double getMDL(MyDataset data, Mask positives, Mask negatives, IncrementalMask rulesetMask) {
        return this.getTheoryCost(data) + this.getExceptionCost(data, positives, negatives, rulesetMask);
    }

    public double getTheoryCost(MyDataset data) {
        double total = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            total += this.getRule(i).theoryDL(data);
        }
        return total;
    }

    public Rule getRule(int pos) {
        return (Rule)this.rules.elementAt(pos);
    }

    public String getType() {
        return this.type;
    }

    public IncrementalMask getRulesetMask(MyDataset data) {
        IncrementalMask rulesetMask = new IncrementalMask(data.size());
        for (int i = 0; i < this.rules.size(); ++i) {
            Mask ruleMask = new Mask(data.size());
            data.filter(ruleMask, this.getRule(i));
            rulesetMask.plus(ruleMask);
        }
        return rulesetMask;
    }

    public void insertRule(Rule r, int pos) {
        this.rules.insertElementAt(r, pos);
    }

    public void removeRule(int pos) {
        this.rules.remove(pos);
    }

    public void setType(String type) {
        this.type = type;
    }

    public void removeDuplicates() {
        for (int i = 0; i < this.rules.size(); ++i) {
            Rule current = (Rule)this.rules.elementAt(i);
            if (current.size() != 0) {
                for (int j = i + 1; j < this.rules.size(); ++j) {
                    if (!current.isEqual((Rule)this.rules.elementAt(j))) continue;
                    this.rules.remove(j);
                    --j;
                }
                continue;
            }
            this.rules.remove(i);
            --i;
        }
    }

    public void pulish(MyDataset data, Mask positives, Mask negatives) {
        IncrementalMask rulesetMask = new IncrementalMask(data.size());
        Mask[] ruleMask = new Mask[this.rules.size()];
        for (int i = 0; i < this.rules.size(); ++i) {
            ruleMask[i] = new Mask(data.size());
            data.filter(ruleMask[i], this.getRule(i));
            rulesetMask.plus(ruleMask[i]);
        }
        double thCost = this.getTheoryCost(data);
        int tp = rulesetMask.and(positives).getnActive();
        int fp = rulesetMask.and(negatives).getnActive();
        int fn = positives.getnActive() - tp;
        int tn = negatives.getnActive() - fp;
        double mdl_ruleset = thCost + Rule.getExceptionCost(data, tp, tn, fp, fn);
        for (int i = 0; i < this.rules.size(); ++i) {
            rulesetMask.minus(ruleMask[i]);
            tp = rulesetMask.and(positives).getnActive();
            fp = rulesetMask.and(negatives).getnActive();
            fn = positives.getnActive() - tp;
            tn = negatives.getnActive() - fp;
            double mdl_whithout_i = (thCost -= this.getRule(i).theoryDL(data)) + Rule.getExceptionCost(data, tp, tn, fp, fn);
            if (mdl_whithout_i < mdl_ruleset) {
                this.rules.remove(i);
                --i;
                mdl_ruleset = mdl_whithout_i;
                continue;
            }
            rulesetMask.plus(ruleMask[i]);
            thCost += this.getRule(i).theoryDL(data);
        }
    }

    public int size() {
        return this.rules.size();
    }

    public String toString() {
        String output = "";
        for (int i = 0; i < this.rules.size(); ++i) {
            output = output + ((Rule)this.rules.elementAt(i)).toString() + " -> " + this.type + "\n";
        }
        return output;
    }
}

