/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.RE_SL_Methods.MamWM;

import keel.Algorithms.RE_SL_Methods.MamWM.BaseD;
import keel.Algorithms.RE_SL_Methods.MamWM.Difuso;
import keel.Algorithms.RE_SL_Methods.MamWM.MiDataset;
import keel.Algorithms.RE_SL_Methods.MamWM.TipoRegla;

class BaseR {
    public Difuso[][] BaseReglas;
    public int n_reglas;
    public int n_genes;
    public double[] GradoEmp;
    public Difuso[] Consecuentes;
    public double[][] ListaTabu;
    public MiDataset tabla;
    public BaseD base_datos;

    public BaseR(int MaxReglas, BaseD base, MiDataset t) {
        this.tabla = t;
        this.base_datos = base;
        this.n_reglas = 0;
        this.n_genes = this.tabla.n_variables * 4;
        this.BaseReglas = new Difuso[MaxReglas][this.tabla.n_variables];
        this.Consecuentes = new Difuso[MaxReglas];
        for (int i = 0; i < MaxReglas; ++i) {
            this.BaseReglas[i] = new Difuso[this.tabla.n_variables];
            this.Consecuentes[i] = new Difuso();
            for (int j = 0; j < this.tabla.n_variables; ++j) {
                this.BaseReglas[i][j] = new Difuso();
            }
        }
        this.GradoEmp = new double[MaxReglas];
        this.ListaTabu = new double[MaxReglas][this.tabla.n_variables];
    }

    public double Fuzzifica(double X, Difuso D) {
        if (X < D.x0 || X > D.x3) {
            return 0.0;
        }
        if (X < D.x1) {
            return (X - D.x0) * (D.y / (D.x1 - D.x0));
        }
        if (X > D.x2) {
            return (D.x3 - X) * (D.y / (D.x3 - D.x2));
        }
        return D.y;
    }

    public void Min(double[] entradas) {
        for (int b = 0; b < this.n_reglas; ++b) {
            double minimo = this.Fuzzifica(entradas[0], this.BaseReglas[b][0]);
            for (int b2 = 1; b2 < this.tabla.n_var_estado; ++b2) {
                double y = this.Fuzzifica(entradas[b2], this.BaseReglas[b][b2]);
                if (!(y < minimo)) continue;
                minimo = y;
            }
            this.GradoEmp[b] = minimo;
        }
    }

    public void T_Min() {
        for (int b = 0; b < this.n_reglas; ++b) {
            if (this.GradoEmp[b] != 0.0) {
                if (this.GradoEmp[b] == 1.0) {
                    this.Consecuentes[b].x0 = this.BaseReglas[b][this.tabla.n_variables - 1].x0;
                    this.Consecuentes[b].x1 = this.BaseReglas[b][this.tabla.n_variables - 1].x1;
                    this.Consecuentes[b].x2 = this.BaseReglas[b][this.tabla.n_variables - 1].x2;
                    this.Consecuentes[b].x3 = this.BaseReglas[b][this.tabla.n_variables - 1].x3;
                } else {
                    this.Consecuentes[b].x0 = this.BaseReglas[b][this.tabla.n_variables - 1].x0;
                    this.Consecuentes[b].x1 = this.BaseReglas[b][this.tabla.n_variables - 1].x0 + (this.BaseReglas[b][this.tabla.n_variables - 1].x1 - this.BaseReglas[b][this.tabla.n_variables - 1].x0) * this.GradoEmp[b];
                    this.Consecuentes[b].x2 = this.BaseReglas[b][this.tabla.n_variables - 1].x3 + (this.BaseReglas[b][this.tabla.n_variables - 1].x2 - this.BaseReglas[b][this.tabla.n_variables - 1].x3) * this.GradoEmp[b];
                    this.Consecuentes[b].x3 = this.BaseReglas[b][this.tabla.n_variables - 1].x3;
                }
            }
            this.Consecuentes[b].y = this.GradoEmp[b];
        }
    }

    public double AreaTrapecioX(double x0, double x1, double x2, double x3, double y) {
        double izq = x1 != x0 ? (2.0 * x1 * x1 * x1 - 3.0 * x0 * x1 * x1 + x0 * x0 * x0) / (6.0 * (x1 - x0)) : 0.0;
        double centro = (x2 * x2 - x1 * x1) / 2.0;
        double der = x3 != x2 ? (2.0 * x2 * x2 * x2 - 3.0 * x3 * x2 * x2 + x3 * x3 * x3) / (6.0 * (x3 - x2)) : 0.0;
        return y * (izq + centro + der);
    }

    public double AreaTrapecio(double x0, double x1, double x2, double x3, double y) {
        double izq = x1 != x0 ? (x1 * x1 - 2.0 * x0 * x1 + x0 * x0) / (2.0 * (x1 - x0)) : 0.0;
        double centro = x2 - x1;
        double der = x3 != x2 ? (x3 * x3 - 2.0 * x3 * x2 + x2 * x2) / (2.0 * (x3 - x2)) : 0.0;
        return y * (izq + centro + der);
    }

    public double WECOA() {
        double num = 0.0;
        double den = 0.0;
        for (int i = 0; i < this.n_reglas; ++i) {
            if (this.Consecuentes[i].y == 0.0) continue;
            num += this.GradoEmp[i] * (this.AreaTrapecioX(this.Consecuentes[i].x0, this.Consecuentes[i].x1, this.Consecuentes[i].x2, this.Consecuentes[i].x3, this.Consecuentes[i].y) / this.AreaTrapecio(this.Consecuentes[i].x0, this.Consecuentes[i].x1, this.Consecuentes[i].x2, this.Consecuentes[i].x3, this.Consecuentes[i].y));
            den += this.GradoEmp[i];
        }
        if (den != 0.0) {
            return num / den;
        }
        return (this.base_datos.extremos[this.tabla.n_var_estado].max - this.base_datos.extremos[this.tabla.n_var_estado].min) / 2.0;
    }

    public double FLC(double[] Entrada) {
        this.Min(Entrada);
        this.T_Min();
        return this.WECOA();
    }

    public void decodifica(TipoRegla[] Conjunto_Reglas) {
        for (int i = 0; i < this.n_reglas; ++i) {
            for (int j = 0; j < this.tabla.n_variables; ++j) {
                this.BaseReglas[i][j].x0 = this.base_datos.BaseDatos[j][Conjunto_Reglas[i].Regla[j]].x0;
                this.BaseReglas[i][j].x1 = this.base_datos.BaseDatos[j][Conjunto_Reglas[i].Regla[j]].x1;
                this.BaseReglas[i][j].x2 = this.base_datos.BaseDatos[j][Conjunto_Reglas[i].Regla[j]].x2;
                this.BaseReglas[i][j].x3 = this.base_datos.BaseDatos[j][Conjunto_Reglas[i].Regla[j]].x3;
                this.BaseReglas[i][j].y = 1.0;
            }
        }
    }

    public String BRtoString(int peso) {
        String cadena = "";
        cadena = cadena + "Numero de reglas: " + this.n_reglas + "\n\n";
        for (int i = 0; i < this.n_reglas; ++i) {
            for (int j = 0; j < this.tabla.n_variables; ++j) {
                cadena = cadena + "" + this.BaseReglas[i][j].x0 + " " + this.BaseReglas[i][j].x1 + " " + this.BaseReglas[i][j].x3 + "\n";
            }
            if (peso > 0) {
                cadena = cadena + "1.0\n";
            }
            cadena = cadena + "\n";
        }
        return cadena;
    }
}

