/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.algorithm.memetic;

import java.util.ArrayList;
import java.util.List;
import net.sf.jclec.IConfigure;
import net.sf.jclec.IIndividual;
import net.sf.jclec.algorithm.classic.SG;
import net.sf.jclec.algorithm.memetic.IOptimizer;
import net.sf.jclec.selector.BettersSelector;
import net.sf.jclec.selector.WorsesSelector;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.builder.EqualsBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MG<I extends IIndividual>
extends SG<I> {
    private static final long serialVersionUID = -4552886143139539536L;
    protected IOptimizer<I> localOptimizer;
    protected int localOptimizationFrequency;
    protected double localOptimizationPercentage;
    protected BettersSelector<I> bettersSelector = new BettersSelector(this);
    protected WorsesSelector<I> worsesSelector = new WorsesSelector(this);

    public IOptimizer<I> getLocalOptimizer() {
        return this.localOptimizer;
    }

    public void setLocalOptimizer(IOptimizer<I> optimizer) {
        this.localOptimizer = optimizer;
        optimizer.contextualize(this);
    }

    public int getLocalOptimizationFrequency() {
        return this.localOptimizationFrequency;
    }

    public void setLocalOptimizationFrequency(int fOptimizer) {
        this.localOptimizationFrequency = fOptimizer;
    }

    public double getLocalOptimizationPercentage() {
        return this.localOptimizationPercentage;
    }

    public void setLocalOptimizationPercentage(double pOptimizer) {
        this.localOptimizationPercentage = pOptimizer;
    }

    @Override
    public void configure(Configuration configuration) {
        super.configure(configuration);
        try {
            String optimizerClassname = configuration.getString("local-optimizer[@type]");
            Class<?> optimizerClass = Class.forName(optimizerClassname);
            IOptimizer optimizer = (IOptimizer)optimizerClass.newInstance();
            if (optimizer instanceof IConfigure) {
                Configuration optimizerConfiguration = configuration.subset("local-optimizer");
                ((IConfigure)((Object)optimizer)).configure(optimizerConfiguration);
            }
            this.setLocalOptimizer(optimizer);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        int fOptimizer = configuration.getInt("local-optimization-frecuency", 5);
        this.setLocalOptimizationFrequency(fOptimizer);
        double pOptimizer = configuration.getDouble("local-optimization-percentaje", 0.2);
        this.setLocalOptimizationPercentage(pOptimizer);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof MG) {
            MG cother = (MG)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.appendSuper(super.equals(other));
            eb.append(this.parentsSelector, cother.parentsSelector);
            eb.append(this.mutator, cother.mutator);
            eb.append(this.recombinator, cother.recombinator);
            eb.append(this.localOptimizer, cother.localOptimizer);
            eb.append(this.localOptimizationFrequency, cother.localOptimizationFrequency);
            eb.append(this.localOptimizationPercentage, cother.localOptimizationPercentage);
            return eb.isEquals();
        }
        return false;
    }

    @Override
    public void doIterate() {
        ++this.generation;
        this.doSelection();
        this.doGeneration();
        this.doOptimization();
        this.doReplacement();
        this.doUpdate();
        this.doControl();
    }

    protected void doOptimization() {
        List<Object> optimizados = new ArrayList();
        if (this.generation % this.localOptimizationFrequency == 0) {
            int numIndividual = (int)((double)this.cset.size() * this.localOptimizationPercentage);
            List mejores = this.bettersSelector.select(this.cset, numIndividual);
            optimizados = this.localOptimizer.optimize(mejores);
            this.cset.removeAll(mejores);
            this.cset.addAll(optimizados);
        }
    }

    @Override
    protected void doUpdate() {
        int numIndividuals = this.bset.size();
        if (this.cset.size() < numIndividuals) {
            this.cset.addAll(this.bettersSelector.select(this.bset, numIndividuals - this.cset.size()));
        } else if (this.cset.size() == numIndividuals) {
            IIndividual bestIndividual = (IIndividual)this.bettersSelector.select(this.bset, 1).get(0);
            IIndividual worstIndividual = (IIndividual)this.worsesSelector.select(this.cset, 1).get(0);
            this.cset.remove(worstIndividual);
            this.cset.add(bestIndividual);
        }
        this.bset = this.cset;
        this.pset = null;
        this.rset = null;
        this.cset = null;
    }
}

