/*
 * Decompiled with CFR 0.152.
 */
package javolution.xml.sax;

import java.io.IOException;
import java.io.Writer;
import javolution.lang.Reusable;
import javolution.lang.Text;
import javolution.util.FastTable;
import javolution.xml.sax.Attributes;
import javolution.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class WriterHandler
implements ContentHandler,
Reusable {
    private static final int BUFFER_LENGTH = 2048;
    private Writer _writer;
    private CharSequence _prolog = Text.EMPTY;
    private CharSequence _indent = Text.EMPTY;
    private FastTable _prefixMappings = new FastTable();
    private int _nesting = -1;
    private boolean _isTagOpen;
    private final char[] _buffer = new char[2048];
    private int _index;

    public WriterHandler setWriter(Writer writer) {
        this._writer = writer;
        return this;
    }

    public void setIndent(CharSequence charSequence) {
        this._indent = charSequence;
    }

    public void setProlog(CharSequence charSequence) {
        this._prolog = charSequence;
    }

    public void reset() {
        this._writer = null;
        this._indent = Text.EMPTY;
        this._prolog = Text.EMPTY;
        this._prefixMappings.clear();
        this._nesting = -1;
        this._isTagOpen = false;
        this._index = 0;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
        if (this._writer == null) {
            throw new SAXException("Writer not set");
        }
        try {
            this.writeNoEscape(this._prolog);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.flushBuffer();
            this._writer.close();
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void startPrefixMapping(CharSequence charSequence, CharSequence charSequence2) throws SAXException {
        this._prefixMappings.addLast(charSequence);
        this._prefixMappings.addLast(charSequence2);
    }

    public void endPrefixMapping(CharSequence charSequence) throws SAXException {
    }

    public void startElement(CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3, Attributes attributes) throws SAXException {
        try {
            if (this._isTagOpen) {
                this.writeNoEscape(">\n");
                this._isTagOpen = false;
            }
            ++this._nesting;
            this.indent();
            this.writeNoEscape('<');
            this.writeNoEscape(charSequence3);
            if (this._prefixMappings.size() > 0) {
                this.writeNamespaces();
            }
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                CharSequence charSequence4 = attributes.getQName(i);
                CharSequence charSequence5 = attributes.getValue(i);
                this.writeNoEscape(' ');
                this.writeNoEscape(charSequence4);
                this.writeNoEscape('=');
                this.writeNoEscape('\"');
                this.write(charSequence5);
                this.writeNoEscape('\"');
            }
            this._isTagOpen = true;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    private void indent() throws IOException {
        int n = this._indent.length();
        if (n > 0) {
            for (int i = 0; i < this._nesting; ++i) {
                this.writeNoEscape(this._indent);
            }
        }
    }

    private void writeNamespaces() throws IOException {
        int n = 0;
        int n2 = this._prefixMappings.size();
        while (n < n2) {
            CharSequence charSequence = (CharSequence)this._prefixMappings.get(n++);
            CharSequence charSequence2 = (CharSequence)this._prefixMappings.get(n++);
            if (charSequence.length() == 0) {
                this.writeNoEscape(" xmlns=\"");
                this.write(charSequence2);
                this.writeNoEscape('\"');
                continue;
            }
            this.writeNoEscape(" xmlns:");
            this.writeNoEscape(charSequence);
            this.writeNoEscape('=');
            this.writeNoEscape('\"');
            this.write(charSequence2);
            this.writeNoEscape('\"');
        }
        this._prefixMappings.clear();
    }

    public void endElement(CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3) throws SAXException {
        try {
            if (this._isTagOpen) {
                this.writeNoEscape("/>\n");
                this._isTagOpen = false;
            } else {
                this.indent();
                this.writeNoEscape('<');
                this.writeNoEscape('/');
                this.writeNoEscape(charSequence3);
                this.writeNoEscape('>');
                this.writeNoEscape('\n');
            }
            --this._nesting;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        try {
            if (this._isTagOpen) {
                this.writeNoEscape('>');
                this._isTagOpen = false;
            }
            this.writeNoEscape("<![CDATA[");
            this.flushBuffer();
            this._writer.write(cArray, n, n2);
            this.writeNoEscape("]]>\n");
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void processingInstruction(CharSequence charSequence, CharSequence charSequence2) throws SAXException {
    }

    public void skippedEntity(CharSequence charSequence) throws SAXException {
    }

    private void write(Object object) throws IOException {
        if (object instanceof String) {
            this.write((String)object);
        } else {
            this.writeNonString((CharSequence)object);
        }
    }

    private void write(String string) throws IOException {
        int n = string.length();
        int n2 = 0;
        block7: while (n2 < n) {
            char c;
            if ((c = string.charAt(n2++)) >= '@' || c == ' ') {
                this._buffer[this._index] = c;
                if (++this._index != 2048) continue;
                this.flushBuffer();
                continue;
            }
            switch (c) {
                case '<': {
                    this.writeNoEscape("&lt;");
                    continue block7;
                }
                case '>': {
                    this.writeNoEscape("&gt;");
                    continue block7;
                }
                case '\'': {
                    this.writeNoEscape("&apos;");
                    continue block7;
                }
                case '\"': {
                    this.writeNoEscape("&quot;");
                    continue block7;
                }
                case '&': {
                    this.writeNoEscape("&amp;");
                    continue block7;
                }
            }
            if (c >= ' ') {
                this.writeNoEscape(c);
                continue;
            }
            this.writeNoEscape("&#");
            this.writeNoEscape((char)(48 + c / 10));
            this.writeNoEscape((char)(48 + c % 10));
            this.writeNoEscape(';');
        }
    }

    private void writeNonString(CharSequence charSequence) throws IOException {
        int n = charSequence.length();
        int n2 = 0;
        block7: while (n2 < n) {
            char c;
            if ((c = charSequence.charAt(n2++)) >= '@' || c == ' ') {
                this._buffer[this._index] = c;
                if (++this._index != 2048) continue;
                this.flushBuffer();
                continue;
            }
            switch (c) {
                case '<': {
                    this.writeNoEscape("&lt;");
                    continue block7;
                }
                case '>': {
                    this.writeNoEscape("&gt;");
                    continue block7;
                }
                case '\'': {
                    this.writeNoEscape("&apos;");
                    continue block7;
                }
                case '\"': {
                    this.writeNoEscape("&quot;");
                    continue block7;
                }
                case '&': {
                    this.writeNoEscape("&amp;");
                    continue block7;
                }
            }
            if (c >= ' ') {
                this.writeNoEscape(c);
                continue;
            }
            this.writeNoEscape("&#");
            this.writeNoEscape((char)(48 + c / 10));
            this.writeNoEscape((char)(48 + c % 10));
            this.writeNoEscape(';');
        }
    }

    private void writeNoEscape(Object object) throws IOException {
        if (object instanceof String) {
            this.writeNoEscape((String)object);
        } else {
            this.writeNoEscapeNonString((CharSequence)object);
        }
    }

    private void writeNoEscape(String string) throws IOException {
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            this._buffer[this._index] = string.charAt(n++);
            if (++this._index != 2048) continue;
            this.flushBuffer();
        }
    }

    private void writeNoEscapeNonString(CharSequence charSequence) throws IOException {
        int n = 0;
        int n2 = charSequence.length();
        while (n < n2) {
            this._buffer[this._index] = charSequence.charAt(n++);
            if (++this._index != 2048) continue;
            this.flushBuffer();
        }
    }

    private final void writeNoEscape(char c) throws IOException {
        this._buffer[this._index] = c;
        if (++this._index == 2048) {
            this.flushBuffer();
        }
    }

    private void flushBuffer() throws IOException {
        this._writer.write(this._buffer, 0, this._index);
        this._index = 0;
    }
}

