/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.knowledgeflow;

import java.util.ArrayList;
import java.util.List;
import weka.core.WekaException;
import weka.gui.Perspective;
import weka.gui.knowledgeflow.AbstractGraphicalCommand;
import weka.gui.knowledgeflow.MainKFPerspective;

public class GetPerspectiveNamesGraphicalCommand
extends AbstractGraphicalCommand {
    public static final String GET_PERSPECTIVE_NAMES_KEY = "getPerspectiveNames";
    protected MainKFPerspective m_mainPerspective;

    @Override
    public void setGraphicalEnvironment(Object graphicalEnvironment) {
        super.setGraphicalEnvironment(graphicalEnvironment);
        if (graphicalEnvironment instanceof MainKFPerspective) {
            this.m_mainPerspective = (MainKFPerspective)graphicalEnvironment;
        }
    }

    @Override
    public String getCommandName() {
        return GET_PERSPECTIVE_NAMES_KEY;
    }

    @Override
    public String getCommandDescription() {
        return "Gets the names of of visible Knowledge Flow perspectives";
    }

    public List<String> performCommand(Object ... commandArgs) throws WekaException {
        if (this.m_mainPerspective == null) {
            throw new WekaException("This command cannot be applied in the current graphical environment");
        }
        List<Perspective> perspectives = this.m_mainPerspective.getMainApplication().getPerspectiveManager().getVisiblePerspectives();
        ArrayList<String> result = new ArrayList<String>();
        for (Perspective p : perspectives) {
            if (p.getPerspectiveID().equalsIgnoreCase("knowledgeflow.main")) continue;
            result.add(p.getPerspectiveTitle());
        }
        return result;
    }
}

