## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo = FALSE)

## ----message=FALSE,warning=FALSE----------------------------------------------
require(knitr)
require(formatR)
# Set so that long lines in R will be wrapped:
opts_chunk$set(tidy.opts=list(width.cutoff=40),tidy=TRUE)

## ----out.width="70%", fig.align="center"--------------------------------------
knitr::include_graphics('vignette_fig/survey_table1.png')

## ----out.width="70%", fig.align="center"--------------------------------------
knitr::include_graphics('vignette_fig/survey_table2_rowclustering.png')

## ----echo=FALSE, out.width="70%", fig.align="center"--------------------------
knitr::include_graphics('vignette_fig/survey_table2c_rowclustering_columns.png')

## ----echo=FALSE, out.width="70%", fig.align="center"--------------------------
knitr::include_graphics('vignette_fig/survey_table5_covariates.png')

## ----echo=FALSE, out.width="70%", fig.align="center"--------------------------
knitr::include_graphics('vignette_fig/survey_table5_covariates_column.png')

## ----out.width="70%", fig.align="center"--------------------------------------
knitr::include_graphics('vignette_fig/survey_table3_columnclustering.png')

## ----echo=FALSE, out.width="70%", fig.align="center"--------------------------
knitr::include_graphics('vignette_fig/survey_table3b_columnclustering_rows.png')

## ----echo=FALSE, out.width="70%", fig.align="center"--------------------------
knitr::include_graphics('vignette_fig/survey_table5_covariates_column_only.png')

## ----echo=FALSE, out.width="70%", fig.align="center"--------------------------
knitr::include_graphics('vignette_fig/survey_table5_covariates_column.png')

## ----out.width="70%", fig.align="center"--------------------------------------
knitr::include_graphics('vignette_fig/survey_table4_biclustering.png')

## ----echo=FALSE, out.width="70%", fig.align="center"--------------------------
knitr::include_graphics('vignette_fig/survey_table5_covariates_column.png')

