## ----echo=FALSE, cache=FALSE, eval=TRUE-----------------------------------------------------------------------------------------------------------------------
library(knitr)
library(rmarkdown)
library(ergm)
library(ergm.multi)
options(rmarkdown.html_vignette.check_title = FALSE)
opts_chunk$set(warning= FALSE,message=FALSE, echo=TRUE, cache=TRUE, autodep=TRUE,
concordance=TRUE, error=FALSE, fig.width=7, fig.height=7)
options(width=160)

## ----setup----------------------------------------------------------------------------------------------------------------------------------------------------
library(ergm.sign)

## -------------------------------------------------------------------------------------------------------------------------------------------------------------
data("tribes")

## -------------------------------------------------------------------------------------------------------------------------------------------------------------
summary(tribes)

## -------------------------------------------------------------------------------------------------------------------------------------------------------------
summary(tribes ~ edges + Pos(~ edges) + Neg(~ edges))

## -------------------------------------------------------------------------------------------------------------------------------------------------------------
tribes_sgl <- UnLayer(tribes, color_pos = "green3", color_neg = "red3")
plot(tribes_sgl, edge.col = "col", label = "vertex.names")

## -------------------------------------------------------------------------------------------------------------------------------------------------------------
fit <- ergm(tribes ~ Pos(~ edges) + Neg(~ edges))
summary(fit)

## -------------------------------------------------------------------------------------------------------------------------------------------------------------
triad_fit <- ergm(tribes ~ gwese(0.5, fixed = TRUE, base = "+") + gwesf(0.5, fixed = TRUE, base = "+"))
summary(triad_fit)

## -------------------------------------------------------------------------------------------------------------------------------------------------------------
GoF(fit, nsim = 20)

