## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup, eval=FALSE--------------------------------------------------------
# library(mammalcol)

## ----example1, eval=FALSE, echo=TRUE------------------------------------------
# # define a vector with species to search for
# splist <- c("Tapirus bairdii", "Tapirus pinchaque", "Tapirus terrestris",
#            "Tapirus terrestris",  "Pudu mephistophiles", "Tapirus bairdii")
# 
# # search in database
# search_mammalcol(splist)
# 

## ----example2, eval=FALSE, echo=TRUE------------------------------------------
# # vector with species names and intentional typos
# splist <- c("Tapiru terrestre", "pudu mephistophiles", "tapirus bairdii")
# 
# # search in database
# search_mammalcol(splist)

## ----example3, eval=FALSE, echo=TRUE------------------------------------------
# # write a species name in the function to map it
# mammalmap("Tapirus pinchaque")

## ----eval=FALSE---------------------------------------------------------------
# occ.any <- sp_by_depto(c("Arauca", "Norte de Santander"), type = "any")
# head(occ.any)
# 

## ----eval=FALSE---------------------------------------------------------------
# occ.only <- sp_by_depto(c("Norte de Santander"), type = "only")
# head(occ.only)

## ----eval=FALSE---------------------------------------------------------------
# occ.all <- sp_by_depto(c("Arauca", "Norte de Santander"), type = "all")
# occ.bats <- sp_by_depto(c("Arauca", "Norte de Santander"), type = "all", taxa = "Chiroptera")
# head(occ.bats)
# 

## ----eval=FALSE---------------------------------------------------------------
# citation("mammalcol")
# 

