/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.reification;

import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Supplier;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;

public class PropConditional
extends Propagator<Variable> {
    private final Function<Variable[], Boolean> checker;
    private final Supplier<Constraint[]> constraints;
    public static final Function<Variable[], Boolean> ALL_INSTANTIATED = vars -> Arrays.stream(vars).allMatch(Variable::isInstantiated);
    public static final Function<Variable[], Boolean> ONE_INSTANTIATED = vars -> Arrays.stream(vars).anyMatch(Variable::isInstantiated);

    public PropConditional(Variable[] vars2observe, Function<Variable[], Boolean> checker, Supplier<Constraint[]> constraints) {
        super(vars2observe, (Priority)PropagatorPriority.VERY_SLOW, false);
        this.checker = checker;
        this.constraints = constraints;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (this.checker.apply(this.vars).booleanValue()) {
            this.setPassive();
            this.model.postTemp(this.constraints.get());
        }
    }

    @Override
    public ESat isEntailed() {
        return ESat.TRUE;
    }
}

