/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.rules.multilabel.core;

import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.InstanceInformation;
import com.yahoo.labs.samoa.instances.InstancesHeader;
import com.yahoo.labs.samoa.instances.MultiLabelInstance;
import com.yahoo.labs.samoa.instances.Prediction;
import java.util.Arrays;
import java.util.LinkedList;
import moa.classifiers.MultiLabelLearner;
import moa.classifiers.rules.core.NumericRulePredicate;
import moa.classifiers.rules.core.Utils;
import moa.classifiers.rules.multilabel.attributeclassobservers.AttributeStatisticsObserver;
import moa.classifiers.rules.multilabel.attributeclassobservers.NominalStatisticsObserver;
import moa.classifiers.rules.multilabel.attributeclassobservers.NumericStatisticsObserver;
import moa.classifiers.rules.multilabel.core.AttributeExpansionSuggestion;
import moa.classifiers.rules.multilabel.core.LearningLiteral;
import moa.classifiers.rules.multilabel.core.splitcriteria.MultiLabelSplitCriterion;
import moa.classifiers.rules.multilabel.functions.AMRulesFunction;
import moa.classifiers.rules.multilabel.instancetransformers.InstanceOutputAttributesSelector;
import moa.core.AutoExpandVector;
import moa.core.DoubleVector;
import moa.core.ObjectRepository;
import moa.tasks.TaskMonitor;

public class LearningLiteralRegression
extends LearningLiteral {
    private static final long serialVersionUID = 1L;
    double[] varianceShift;

    public LearningLiteralRegression() {
    }

    public LearningLiteralRegression(int[] outputsToLearn) {
        super(outputsToLearn);
    }

    @Override
    protected double[] getNormalizedErrors(Prediction prediction, Instance instance) {
        double[] errors = new double[this.outputsToLearn.length];
        for (int i = 0; i < this.outputsToLearn.length; ++i) {
            double predY = this.normalizeOutputValue(i, prediction.getVote(this.outputsToLearn[i], 0));
            double trueY = this.normalizeOutputValue(i, instance.valueOutputAttribute(this.outputsToLearn[i]));
            errors[i] = Math.abs(predY - trueY);
        }
        return errors;
    }

    private double normalizeOutputValue(int outputToLearnIndex, double value) {
        double meanY = this.literalStatistics[outputToLearnIndex].getValue(1) / this.literalStatistics[outputToLearnIndex].getValue(0);
        double sdY = Utils.computeSD(this.literalStatistics[outputToLearnIndex].getValue(2), this.literalStatistics[outputToLearnIndex].getValue(1), this.literalStatistics[outputToLearnIndex].getValue(0));
        double normalizedY = 0.0;
        if (sdY > 1.0E-7) {
            normalizedY = (value - meanY) / sdY;
        }
        return normalizedY;
    }

    @Override
    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
    }

    @Override
    public boolean tryToExpand(double splitConfidence, double tieThreshold) {
        boolean shouldSplit = false;
        Object[] bestSplitSuggestions = this.getBestSplitSuggestions(this.splitCriterion);
        double sumMerit = 0.0;
        this.meritPerInput = new double[this.attributesMask.length];
        for (int i = 0; i < bestSplitSuggestions.length; ++i) {
            double merit = bestSplitSuggestions[i].getMerit();
            if (!(merit > 0.0)) continue;
            this.meritPerInput[((AttributeExpansionSuggestion)bestSplitSuggestions[i]).predicate.getAttributeIndex()] = merit;
            sumMerit += merit;
        }
        if (sumMerit == 0.0) {
            this.meritPerInput = null;
        }
        Arrays.sort(bestSplitSuggestions);
        int[] oldInputs = (int[])this.inputsToLearn.clone();
        this.inputsToLearn = this.inputSelector.getNextInputIndices((AttributeExpansionSuggestion[])bestSplitSuggestions);
        Arrays.sort(this.inputsToLearn);
        for (int i = 0; i < oldInputs.length; ++i) {
            if (!this.attributesMask[oldInputs[i]] || Arrays.binarySearch(this.inputsToLearn, oldInputs[i]) >= 0) continue;
            this.attributeObservers.set(oldInputs[i], null);
        }
        if (bestSplitSuggestions.length < 2) {
            this.bestSuggestion = bestSplitSuggestions[bestSplitSuggestions.length - 1];
            shouldSplit = true;
        } else {
            double hoeffdingBound = LearningLiteralRegression.computeHoeffdingBound(this.splitCriterion.getRangeOfMerit(this.literalStatistics), splitConfidence, this.weightSeen);
            this.bestSuggestion = bestSplitSuggestions[bestSplitSuggestions.length - 1];
            Object secondBestSuggestion = bestSplitSuggestions[bestSplitSuggestions.length - 2];
            if (this.bestSuggestion.merit - ((AttributeExpansionSuggestion)secondBestSuggestion).merit > hoeffdingBound || hoeffdingBound < tieThreshold) {
                shouldSplit = true;
            }
        }
        if (shouldSplit) {
            DoubleVector[] newLiteralStatistics;
            DoubleVector[][] resultingStatistics = this.bestSuggestion.getResultingNodeStatistics();
            double[] branchMerits = this.splitCriterion.getBranchesSplitMerits(resultingStatistics);
            if (branchMerits[1] > branchMerits[0]) {
                this.bestSuggestion.getPredicate().negateCondition();
                newLiteralStatistics = this.getBranchStatistics(resultingStatistics, 1);
            } else {
                newLiteralStatistics = this.getBranchStatistics(resultingStatistics, 0);
            }
            int[] newOutputs = this.outputSelector.getNextOutputIndices(newLiteralStatistics, this.literalStatistics, this.outputsToLearn);
            Arrays.sort(newOutputs);
            this.otherBranchLearningLiteral = new LearningLiteralRegression();
            this.otherBranchLearningLiteral.instanceHeader = this.instanceHeader;
            this.otherBranchLearningLiteral.learner = (MultiLabelLearner)this.learner.copy();
            this.otherBranchLearningLiteral.instanceTransformer = this.instanceTransformer;
            if (this.learner instanceof AMRulesFunction) {
                if (newOutputs.length != this.outputsToLearn.length) {
                    int[] indices;
                    int[] otherOutputs = Utils.complementSet(this.outputsToLearn, newOutputs);
                    if (otherOutputs.length > 0) {
                        this.otherOutputsLearningLiteral = new LearningLiteralRegression(otherOutputs);
                        MultiLabelLearner otherOutputsLearner = (MultiLabelLearner)this.learner.copy();
                        indices = Utils.getIndexCorrespondence(this.outputsToLearn, otherOutputs);
                        ((AMRulesFunction)((Object)otherOutputsLearner)).selectOutputsToLearn(indices);
                        ((AMRulesFunction)((Object)otherOutputsLearner)).resetWithMemory();
                        this.otherOutputsLearningLiteral.learner = otherOutputsLearner;
                        this.otherOutputsLearningLiteral.instanceHeader = this.instanceHeader;
                        this.otherOutputsLearningLiteral.instanceTransformer = new InstanceOutputAttributesSelector(this.instanceHeader, otherOutputs);
                    }
                    indices = Utils.getIndexCorrespondence(this.outputsToLearn, newOutputs);
                    ((AMRulesFunction)((Object)this.learner)).selectOutputsToLearn(indices);
                }
                ((AMRulesFunction)((Object)this.learner)).resetWithMemory();
            } else {
                int[] otherOutputs;
                if (newOutputs.length != this.outputsToLearn.length && (otherOutputs = Utils.complementSet(this.outputsToLearn, newOutputs)).length > 0) {
                    this.otherOutputsLearningLiteral = new LearningLiteralRegression();
                    MultiLabelLearner otherOutputsLearner = (MultiLabelLearner)this.learner.copy();
                    otherOutputsLearner.resetLearning();
                    this.otherOutputsLearningLiteral.learner = otherOutputsLearner;
                    this.otherOutputsLearningLiteral.instanceHeader = this.instanceHeader;
                    this.otherOutputsLearningLiteral.instanceTransformer = new InstanceOutputAttributesSelector(this.instanceHeader, otherOutputs);
                }
                this.learner.resetLearning();
            }
            this.expandedLearningLiteral = new LearningLiteralRegression(newOutputs);
            this.expandedLearningLiteral.learner = (MultiLabelLearner)this.learner.copy();
            this.expandedLearningLiteral.instanceHeader = this.instanceHeader;
            this.expandedLearningLiteral.instanceTransformer = new InstanceOutputAttributesSelector(this.instanceHeader, newOutputs);
        }
        return shouldSplit;
    }

    private DoubleVector[] getBranchStatistics(DoubleVector[][] resultingStatistics, int indexBranch) {
        DoubleVector[] selBranchStats = new DoubleVector[resultingStatistics.length];
        for (int i = 0; i < resultingStatistics.length; ++i) {
            selBranchStats[i] = resultingStatistics[i][indexBranch];
        }
        return selBranchStats;
    }

    private AttributeExpansionSuggestion[] getBestSplitSuggestions(MultiLabelSplitCriterion criterion) {
        LinkedList<AttributeExpansionSuggestion> bestSuggestions = new LinkedList<AttributeExpansionSuggestion>();
        for (int i = 0; i < this.inputsToLearn.length; ++i) {
            AttributeStatisticsObserver obs;
            if (!this.attributesMask[this.inputsToLearn[i]] || (obs = (AttributeStatisticsObserver)this.attributeObservers.get(this.inputsToLearn[i])) == null) continue;
            AttributeExpansionSuggestion bestSuggestion = obs.getBestEvaluatedSplitSuggestion(criterion, this.literalStatistics, this.inputsToLearn[i]);
            if (bestSuggestion == null) {
                bestSuggestion = new AttributeExpansionSuggestion(new NumericRulePredicate(this.inputsToLearn[i], 0.0, true), null, -1.7976931348623157E308);
            }
            bestSuggestions.add(bestSuggestion);
        }
        return bestSuggestions.toArray(new AttributeExpansionSuggestion[bestSuggestions.size()]);
    }

    @Override
    public void trainOnInstance(MultiLabelInstance instance) {
        int i;
        int numInputs = 0;
        if (this.attributesMask == null) {
            numInputs = this.initializeAttibutesMask(instance);
        }
        int numOutputs = instance.numberOutputTargets();
        if (!this.hasStarted) {
            int i2;
            if (this.learner.isRandomizable()) {
                this.learner.setRandomSeed(this.randomGenerator.nextInt());
            }
            if (this.outputsToLearn == null) {
                this.outputsToLearn = new int[numOutputs];
                for (i2 = 0; i2 < numOutputs; ++i2) {
                    this.outputsToLearn[i2] = i2;
                }
            }
            if (this.inputsToLearn == null) {
                this.inputsToLearn = new int[numInputs];
                int ct = 0;
                for (int i3 = 0; i3 < instance.numInputAttributes(); ++i3) {
                    if (!this.attributesMask[i3]) continue;
                    this.inputsToLearn[ct] = i3;
                    ++ct;
                }
            }
            this.literalStatistics = new DoubleVector[this.outputsToLearn.length];
            this.varianceShift = new double[this.outputsToLearn.length];
            for (i2 = 0; i2 < this.outputsToLearn.length; ++i2) {
                this.literalStatistics[i2] = new DoubleVector(new double[5]);
                this.varianceShift[i2] = instance.valueOutputAttribute(this.outputsToLearn[i2]);
            }
            this.instanceHeader = (InstancesHeader)instance.dataset();
            this.hasStarted = true;
        }
        double weight = instance.weight();
        DoubleVector[] exampleStatistics = new DoubleVector[this.outputsToLearn.length];
        for (i = 0; i < this.outputsToLearn.length; ++i) {
            double target = instance.valueOutputAttribute(this.outputsToLearn[i]);
            double sum = weight * target;
            double squaredSum = weight * target * target;
            double sumShifted = weight * target - this.varianceShift[i];
            double squaredSumShifted = weight * (target - this.varianceShift[i]) * (target - this.varianceShift[i]);
            exampleStatistics[i] = new DoubleVector(new double[]{weight, sum, squaredSum, sumShifted, squaredSumShifted});
            this.literalStatistics[i].addValues(exampleStatistics[i].getArrayRef());
        }
        if (this.attributeObservers == null) {
            this.attributeObservers = new AutoExpandVector();
        }
        for (i = 0; i < this.inputsToLearn.length; ++i) {
            if (!this.attributesMask[this.inputsToLearn[i]]) continue;
            AttributeStatisticsObserver obs = (AttributeStatisticsObserver)this.attributeObservers.get(this.inputsToLearn[i]);
            if (obs == null) {
                if (instance.attribute(this.inputsToLearn[i]).isNumeric()) {
                    obs = (NumericStatisticsObserver)this.numericStatisticsObserver.copy();
                } else if (instance.attribute(this.inputsToLearn[i]).isNominal()) {
                    obs = (NominalStatisticsObserver)this.nominalStatisticsObserver.copy();
                }
                this.attributeObservers.set(this.inputsToLearn[i], obs);
            }
            obs.observeAttribute(instance.valueInputAttribute(this.inputsToLearn[i]), exampleStatistics);
        }
        Instance transformedInstance = this.instanceTransformer.sourceInstanceToTarget(instance);
        Prediction prediction = null;
        Prediction targetPrediction = this.learner.getPredictionForInstance(transformedInstance);
        if (targetPrediction != null) {
            prediction = this.instanceTransformer.targetPredictionToSource(targetPrediction);
        }
        if (prediction != null) {
            this.errorMeasurer.addPrediction(prediction, instance);
        }
        this.learner.trainOnInstance(transformedInstance);
        this.weightSeen += instance.weight();
    }

    @Override
    public String getStaticOutput(InstanceInformation instanceInformation) {
        StringBuffer sb = new StringBuffer();
        if (this.literalStatistics != null) {
            for (int i = 0; i < this.literalStatistics.length; ++i) {
                sb.append(instanceInformation.outputAttribute(this.outputsToLearn[i]).name() + ": " + this.literalStatistics[i].getValue(1) / this.literalStatistics[i].getValue(0) + " ");
            }
        }
        return sb.toString();
    }
}

