## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(yaml)

## -----------------------------------------------------------------------------
yaml.load("
- 1
- 2
- 3
")

## -----------------------------------------------------------------------------
yaml.load("1.2345")
yaml.load("true")
yaml.load("hello")

## -----------------------------------------------------------------------------
# Uniform sequence -> vector
yaml.load("
- 1
- 2
- 3
")

# Mixed sequence -> list
yaml.load("
- 1
- hello
- true
")

## -----------------------------------------------------------------------------
yaml.load("
one: 1
two: 2
three: 3
")

## -----------------------------------------------------------------------------
yaml.load("
1: one
2: two
", as.named.list = FALSE)

## -----------------------------------------------------------------------------
# Add 100 to all integers
yaml.load("123", handlers = list(int = function(x) as.integer(x) + 100))

## -----------------------------------------------------------------------------
yaml.load("
- 1
- 2
- 3
", handlers = list(seq = function(x) sum(as.numeric(x))))

## -----------------------------------------------------------------------------
yaml.load("
a:
- 1
- 2
b:
- 3
- 4
", handlers = list(map = function(x) as.data.frame(x)))

## -----------------------------------------------------------------------------
cat(as.yaml(1:5))

## -----------------------------------------------------------------------------
cat(as.yaml(list(foo = list(bar = "baz")), indent = 4))

## -----------------------------------------------------------------------------
cat(as.yaml(list(foo = 1:3)))

## -----------------------------------------------------------------------------
cat(as.yaml(list(foo = 1:3), indent.mapping.sequence = TRUE))

## -----------------------------------------------------------------------------
x <- data.frame(a = 1:2, b = 3:4)
cat(as.yaml(x, column.major = TRUE))

## -----------------------------------------------------------------------------
cat(as.yaml(x, column.major = FALSE))

## -----------------------------------------------------------------------------
cat(as.yaml(
  Sys.Date(),
  handlers = list(Date = function(x) format(x, "%Y/%m/%d"))
))

## -----------------------------------------------------------------------------
cat(as.yaml(c(TRUE, FALSE), handlers = list(logical = verbatim_logical)))

## -----------------------------------------------------------------------------
result <- c("true", "false")
class(result) <- "verbatim"
cat(as.yaml(result))

## -----------------------------------------------------------------------------
port <- "80:80"
attr(port, "quoted") <- TRUE
cat(as.yaml(list(ports = list(port))))

## -----------------------------------------------------------------------------
x <- 1:3
attr(x, "tag") <- "!custom"
cat(as.yaml(x))

