/*
 * Decompiled with CFR 0.152.
 */
package dr.evoxml;

import dr.evolution.util.Date;
import dr.evolution.util.Location;
import dr.evolution.util.Taxon;
import dr.util.Attribute;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.StringAttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class TaxonParser
extends AbstractXMLObjectParser {
    public static final String TAXON = "taxon";
    private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new StringAttributeRule("id", "A unique identifier for this taxon"), new ElementRule(Attribute.Default.class, true), new ElementRule(Date.class, true), new ElementRule(Location.class, true)};

    @Override
    public String getParserName() {
        return TAXON;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        if ("id".contains("'") && "id".contains("\"")) {
            throw new XMLParseException("Illegal taxon name, id, - contains both single and double quotes");
        }
        Taxon taxon = new Taxon(xMLObject.getStringAttribute("id"));
        for (int i = 0; i < xMLObject.getChildCount(); ++i) {
            Attribute[] attributeArray;
            Object object = xMLObject.getChild(i);
            if (object instanceof Date) {
                taxon.setDate((Date)object);
                continue;
            }
            if (object instanceof Location) {
                taxon.setLocation((Location)object);
                continue;
            }
            if (object instanceof Attribute) {
                attributeArray = (Attribute[])object;
                taxon.setAttribute(attributeArray.getAttributeName(), attributeArray.getAttributeValue());
                continue;
            }
            if (object instanceof Attribute[]) {
                for (Attribute attribute : attributeArray = (Attribute[])object) {
                    taxon.setAttribute(attribute.getAttributeName(), attribute.getAttributeValue());
                }
                continue;
            }
            throw new XMLParseException("Unrecognized element found in taxon element");
        }
        return taxon;
    }

    @Override
    public String getParserDescription() {
        return "";
    }

    @Override
    public Class getReturnType() {
        return Taxon.class;
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return this.rules;
    }
}

