/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.markovjumps;

import dr.evolution.datatype.DataType;
import dr.inference.markovjumps.StateChange;
import dr.math.MathUtils;
import java.util.ArrayList;
import java.util.List;

public class StateHistory {
    private int stateCount;
    private List<StateChange> stateList = new ArrayList<StateChange>();
    private boolean finalized;
    private boolean isFiltered = false;

    protected StateHistory(double d, int n, int n2) {
        this.stateList.add(new StateChange(d, n));
        this.stateCount = n2;
        this.finalized = false;
    }

    public void addChange(StateChange stateChange) {
        this.checkFinalized(false);
        this.stateList.add(stateChange);
    }

    public void addEndingState(StateChange stateChange) {
        this.checkFinalized(false);
        this.stateList.add(stateChange);
        this.finalized = true;
    }

    public int[] getJumpCounts() {
        int[] nArray = new int[this.stateCount * this.stateCount];
        this.accumulateSufficientStatistics(nArray, null);
        return nArray;
    }

    public double[] getWaitingTimes() {
        double[] dArray = new double[this.stateCount];
        this.accumulateSufficientStatistics(null, dArray);
        return dArray;
    }

    public double getTotalRegisteredCounts(double[] dArray) {
        int[] nArray = this.getJumpCounts();
        return this.dotProduct(nArray, dArray);
    }

    private double dotProduct(int[] nArray, double[] dArray) {
        double d = 0.0;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            d += (double)nArray[i] * dArray[i];
        }
        return d;
    }

    public double getTotalReward(double[] dArray) {
        double[] dArray2 = this.getWaitingTimes();
        double d = 0.0;
        for (int i = 0; i < dArray2.length; ++i) {
            d += dArray2[i] * dArray[i];
        }
        return d;
    }

    public void accumulateSufficientStatistics(int[] nArray, double[] dArray) {
        this.checkFinalized(true);
        int n = this.getNumberOfJumps();
        StateChange stateChange = this.stateList.get(0);
        int n2 = stateChange.getState();
        double d = stateChange.getTime();
        for (int i = 1; i <= n; ++i) {
            StateChange stateChange2 = this.stateList.get(i);
            int n3 = stateChange2.getState();
            double d2 = stateChange2.getTime();
            if (nArray != null) {
                int n4 = n2 * this.stateCount + n3;
                nArray[n4] = nArray[n4] + 1;
            }
            if (dArray != null) {
                int n5 = n2;
                dArray[n5] = dArray[n5] + (d2 - d);
            }
            n2 = n3;
            d = d2;
        }
        if (dArray != null) {
            StateChange stateChange3 = this.stateList.get(n + 1);
            int n6 = n2;
            dArray[n6] = dArray[n6] + (stateChange3.getTime() - d);
        }
    }

    public int getNumberOfJumps() {
        this.checkFinalized(true);
        return this.stateList.size() - 2;
    }

    private void checkFinalized(boolean bl) {
        if (bl != this.finalized) {
            throw new IllegalAccessError("StateHistory " + (this.finalized ? "is" : "is not finalized"));
        }
    }

    public int getStartingState() {
        return this.stateList.get(0).getState();
    }

    public int getEndingState() {
        this.checkFinalized(true);
        return this.stateList.get(this.stateList.size() - 1).getState();
    }

    public double getStartingTime() {
        return this.stateList.get(0).getTime();
    }

    public double getEndingTime() {
        this.checkFinalized(true);
        return this.stateList.get(this.stateList.size() - 1).getTime();
    }

    public void rescaleTimesOfEvents(double d, double d2) {
        double d3 = (d2 - d) / (this.getEndingTime() - this.getStartingTime());
        StateChange stateChange = this.stateList.get(0);
        double d4 = stateChange.getTime();
        stateChange.setTime(d);
        double d5 = d;
        for (int i = 1; i < this.stateList.size(); ++i) {
            StateChange stateChange2 = this.stateList.get(i);
            double d6 = stateChange2.getTime();
            double d7 = d6 - d4;
            double d8 = d7 * d3 + d5;
            stateChange2.setTime(d8);
            d4 = d6;
            d5 = d8;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[");
        for (int i = 0; i < this.stateList.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(this.stateList.get(i));
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        System.err.println("Testing time rescaling:");
        StateHistory stateHistory = new StateHistory(1.0, 1, 4);
        StateChange stateChange = new StateChange(2.0, 2);
        stateHistory.addChange(stateChange);
        stateChange = new StateChange(5.0, 2);
        stateHistory.addEndingState(stateChange);
        System.err.println("Initial history: " + stateHistory);
        stateHistory.rescaleTimesOfEvents(8.0, 0.0);
        System.err.println("Rescale history: " + stateHistory);
        stateHistory.rescaleTimesOfEvents(0.0, 4.0);
        System.err.println("Rescale history: " + stateHistory);
    }

    public StateHistory filterChanges(double[] dArray) {
        if (this.getNumberOfJumps() == 0) {
            return this;
        }
        StateChange stateChange = this.stateList.get(0);
        StateHistory stateHistory = new StateHistory(stateChange.getTime(), stateChange.getState(), this.stateCount);
        for (int i = 1; i < this.stateList.size() - 1; ++i) {
            StateChange stateChange2 = this.stateList.get(i);
            if (dArray[stateChange.getState() * this.stateCount + stateChange2.getState()] == 1.0) {
                stateChange2 = stateChange2.clone();
                stateChange2.setPreviousState(stateChange.getState());
                stateHistory.addChange(stateChange2);
            }
            stateChange = stateChange2;
        }
        stateHistory.addEndingState(this.stateList.get(this.stateList.size() - 1));
        this.isFiltered = true;
        return stateHistory;
    }

    public double getLogLikelihood(double[] dArray, int n) {
        int n2;
        this.checkFinalized(true);
        double d = 0.0;
        int n3 = this.getNumberOfJumps();
        int n4 = this.stateList.get(0).getState();
        double d2 = this.stateList.get(0).getTime();
        for (n2 = 1; n2 < n3; ++n2) {
            int n5 = this.stateList.get(n2).getState();
            double d3 = this.stateList.get(n2).getTime();
            d += Math.log(dArray[n4 * n + n5]) + dArray[n4 * n + n4] * (d3 - d2);
            n4 = n5;
            d2 = d3;
        }
        n2 = this.stateList.get(this.stateList.size() - 1).getState();
        double d4 = this.stateList.get(this.stateList.size() - 1).getTime();
        assert (n2 == n4);
        assert (d4 >= d2);
        return d += dArray[n4 * n + n4] * (d4 - d2);
    }

    public String toStringChanges(int n, DataType dataType) {
        return this.toStringChanges(n, dataType, true);
    }

    public String toStringChanges(int n, DataType dataType, boolean bl) {
        StringBuilder stringBuilder = bl ? new StringBuilder("{") : new StringBuilder();
        int n2 = this.stateList.get(0).getState();
        boolean bl2 = true;
        for (int i = 1; i < this.stateList.size() - 1; ++i) {
            int n3 = this.stateList.get(i).getState();
            if (this.isFiltered) {
                n2 = this.stateList.get(i).getPreviousState();
            }
            if (n3 == n2) continue;
            if (!bl2) {
                stringBuilder.append(",");
            }
            double d = this.stateList.get(i).getTime();
            StateHistory.addEventToStringBuilder(stringBuilder, dataType.getCode(n2), dataType.getCode(n3), d, n);
            bl2 = false;
            n2 = n3;
        }
        if (bl) {
            stringBuilder.append("}");
        }
        return stringBuilder.toString();
    }

    public static void addEventToStringBuilder(StringBuilder stringBuilder, String string, String string2, double d, int n) {
        stringBuilder.append("{");
        if (n > 0) {
            stringBuilder.append(n).append(",");
        }
        stringBuilder.append(d).append(",").append(string).append(",").append(string2).append("}");
    }

    public static StateHistory simulateConditionalOnEndingState(double d, int n, double d2, int n2, double[] dArray, int n3) {
        throw new RuntimeException("Impossible to simulate a conditioned CTMC in StateHistory");
    }

    public static StateHistory simulateUnconditionalOnEndingState(double d, int n, double d2, double[] dArray, int n2) {
        StateHistory stateHistory = new StateHistory(d, n, n2);
        double[] dArray2 = new double[n2];
        double d3 = d;
        int n3 = n;
        while (d3 < d2) {
            double d4 = -dArray[n3 * n2 + n3];
            double d5 = MathUtils.nextExponential(d4);
            if (!((d3 += d5) < d2)) continue;
            System.arraycopy(dArray, n3 * n2, dArray2, 0, n2);
            dArray2[n3] = 0.0;
            n3 = MathUtils.randomChoicePDF(dArray2);
            stateHistory.addChange(new StateChange(d3, n3));
        }
        stateHistory.addEndingState(new StateChange(d2, n3));
        return stateHistory;
    }
}

