/*
 * Decompiled with CFR 0.152.
 */
package dr.util;

import dr.util.LKJCholeskyTransformConstrained;
import dr.util.LKJCholeskyTransformConstrainedWithDiag;
import dr.util.LKJTransformConstrained;
import dr.util.Transform;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;
import java.util.Arrays;

public class LKJTransformParser
extends AbstractXMLObjectParser {
    public static final String NAME = "LKJTransform";
    public static final String DIMENSION = "dimension";
    private static final String CHOLESKY = "cholesky";
    public static final String WITH_DIAGONALS = "withDiagonals";

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        int n = xMLObject.getIntegerAttribute(DIMENSION);
        int n2 = n * (n - 1) / 2;
        Transform.Array array = new Transform.Array(Transform.FISHER_Z, n2, null);
        boolean bl = xMLObject.getAttribute(CHOLESKY, true);
        LKJCholeskyTransformConstrained lKJCholeskyTransformConstrained = bl ? new LKJCholeskyTransformConstrained(n) : new LKJTransformConstrained(n);
        boolean bl2 = xMLObject.getAttribute(WITH_DIAGONALS, false);
        if (!bl2) {
            return new Transform.ComposeMultivariable(array, lKJCholeskyTransformConstrained);
        }
        if (!bl) {
            throw new RuntimeException("Not yet implemented");
        }
        LKJCholeskyTransformConstrainedWithDiag lKJCholeskyTransformConstrainedWithDiag = new LKJCholeskyTransformConstrainedWithDiag(n);
        Transform.Array array2 = new Transform.Array(Transform.LOG, n, null);
        Transform.MultivariateArray multivariateArray = new Transform.MultivariateArray(new ArrayList<Transform.MultivariableTransform>(Arrays.asList(array, array2)));
        Transform.ComposeMultivariable composeMultivariable = new Transform.ComposeMultivariable(multivariateArray, lKJCholeskyTransformConstrainedWithDiag);
        return composeMultivariable;
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return new XMLSyntaxRule[]{AttributeRule.newIntegerRule(DIMENSION, false), AttributeRule.newBooleanRule(CHOLESKY, true)};
    }

    @Override
    public String getParserDescription() {
        return "Returns a LKJ Transformation from correlation matrix to unconstrained values";
    }

    @Override
    public Class getReturnType() {
        return Transform.ComposeMultivariable.class;
    }

    @Override
    public String getParserName() {
        return NAME;
    }
}

