/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random.tdouble;

import cern.jet.random.tdouble.AbstractContinousDoubleDistribution;
import cern.jet.random.tdouble.engine.DoubleRandomEngine;

public class Hyperbolic
extends AbstractContinousDoubleDistribution {
    private static final long serialVersionUID = 1L;
    protected double alpha;
    protected double beta;
    protected double a_setup = 0.0;
    protected double b_setup = -1.0;
    protected double x;
    protected double u;
    protected double v;
    protected double e;
    protected double hr;
    protected double hl;
    protected double s;
    protected double pm;
    protected double pr;
    protected double samb;
    protected double pmr;
    protected double mpa_1;
    protected double mmb_1;
    protected static Hyperbolic shared = new Hyperbolic(10.0, 10.0, Hyperbolic.makeDefaultGenerator());

    public Hyperbolic(double d, double d2, DoubleRandomEngine doubleRandomEngine) {
        this.setRandomGenerator(doubleRandomEngine);
        this.setState(d, d2);
    }

    public double nextDouble() {
        return this.nextDouble(this.alpha, this.beta);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double nextDouble(double d, double d2) {
        double d3 = d;
        double d4 = d2;
        if (this.a_setup != d3 || this.b_setup != d4) {
            double d5 = d3 * d3 - d4 * d4;
            this.samb = Math.sqrt(d5);
            double d6 = d4 / this.samb;
            double d7 = d3 * Math.sqrt(2.0 * this.samb + 1.0);
            double d8 = d4 * (this.samb + 1.0);
            double d9 = (d8 + d7) / d5;
            double d10 = (d8 - d7) / d5;
            double d11 = d9 - d6;
            double d12 = -d10 + d6;
            this.hr = -1.0 / (-d3 * d9 / Math.sqrt(1.0 + d9 * d9) + d4);
            this.hl = 1.0 / (-d3 * d10 / Math.sqrt(1.0 + d10 * d10) + d4);
            double d13 = d11 - this.hr;
            double d14 = d12 - this.hl;
            this.mmb_1 = d6 - d14;
            this.mpa_1 = d6 + d13;
            this.s = d11 + d12;
            this.pm = (d13 + d14) / this.s;
            this.pr = this.hr / this.s;
            this.pmr = this.pm + this.pr;
            this.a_setup = d3;
            this.b_setup = d4;
        }
        while (true) {
            this.u = this.randomGenerator.raw();
            this.v = this.randomGenerator.raw();
            if (this.u <= this.pm) {
                this.x = this.mmb_1 + this.u * this.s;
                if (!(Math.log(this.v) <= -d3 * Math.sqrt(1.0 + this.x * this.x) + d4 * this.x + this.samb)) continue;
                return this.x;
            }
            if (this.u <= this.pmr) {
                this.e = -Math.log((this.u - this.pm) / this.pr);
                this.x = this.mpa_1 + this.hr * this.e;
                if (!(Math.log(this.v) - this.e <= -d3 * Math.sqrt(1.0 + this.x * this.x) + d4 * this.x + this.samb)) continue;
                return this.x;
            }
            this.e = Math.log((this.u - this.pmr) / (1.0 - this.pmr));
            this.x = this.mmb_1 + this.hl * this.e;
            if (Math.log(this.v) + this.e <= -d3 * Math.sqrt(1.0 + this.x * this.x) + d4 * this.x + this.samb) return this.x;
        }
    }

    public void setState(double d, double d2) {
        this.alpha = d;
        this.beta = d2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double staticNextDouble(double d, double d2) {
        Hyperbolic hyperbolic = shared;
        synchronized (hyperbolic) {
            return shared.nextDouble(d, d2);
        }
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.alpha + "," + this.beta + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void xstaticSetRandomGenerator(DoubleRandomEngine doubleRandomEngine) {
        Hyperbolic hyperbolic = shared;
        synchronized (hyperbolic) {
            shared.setRandomGenerator(doubleRandomEngine);
        }
    }
}

