/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Preprocess.Instance_Selection.AllKNN;

import java.util.StringTokenizer;
import keel.Algorithms.Preprocess.Basic.KNN;
import keel.Algorithms.Preprocess.Basic.Metodo;
import keel.Algorithms.Preprocess.Basic.OutputIS;
import org.core.Fichero;

public class AllKNN
extends Metodo {
    private int k;

    public AllKNN(String ficheroScript) {
        super(ficheroScript);
    }

    public void ejecutar() {
        int j;
        int i;
        int nSel = 0;
        long tiempo = System.currentTimeMillis();
        boolean[] marcas = new boolean[this.datosTrain.length];
        for (i = 0; i < this.datosTrain.length; ++i) {
            marcas[i] = true;
        }
        nSel = this.datosTrain.length;
        int nClases = 0;
        for (i = 0; i < this.clasesTrain.length; ++i) {
            if (this.clasesTrain[i] <= nClases) continue;
            nClases = this.clasesTrain[i];
        }
        ++nClases;
        for (i = 0; i < this.datosTrain.length; ++i) {
            for (j = 1; j <= this.k && marcas[i]; ++j) {
                int claseObt = KNN.evaluacionKNN2(j, this.datosTrain, this.realTrain, this.nominalTrain, this.nulosTrain, this.clasesTrain, this.datosTrain[i], this.realTrain[i], this.nominalTrain[i], this.nulosTrain[i], nClases, this.distanceEu);
                if (claseObt == this.clasesTrain[i]) continue;
                marcas[i] = false;
                --nSel;
            }
        }
        double[][] conjS = new double[nSel][this.datosTrain[0].length];
        double[][] conjR = new double[nSel][this.datosTrain[0].length];
        int[][] conjN = new int[nSel][this.datosTrain[0].length];
        boolean[][] conjM = new boolean[nSel][this.datosTrain[0].length];
        int[] clasesS = new int[nSel];
        int l = 0;
        for (i = 0; i < this.datosTrain.length; ++i) {
            if (!marcas[i]) continue;
            for (j = 0; j < this.datosTrain[0].length; ++j) {
                conjS[l][j] = this.datosTrain[i][j];
                conjR[l][j] = this.realTrain[i][j];
                conjN[l][j] = this.nominalTrain[i][j];
                conjM[l][j] = this.nulosTrain[i][j];
            }
            clasesS[l] = this.clasesTrain[i];
            ++l;
        }
        System.out.println("AllKNN " + this.relation + " " + (double)(System.currentTimeMillis() - tiempo) / 1000.0 + "s");
        OutputIS.escribeSalida(this.ficheroSalida[0], conjR, conjN, conjM, clasesS, this.entradas, this.salida, this.nEntradas, this.relation);
        OutputIS.escribeSalida(this.ficheroSalida[1], this.test, this.entradas, this.salida, this.nEntradas, this.relation);
    }

    @Override
    public void leerConfiguracion(String ficheroScript) {
        this.ficheroSalida = new String[2];
        String fichero = Fichero.leeFichero(ficheroScript);
        StringTokenizer lineasFichero = new StringTokenizer(fichero, "\n\r");
        lineasFichero.nextToken();
        String linea = lineasFichero.nextToken();
        StringTokenizer tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        String token = tokens.nextToken();
        byte[] line = token.getBytes();
        int i = 0;
        while (line[i] != 34) {
            ++i;
        }
        int j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroTraining = new String(line, i, j - i);
        i = j + 1;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroTest = new String(line, i, j - i);
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        token = tokens.nextToken();
        line = token.getBytes();
        i = 0;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroSalida[0] = new String(line, i, j - i);
        i = j + 1;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.ficheroSalida[1] = new String(line, i, j - i);
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.k = Integer.parseInt(tokens.nextToken().substring(1));
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        this.distanceEu = tokens.nextToken().substring(1).equalsIgnoreCase("Euclidean");
    }
}

