/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Decision_Trees.C45_Binarization;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import keel.Algorithms.Decision_Trees.C45_Binarization.Multiclassifier;
import keel.Algorithms.Decision_Trees.C45_Binarization.OVO;

public class BTS {
    Multiclassifier classifier;
    int nClasses;
    float threshold;
    Node root;
    double[][] averagePerClass;
    double[][] stdPerClass;
    OVO ovo;
    ArrayList<Node> trainedList;

    public BTS(Multiclassifier classifier, float threshold, OVO ovo) {
        this.classifier = classifier;
        this.nClasses = classifier.nClasses;
        this.threshold = threshold;
        this.ovo = ovo;
        classifier.train.computeStatisticsPerClass();
        this.averagePerClass = classifier.train.getAveragePerClass();
        this.stdPerClass = this.classifier.train.getStdPerClass();
        this.trainedList = new ArrayList();
    }

    public void initialize() {
        System.out.println("Initializing BTS");
        this.root = new Node();
        System.out.println("Initialize BTS finished");
    }

    public void construct() {
        Node actualNode = this.root;
        ArrayList<Node> recNodes = new ArrayList<Node>();
        this.trainedList.add(actualNode);
        while (actualNode != null) {
            if (actualNode.classes.size() > 1) {
                double[] dist = this.distances(actualNode);
                TreeMap<Double, ArrayList<Integer>> map = new TreeMap<Double, ArrayList<Integer>>();
                for (int i = 0; i < dist.length; ++i) {
                    ArrayList<Integer> ind = (ArrayList<Integer>)map.get(dist[i]);
                    if (ind == null) {
                        ind = new ArrayList<Integer>();
                        map.put(dist[i], ind);
                    }
                    ind.add(i);
                }
                ArrayList indices = new ArrayList();
                for (List arr : map.values()) {
                    indices.addAll(arr);
                }
                boolean accepted = false;
                for (int p = 0; p < dist.length && !accepted; ++p) {
                    for (int q = p + 1; q < dist.length && !accepted; ++q) {
                        int j;
                        int i = actualNode.classes.get((Integer)indices.get(p));
                        actualNode.i = i < (j = actualNode.classes.get((Integer)indices.get(q)).intValue()) ? i : j;
                        actualNode.j = i >= j ? i : j;
                        actualNode.constructNextNodes();
                        if (actualNode.nextNodes[0].classes.size() < actualNode.classes.size() || actualNode.nextNodes[1].classes.size() < actualNode.classes.size()) {
                            accepted = true;
                        }
                        System.out.println("Nodo actual: " + actualNode.classes.size() + " Nodo 0: " + actualNode.nextNodes[0].classes.size() + " Nodo 1: " + actualNode.nextNodes[1].classes.size() + " accepted = " + accepted);
                    }
                }
                if (!accepted) {
                    System.out.println("Worst situation, nClasses = " + actualNode.classes.size() + " / " + this.classifier.nClasses);
                    actualNode.nextNodes = null;
                } else {
                    if (actualNode.nextNodes[0].classes.size() > 1 && !this.trainedList.contains(actualNode.nextNodes[0])) {
                        recNodes.add(actualNode.nextNodes[0]);
                        this.trainedList.add(actualNode.nextNodes[0]);
                    } else if (this.trainedList.contains(actualNode.nextNodes[0])) {
                        actualNode.nextNodes[0] = this.trainedList.get(this.trainedList.indexOf(actualNode.nextNodes[0]));
                    }
                    if (actualNode.nextNodes[1].classes.size() > 1 && !this.trainedList.contains(actualNode.nextNodes[1])) {
                        recNodes.add(actualNode.nextNodes[1]);
                        this.trainedList.add(actualNode.nextNodes[1]);
                    } else if (this.trainedList.contains(actualNode.nextNodes[1])) {
                        actualNode.nextNodes[1] = this.trainedList.get(this.trainedList.indexOf(actualNode.nextNodes[1]));
                    }
                    Collections.sort(actualNode.nextNodes[0].classes);
                    Collections.sort(actualNode.nextNodes[1].classes);
                }
            }
            if (recNodes.size() > 0) {
                actualNode = (Node)recNodes.get(0);
                recNodes.remove(0);
                continue;
            }
            actualNode = null;
        }
    }

    private double[] distances(Node node) {
        int j;
        int nInputs = this.classifier.train.getnInputs();
        double[] meanNode = new double[nInputs];
        double[] dist = new double[node.classes.size()];
        int i = 0;
        while (i < nInputs) {
            meanNode[i] = 0.0;
            for (j = 0; j < this.nClasses; ++j) {
                if (!node.classes.contains(new Integer(j))) continue;
                int n = i;
                meanNode[n] = meanNode[n] + this.averagePerClass[j][i];
            }
            int n = i++;
            meanNode[n] = meanNode[n] / (double)node.classes.size();
        }
        for (i = 0; i < dist.length; ++i) {
            dist[i] = 0.0;
            for (j = 0; j < meanNode.length; ++j) {
                double aux = this.averagePerClass[node.classes.get(i)][j];
                if (aux == this.classifier.train.average(j)) {
                    int n = i;
                    dist[n] = dist[n] + 1.0;
                    continue;
                }
                int n = i;
                dist[n] = dist[n] + (meanNode[j] - this.averagePerClass[node.classes.get(i)][j]) * (meanNode[j] - this.averagePerClass[node.classes.get(i)][j]);
            }
            dist[i] = Math.sqrt(dist[i]);
        }
        return dist;
    }

    public String computeClass(double[] ejemplo) {
        String output = this.root.obtainClass(ejemplo);
        return output;
    }

    private class Node {
        int i;
        int j;
        ArrayList<Integer> classes = new ArrayList();
        Node[] nextNodes;

        public Node() {
            for (int k = 0; k < BTS.this.classifier.nClasses; ++k) {
                this.classes.add(new Integer(k));
            }
        }

        public Node(int c) {
            this.classes.add(new Integer(c));
        }

        public void add(int clase) {
            Integer n = new Integer(clase);
            if (!this.classes.contains(n)) {
                this.classes.add(n);
            }
        }

        public boolean equals(Object o) {
            if (o instanceof Node) {
                Node node = (Node)o;
                Collections.sort(node.classes);
                Collections.sort(this.classes);
                if (node.i == this.i && node.j == this.j && this.classes.equals(node.classes)) {
                    return true;
                }
            }
            return false;
        }

        public void constructNextNodes() {
            int k;
            int[] outputs = BTS.this.classifier.train.getOutputAsInteger();
            this.nextNodes = new Node[2];
            this.nextNodes[0] = new Node(this.i);
            this.nextNodes[1] = new Node(this.j);
            double[] thresholds = new double[BTS.this.nClasses];
            for (k = 0; k < BTS.this.nClasses; ++k) {
                thresholds[k] = Double.MAX_VALUE;
            }
            for (k = 0; k < BTS.this.classifier.train.getnData(); ++k) {
                double t;
                int clase = outputs[k];
                if (!this.classes.contains(new Integer(clase)) || clase == this.i || clase == this.j) continue;
                double[] ejemplo = BTS.this.classifier.train.getExample(k);
                double[] sal = BTS.this.classifier.obtainConfidence(this.i, this.j, ejemplo);
                if (sal[0] > sal[1]) {
                    this.nextNodes[0].add(clase);
                    t = sal[0] - 0.5;
                    if (!(t < thresholds[clase])) continue;
                    thresholds[clase] = t;
                    continue;
                }
                if (sal[0] < sal[1]) {
                    this.nextNodes[1].add(clase);
                    t = sal[0] - 0.5;
                    if (!(t < thresholds[clase])) continue;
                    thresholds[clase] = t;
                    continue;
                }
                this.nextNodes[1].classes = this.classes;
                this.nextNodes[0].classes = this.classes;
                return;
            }
            for (k = 0; k < BTS.this.nClasses; ++k) {
                Integer c = new Integer(k);
                if (!this.classes.contains(c) || this.i == k || this.j == k) continue;
                if (this.nextNodes[0].classes.contains(c) && !this.nextNodes[1].classes.contains(c) && thresholds[k] < (double)BTS.this.threshold) {
                    this.nextNodes[1].add(k);
                    continue;
                }
                if (this.nextNodes[0].classes.contains(c) || !this.nextNodes[1].classes.contains(c) || !(thresholds[k] < (double)BTS.this.threshold)) continue;
                this.nextNodes[0].add(k);
            }
        }

        public String obtainClass(double[] ejemplo) {
            if (this.nextNodes == null) {
                if (this.classes.size() == 1) {
                    return BTS.this.classifier.train.getOutputValue(this.classes.get(0));
                }
                double[][] tabla = new double[BTS.this.nClasses][BTS.this.nClasses];
                for (int k = 0; k < BTS.this.nClasses; ++k) {
                    for (int t = k + 1; t < BTS.this.nClasses; ++t) {
                        if (!this.classes.contains(new Integer(k)) || !this.classes.contains(new Integer(t))) continue;
                        int sal = BTS.this.classifier.obtainClass(k, t, ejemplo);
                        if (sal == k) {
                            tabla[k][t] = 1.0;
                            continue;
                        }
                        if (sal != t) continue;
                        tabla[t][k] = 1.0;
                    }
                }
                double[] max = new double[BTS.this.nClasses];
                for (int k = 0; k < BTS.this.nClasses; ++k) {
                    double sum_clase = 0.0;
                    for (int t = 0; t < BTS.this.nClasses; ++t) {
                        sum_clase += tabla[k][t];
                    }
                    max[k] = sum_clase;
                }
                return BTS.this.classifier.ovo.getOutputTies(max);
            }
            int clase = BTS.this.classifier.obtainClass(this.i, this.j, ejemplo);
            if (clase == this.i) {
                return this.nextNodes[0].obtainClass(ejemplo);
            }
            if (clase == this.j) {
                return this.nextNodes[1].obtainClass(ejemplo);
            }
            double[] cs = new double[BTS.this.nClasses];
            for (int k = 0; k < this.classes.size(); ++k) {
                cs[this.classes.get((int)k).intValue()] = 1.0;
            }
            return BTS.this.ovo.getOutputTies(cs);
        }
    }
}

