/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Discretizers.Id3_Discretizer;

import java.util.Vector;
import keel.Algorithms.Discretizers.Basic.Discretizer;
import keel.Algorithms.Genetic_Rule_Learning.Globals.Parameters;

public class Id3Discretizer
extends Discretizer {
    @Override
    protected Vector discretizeAttribute(int attribute, int[] values, int begin, int end) {
        Vector cd = this.classDistribution(attribute, values, begin, end);
        if (cd.size() == 1) {
            return new Vector();
        }
        int numValues = this.sumValues(cd);
        double entAll = this.computeEntropy(cd, numValues);
        Vector candidateCutPoints = this.getCandidateCutPoints(attribute, values, begin, end);
        if (candidateCutPoints.size() == 0) {
            return new Vector();
        }
        int posMin = (Integer)candidateCutPoints.elementAt(0);
        double entMin = this.computePartitionEntropy(attribute, values, begin, posMin, end);
        int size = candidateCutPoints.size();
        for (int i = 1; i < size; ++i) {
            int pos = (Integer)candidateCutPoints.elementAt(i);
            double ent = this.computePartitionEntropy(attribute, values, begin, pos, end);
            if (!(ent < entMin)) continue;
            entMin = ent;
            posMin = pos;
        }
        if (entMin < entAll) {
            Vector res1 = this.discretizeAttribute(attribute, values, begin, posMin - 1);
            double cutPoint = (this.realValues[attribute][values[posMin - 1]] + this.realValues[attribute][values[posMin]]) / 2.0;
            res1.addElement(new Double(cutPoint));
            Vector res2 = this.discretizeAttribute(attribute, values, posMin, end);
            res1.addAll(res2);
            return res1;
        }
        return new Vector();
    }

    double computePartitionEntropy(int attribute, int[] values, int begin, int midPoint, int end) {
        Vector cd1 = this.classDistribution(attribute, values, begin, midPoint - 1);
        Vector cd2 = this.classDistribution(attribute, values, midPoint, end);
        int numValues1 = this.sumValues(cd1);
        int numValues2 = this.sumValues(cd2);
        double ent1 = this.computeEntropy(cd1, numValues1);
        double ent2 = this.computeEntropy(cd2, numValues2);
        return ((double)numValues1 * ent1 + (double)numValues2 * ent2) / (double)(numValues1 + numValues2);
    }

    double computeEntropy(Vector v, int numValues) {
        double ent = 0.0;
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            double prob = ((Integer)v.elementAt(i)).intValue();
            ent += (prob /= (double)numValues) * Math.log(prob) / Math.log(2.0);
        }
        return -ent;
    }

    int sumValues(Vector v) {
        int sum = 0;
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            sum += ((Integer)v.elementAt(i)).intValue();
        }
        return sum;
    }

    Vector getCandidateCutPoints(int attribute, int[] values, int begin, int end) {
        Vector<Integer> cutPoints = new Vector<Integer>();
        double valueAnt = this.realValues[attribute][values[begin]];
        for (int i = begin; i <= end; ++i) {
            double val = this.realValues[attribute][values[i]];
            if (val != valueAnt) {
                cutPoints.addElement(new Integer(i));
            }
            valueAnt = val;
        }
        return cutPoints;
    }

    Vector classDistribution(int attribute, int[] values, int begin, int end) {
        int i;
        int[] classCount = new int[Parameters.numClasses];
        for (i = 0; i < Parameters.numClasses; ++i) {
            classCount[i] = 0;
        }
        for (i = begin; i <= end; ++i) {
            int n = this.classOfInstances[values[i]];
            classCount[n] = classCount[n] + 1;
        }
        Vector<Integer> res = new Vector<Integer>();
        for (int i2 = 0; i2 < Parameters.numClasses; ++i2) {
            if (classCount[i2] <= 0) continue;
            res.addElement(new Integer(classCount[i2]));
        }
        return res;
    }
}

