/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.reloading;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.configuration.ConfigurationUtils;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.commons.configuration.reloading.ReloadingStrategy;

public class FileChangedReloadingStrategy
implements ReloadingStrategy {
    private static final String JAR_PROTOCOL = "jar";
    private static final int DEFAULT_REFRESH_DELAY = 5000;
    protected FileConfiguration configuration;
    protected long lastModified;
    protected long lastChecked;
    protected long refreshDelay = 5000L;

    public void setConfiguration(FileConfiguration configuration) {
        this.configuration = configuration;
    }

    public void init() {
        this.updateLastModified();
    }

    public boolean reloadingRequired() {
        boolean reloading = false;
        long now = System.currentTimeMillis();
        if (now > this.lastChecked + this.refreshDelay) {
            this.lastChecked = now;
            if (this.hasChanged()) {
                reloading = true;
            }
        }
        return reloading;
    }

    public void reloadingPerformed() {
        this.updateLastModified();
    }

    public long getRefreshDelay() {
        return this.refreshDelay;
    }

    public void setRefreshDelay(long refreshDelay) {
        this.refreshDelay = refreshDelay;
    }

    protected void updateLastModified() {
        File file = this.getFile();
        if (file != null) {
            this.lastModified = file.lastModified();
        }
    }

    protected boolean hasChanged() {
        File file = this.getFile();
        if (file == null || !file.exists()) {
            return false;
        }
        return file.lastModified() > this.lastModified;
    }

    protected File getFile() {
        return this.configuration.getURL() != null ? this.fileFromURL(this.configuration.getURL()) : this.configuration.getFile();
    }

    private File fileFromURL(URL url) {
        if (JAR_PROTOCOL.equals(url.getProtocol())) {
            String path = url.getPath();
            try {
                return ConfigurationUtils.fileFromURL(new URL(path.substring(0, path.indexOf(33))));
            }
            catch (MalformedURLException mex) {
                return null;
            }
        }
        return ConfigurationUtils.fileFromURL(url);
    }
}

