---
output:
  pdf_document: default
  html_document: default
---
# Release notes:

Full reference to all functions available at [`grafify` GitHub pages](https://ashenoy-cmbi.github.io/grafify/index.html).

# grafify v2.2.0

## New features

`plot_3d_scatterviolin` and `plot_4d_scatterviolin` for one-way or two-way ANOVA design data to plot scatter plots with violins with box and whiskers. 

## Minor fixes

`plot_qqmodel` no longer relies on `broom.mixed`; instead uses `rstudent` from the base `stats` package to generate studentized residuals from a model.

# grafify v2.1.0

## New features

New experimental functions to compare slopes of linear regression via `posthoc_Trends_Pairwise`, `posthoc_Trends_Levelwise` and `posthoc_Trends_vsRef`.

## Minor fixes

Minor changes to `plot_qqmodel` and `plot_qqline` to fix some OS-specific errors. QQ plots by default will have `ok_orange` colour within symbols when only one level is present within `group`. Both functions now use `geom_qq` and `geom_qq_line` (instead of `stat_qq` and `stat_qq_line`) internally.

# grafify v2.0.0

This is a major update with some new features, bugfixes, and further cleaning up of code with consistent names of arguments in preparation for CRAN submission. Some previous code may not work because of renaming of some arguments for grouping variables in `plot_` functions. But older arguments are retained with deprecation warnings in most cases, so old code should largely work.

## New features

  a. `plot_` functions have a new argument `ColSeq` (logical TRUE/FALSE) that picks colours sequentially from palette chosen by `ColPal` when `TRUE` (default). If set to `FALSE`, the most distant colours are chosen, as already implemented in `scale_..._grafify2` functions.
  b. Violin plots get a major face-lift with a box-whiskers plot on top of the violin. This gives a clearer picture of data and dispersion than the default quantile lines in `geom_violin`. They also get new arguments to set thickness of lines (`bvthick`) and transparency of boxplots (`b_alpha`).
  c. There are new functions for fitting linear models with varying slopes and intercepts. These are `mixed_model_slopes` and `mixed_anova_slopes`.
  d. A function for comparing slopes of linear fits `posthoc_Trends` implements the `emmeans::emtrends` call.  
  e. Most `plot_` functions now have the `...` argument forwarding dots for advanced users to add arguments to `ggplot` geometries where necessary.
  f. New `plot_grafify_palette` function that helps quickly visualise colours in palettes along with their names and hexcodes.
  g. `plot_bar_sd` and `plot_bar_sd_sc` have a new argument `bthick` to adjust the thickness of lines of the bars.

## Bug fixes

  a. Distribution plots: the The `Group` grouping argument in `plot_density`, `plot_histogram` and `plot_qqline` is now called `group` for consistency with other `plot_` functions.
  c. The `Factor` argument in post-hoc comparisons functions (`posthoc_Pairwise`, `posthoc_vsRes`, and `posthoc_Levelwise`) renamed as `Fixed_Factor` to be consistent with `mixed_model`, `simple_model`, `mixed_anova` and `simple_anova` functions.
  d. The `plot_3d_scatterbar` and `plot_3d_scatterbox` now correctly plot one-way ANOVA designs with randomised blocks with `shapes` mapped to levels of the random factor, and `xcol` as the grouping factor as originally intended but incorrectly implemented. This complements `plot_4d_scatterbar` and `plot_4d_scatterbox` which take two grouping factors and a random factor.
  e. Examples in help files have arguments explicitly labelled to make them easier to follow.
  f. `groups` in before-after plots is now called `match` as it is a bit more informative when showing matched data. 
  g. For consistency, the argument for controlling opacity in distribution plots is renamed `c_alpha` in `plot_density` and `plot_histogram` (for colour opacity of colours under the density curve or histogram); opacity of symbols in `plot_qqline` is still called `s_alpha`.


# grafify v1.5.1

This update fixes and cleans up code to remove all errors, warnings and notes from `devtools::check()`. All previous code should still work. 

 a. The main update is that `broom.mixed::augment` is used to get model residuals than the `fortify` method as this will be deprecated soon. The `broom.mixed` package therefore required. 
 b. The way ANOVA table is generated no longer relies on an internal function from `lmerTest`, but instead forces a mixed model object as `lmerModLmerTest` object to get F and P values in ANOVA tables from the `stats::anova` call.
 c. The `magrittr` package is required for internal use of pipes (`%>%`).
 d. Much of the code for `simple_model` and `mixed_model` was cleaned up so that model outputs are as close to objects generated by native calls to `lm` or `lmer`.
 e. Several internal functions related to the colour palettes have now been exported as this was easier.
 f. The `make_1w_rb_data` and `make_2w_rb_data` functions have been updated to have consistent factor and level names.

# grafify v1.5.0

## Major fixes 

1. New graph types

This version has 8 new `plot_` functions ending in `_sc` for plotting data with two variables wherein the X variable is plotted in a single colour. This contrasts existing versions that plot the X variable with multiple colours chosen from the `all_grafify` palette. This is convenient when there are too many groups on the X axis and multiple colours are not necessary.

2. Plotting Q-Q plot of model residuals

`plot_qqmodel` will plot a diagnostic Q-Q plot of a simple linear model (generated with `simple_model` or `lm`) or mixed effects linear model (generated with `mixed_model` or `lmer`) in a single step.

## Minor fixes

Fixed a typo in `posthoc_Levelwise` where the `adjust` argument was not being correctly passed on to `emmeans`.


# grafify v1.4.1

This version "breaks" a few arguments from v0.3.1, therefore is v1.4.1. Specifically, opacity for both symbols and bars/boxes/violins can be set using `s_alpha` and `b_alpha` or `v_alpha`, respectively; previously, only bars/boxes/violin opacity could be set with a single `alpha` parameter. Old code with just `alpha` will no longer work, sorry! There are also new graph types and arguments for ANOVAs as below.

## Major fixes 

1. New graph types
   
    a. `plot_density` and `plot_histogram` for smooth density or histogram plots through `geom_density` and `geom_histogram` respectively.
    b. two new plot types `plot_scatterbox` and `plot_scatterviolin` that complement the `plot_dot...` versions and instead use `geom_point` with `position_jitter`. These versions are useful when a large number of data points are needed to be plotted.
    
1. Updates 

      a. `simple_anova` where the table also has Mean SS.
      b. `mixed_anova` now has two new arguments, one to change method for Df calculation and second to get type I or III SS (default is type II).
      c. `jitter` argument added to `plot_3d..` and `plot_4d..` functions for consistency with other scatter plots.
      d. `bwid` argument (for adjusting width of bars) added to `plot_scatterbar_sd` for consistency.

# grafify v0.3.1

Bug fixes in `mixed_model` and `simple_model` which now correctly lists the data used in the call field. 

# grafify v0.3.0

1. A new `plot_4d_scatterbar` function which is like `plot_4d_scatterbox` but plots bar and SD. So there are now two `plot_3d_` and `plot_4d_` functions.
2. Text on X-axis on all graphs can be rotated from 0-90 using `TextXAngle` argument to prevent overlap. 
3. `plot_dot_` functions now have `dotthick` option to set stroke thickness. This is similar to `symthick` for scatter/jitter plots.
4. Using `facet_wrap` or `facet_grid` will not draw a box around panel text (unlike the default in `theme_classic()`).
5. `plot_3d_` and `plot_4d_` functions draw symbols in black colour. 

# grafify v0.2.1:

1. Bug fixes in `plot_3d_scatterbar` and `plot_3d_scatterbox`, which now correctly use the "shapes" variable to fill colour of bars/boxes and shape of the symbols; symbols are depicted in black.
2. `simple_anova` generates type II ANOVA table through `car::Anova()`, so the `car` package is now a dependency. v0.1.0 and v0.2.0 generated type I ANOVA table through `stats::anova()`. 

# grafify v0.2.0:

1. the main difference from v0.1.0 is that all `plot_` functions apply the `all_grafify` colour scheme by default (see `plot_` vignettes on how to change colours)
2. two new types of graphs are possible with two quantitative X-Y plots with a third variable that is either numeric (`plot_xy_NumGroup`) or categorical (`plot_xy_CatGroup`).
3. there are two new continuous colour schemes (`scale_fill_grafify_c` and `scale_colour_grafify_c`), based on [Paul Tol's variant](https://personal.sron.nl/~pault/#sec:sequential) of YlOrBl scheme.

# grafify v0.1.0

First release. 
