/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.formula;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.formula.rules.IRule;
import org.openscience.cdk.interfaces.IMolecularFormula;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class MolecularFormulaChecker {
    private ILoggingTool logger = LoggingToolFactory.createLoggingTool(MolecularFormulaChecker.class);
    private List<IRule> rules;

    public MolecularFormulaChecker(List<IRule> rules) {
        this.rules = rules;
    }

    public List<IRule> getRules() {
        return this.rules;
    }

    public Double isValidSum(IMolecularFormula formula) {
        double result = 1.0;
        IMolecularFormula formulaWith = this.isValid(formula);
        Map<Object, Object> properties = formulaWith.getProperties();
        Iterator<IRule> iterRules = this.rules.iterator();
        while (iterRules.hasNext()) {
            result *= ((Double)properties.get(iterRules.next().getClass())).doubleValue();
        }
        return result;
    }

    public IMolecularFormula isValid(IMolecularFormula formula) {
        this.logger.info("Generating the validity of the molecular formula");
        if (formula.getIsotopeCount() == 0) {
            this.logger.error("Proposed molecular formula has not elements");
            return formula;
        }
        Iterator<IRule> iterRules = this.rules.iterator();
        try {
            while (iterRules.hasNext()) {
                IRule rule = iterRules.next();
                double result = rule.validate(formula);
                formula.setProperty(rule.getClass(), result);
            }
        }
        catch (CDKException e) {
            e.printStackTrace();
        }
        return formula;
    }
}

